/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityAreaFiller;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFlooder
extends TileEntityAreaFiller
implements IFluidHandler,
PipeConnector {
    private final HybridTank tank = new HybridTank("flooder", 4000);

    private Block getFluidID() {
        return !this.tank.isEmpty() && this.tank.getActualFluid().canBePlacedInWorld() ? this.tank.getActualFluid().getBlock() : null;
    }

    private boolean canTakeLiquid(Fluid f) {
        if (!f.canBePlacedInWorld()) {
            return false;
        }
        if (this.tank.isEmpty()) {
            return true;
        }
        return this.tank.getActualFluid().equals(f);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.SPILLER;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p) && side != ForgeDirection.DOWN;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.tank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from != ForgeDirection.DOWN && fluid.canBePlacedInWorld();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side != ForgeDirection.DOWN ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }

    @Override
    protected boolean hasRemainingBlocks() {
        return this.tank.getLevel() >= 1000;
    }

    @Override
    protected void onBlockPlaced() {
        this.tank.drain(1000, true);
    }

    @Override
    protected BlockKey getNextPlacedBlock() {
        Block b = this.getFluidID();
        return b != null ? new BlockKey(b, 0) : null;
    }

    @Override
    protected long getRequiredPower() {
        int visc = this.tank.getActualFluid().getViscosity();
        return Math.max(128, 512 * visc / 1000);
    }

    @Override
    public int getOperationTime() {
        int base = super.getOperationTime();
        if (this.tank.isEmpty()) {
            return base;
        }
        return MathHelper.func_76125_a((int)(base * this.tank.getActualFluid().getViscosity() / 1000), (int)(base / 4), (int)(base * 4));
    }

    @Override
    protected boolean allowFluidOverwrite() {
        return false;
    }
}

