/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.World;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Block.SemiTransparent;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Base.TileEntity.TileEntityBeamMachine;
import Reika.RotaryCraft.Registry.BlockRegistry;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import Reika.RotaryCraft.RotaryCraft;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFloodlight
extends TileEntityBeamMachine
implements RangedEffect,
BreakAction {
    public static final int MAX_RANGE = Math.max(64, ConfigRegistry.FLOODLIGHTRANGE.getValue());
    public boolean beammode = false;
    public boolean fresnel = false;
    private BlockArray beam = new BlockArray();
    private int lastRange = 0;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        if (this.fresnel) {
            this.beammode = false;
        }
        if (this.power >= this.MINPOWER) {
            RotaryAchievements.FLOODLIGHT.triggerAchievement(this.getPlacer());
        }
        this.power = (long)this.omega * (long)this.torque;
        if (!world.field_72995_K && (world.func_82737_E() & 8L) == 8L) {
            this.makeBeam(world, x, y, z, meta);
        }
    }

    @Override
    protected void makeBeam(World world, int x, int y, int z, int metadata) {
        Coordinate c;
        int i;
        int r = this.getRange();
        if (this.lastRange != r) {
            RotaryCraft.logger.debug((Object)("Updating " + this + " range from " + this.lastRange + " to " + r));
            for (i = 0; i < this.beam.getSize(); ++i) {
                c = this.beam.getNthBlock(i);
                Block b = c.getBlock((IBlockAccess)world);
                if (!this.isLightBlock(b)) continue;
                c.setBlock(world, Blocks.field_150350_a);
                world.func_147479_m(c.xCoord, c.yCoord, c.zCoord);
            }
            this.beam.clear();
            if (r > 0) {
                if (this.fresnel) {
                    ArrayList ds = ReikaDirectionHelper.getPerpendicularDirections((ForgeDirection)this.facing);
                    ForgeDirection d1 = (ForgeDirection)ds.get(0);
                    ForgeDirection d2 = (ForgeDirection)ds.get(1);
                    for (int d = 1; d <= r; ++d) {
                        int w = (d - 1) / 3;
                        if (d > 1) {
                            ++w;
                        }
                        for (int a = -w; a <= w; ++a) {
                            for (int b = -w; b <= w; ++b) {
                                int dx = x + this.facing.offsetX * d + d1.offsetX * a + d2.offsetX * b;
                                int dy = y + this.facing.offsetY * d + d1.offsetY * a + d2.offsetY * b;
                                int dz = z + this.facing.offsetZ * d + d1.offsetZ * a + d2.offsetZ * b;
                                this.beam.addIfClear(world, dx, dy, dz);
                            }
                        }
                    }
                } else {
                    this.beam.addLineOfClear(world, x, y, z, r, this.facing.offsetX, this.facing.offsetY, this.facing.offsetZ);
                }
            }
            this.lastRange = r;
        }
        for (i = 0; i < this.beam.getSize(); ++i) {
            c = this.beam.getNthBlock(i);
            if (c.getBlock((IBlockAccess)world) == Blocks.field_150350_a) {
                c.setBlock(world, this.getPlacedBlockID(), 15);
            }
            world.func_147479_m(c.xCoord, c.yCoord, c.zCoord);
        }
    }

    private Block getPlacedBlockID() {
        return this.beammode ? BlockRegistry.BEAM.getBlockInstance() : BlockRegistry.LIGHT.getBlockInstance();
    }

    private boolean isLightBlock(Block id) {
        return id == BlockRegistry.BEAM.getBlockInstance() || id == BlockRegistry.LIGHT.getBlockInstance();
    }

    public void lightsOut(World world, int x, int y, int z) {
        world.func_147471_g(x, y, z);
        world.func_147459_d(x, y, z, this.getTileEntityBlockID());
        for (int i = 0; i < this.beam.getSize(); ++i) {
            Coordinate c = this.beam.getNthBlock(i);
            Block b = c.getBlock((IBlockAccess)world);
            if (!this.isLightBlock(b)) continue;
            c.setBlock(world, Blocks.field_150350_a);
            world.func_147479_m(c.xCoord, c.yCoord, c.zCoord);
            world.func_147471_g(c.xCoord, c.yCoord, c.zCoord);
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("beam", this.beammode);
        NBT.func_74757_a("lens", this.fresnel);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.beammode = NBT.func_74767_n("beam");
        this.fresnel = NBT.func_74767_n("lens");
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public int getRange() {
        if (this.power < this.MINPOWER) {
            return 0;
        }
        int ir = this.getMaxRange();
        for (int i = 1; i <= ir; ++i) {
            SemiTransparent sm;
            int dx = this.field_145851_c + i * this.facing.offsetX;
            int dy = this.field_145848_d + i * this.facing.offsetY;
            int dz = this.field_145849_e + i * this.facing.offsetZ;
            Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
            if (b == Blocks.field_150350_a || !(b instanceof SemiTransparent ? (sm = (SemiTransparent)b).isOpaque(this.field_145850_b.func_72805_g(dx, dy, dz)) : b.func_149662_c())) continue;
            return i;
        }
        return ir;
    }

    @Override
    public MachineRegistry getTile() {
        return MachineRegistry.FLOODLIGHT;
    }

    @Override
    public int getMaxRange() {
        return this.fresnel ? 24 : MAX_RANGE;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    public void breakBlock() {
        this.lightsOut(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.fresnel) {
            ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)ItemStacks.lens);
        }
    }
}

