/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.ModBlocks;
import de.maxhenkel.gravestone.ModItems;
import de.maxhenkel.gravestone.tileentity.TileEntityGraveStone;
import de.maxhenkel.gravestone.util.BlockPos;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public class BlockEvents {
    private boolean removeDeathNote;
    private boolean onlyOwnersCanBreak;

    public BlockEvents() {
        this.removeDeathNote = Config.instance().removeDeathNote;
        this.onlyOwnersCanBreak = Config.instance().onlyPlayersCanBreak;
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (event.isCanceled()) {
            return;
        }
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        if (!event.placedBlock.equals((Object)ModBlocks.GRAVESTONE)) {
            return;
        }
        TileEntity te = event.world.func_147438_o(event.x, event.y, event.z);
        if (!(te instanceof TileEntityGraveStone)) {
            return;
        }
        TileEntityGraveStone graveTileEntity = (TileEntityGraveStone)te;
        ItemStack stack = event.itemInHand;
        if (stack == null || !stack.func_77973_b().equals((Object)ModItems.GRAVESTONE)) {
            return;
        }
        if (!stack.func_82837_s()) {
            return;
        }
        String name = stack.func_82833_r();
        if (name == null) {
            return;
        }
        graveTileEntity.setPlayerName(name);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        this.removeDeathNote(event);
        this.checkBreak(event);
    }

    public void removeDeathNote(BlockEvent.BreakEvent event) {
        ItemStack stack;
        int i;
        if (!this.removeDeathNote) {
            return;
        }
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        if (!event.block.equals((Object)ModBlocks.GRAVESTONE)) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        InventoryPlayer inv = player.field_71071_by;
        BlockPos pos = new BlockPos(event.x, event.y, event.z);
        int dim = player.field_71093_bK;
        for (i = 0; i < inv.field_70462_a.length; ++i) {
            DeathInfo info;
            stack = inv.field_70462_a[i];
            if (stack == null || !stack.func_77973_b().equals((Object)ModItems.DEATH_INFO) || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("info") || (info = DeathInfo.fromNBT(stack.func_77978_p().func_74775_l("info"))) == null || dim != info.getDimension() || !pos.equals(info.getDeathLocation())) continue;
            inv.func_70299_a(i, null);
        }
        for (i = 0; i < inv.field_70460_b.length; ++i) {
            stack = inv.field_70462_a[i];
            if (stack == null || !stack.func_77973_b().equals((Object)ModItems.DEATH_INFO)) continue;
            inv.func_70299_a(i, null);
        }
    }

    public void checkBreak(BlockEvent.BreakEvent event) {
        EntityPlayerMP p;
        boolean isOp;
        if (!this.onlyOwnersCanBreak) {
            return;
        }
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        if (!event.block.equals((Object)ModBlocks.GRAVESTONE)) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        TileEntity te = world.func_147438_o(event.x, event.y, event.z);
        if (te == null || !(te instanceof TileEntityGraveStone)) {
            return;
        }
        TileEntityGraveStone tileentity = (TileEntityGraveStone)te;
        String uuid = tileentity.getPlayerUUID();
        if (uuid == null) {
            return;
        }
        if (player.func_110124_au().toString().equals(uuid)) {
            return;
        }
        if (!(player instanceof EntityPlayerMP)) {
            event.setCanceled(true);
        }
        if (!(isOp = (p = (EntityPlayerMP)player).func_70003_b(p.field_71133_b.func_110455_j(), "op"))) {
            event.setCanceled(true);
        }
    }
}

