/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.asm.transformers;

import net.darkhax.bookshelf.asm.ASMHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityLivingBaseTransformer {
    public static byte[] transform(String name, String transformedName, byte[] bytes) {
        ClassNode itemClass = ASMHelper.createClassFromByteArray(bytes);
        if (ASMHelper.hasClassMethodName(itemClass, "curePotionEffects")) {
            EntityLivingBaseTransformer.transformcurePotionEffects(ASMHelper.getMethodFromClass(itemClass, "curePotionEffects", "(Lnet/minecraft/item/ItemStack;)V"));
        }
        if (ASMHelper.hasClassMethodName(itemClass, "onNewPotionEffect")) {
            EntityLivingBaseTransformer.transform(ASMHelper.getMethodFromClass(itemClass, "onNewPotionEffect", "(Lnet/minecraft/potion/PotionEffect;)V"), "onNewPotionEffect");
        }
        if (ASMHelper.hasClassMethodName(itemClass, "onChangedPotionEffect")) {
            EntityLivingBaseTransformer.transform(ASMHelper.getMethodFromClass(itemClass, "onChangedPotionEffect", "(Lnet/minecraft/potion/PotionEffect;Z)V"), "onChangedPotionEffect");
        }
        if (ASMHelper.hasClassMethodName(itemClass, "onFinishedPotionEffect")) {
            EntityLivingBaseTransformer.transform(ASMHelper.getMethodFromClass(itemClass, "onFinishedPotionEffect", "(Lnet/minecraft/potion/PotionEffect;)V"), "onFinishedPotionEffect");
        }
        return ASMHelper.createByteArrayFromClass(itemClass, 1);
    }

    private static void transformcurePotionEffects(MethodNode method) {
        InsnList newInsns = new InsnList();
        LabelNode start = new LabelNode();
        newInsns.add((AbstractInsnNode)start);
        newInsns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInsns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        newInsns.add((AbstractInsnNode)new MethodInsnNode(184, "net/darkhax/bookshelf/handler/BookshelfHooks", "onPotionsCured", "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;)Z", false));
        LabelNode procede = new LabelNode();
        newInsns.add((AbstractInsnNode)new JumpInsnNode(153, procede));
        LabelNode exit = new LabelNode();
        newInsns.add((AbstractInsnNode)exit);
        newInsns.add((AbstractInsnNode)new InsnNode(177));
        newInsns.add((AbstractInsnNode)procede);
        method.instructions.insertBefore(method.instructions.getFirst(), newInsns);
    }

    private static void transform(MethodNode method, String hook) {
        InsnList newInsns = new InsnList();
        newInsns.add((AbstractInsnNode)new VarInsnNode(25, 1));
        newInsns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        newInsns.add((AbstractInsnNode)new MethodInsnNode(184, "net/darkhax/bookshelf/handler/BookshelfHooks", hook, "(Lnet/minecraft/potion/PotionEffect;Lnet/minecraft/entity/EntityLivingBase;)V", false));
        method.instructions.insertBefore(method.instructions.getFirst(), newInsns);
    }
}

