/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.darkhax.bookshelf.lib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiNotification
extends Gui {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("textures/gui/achievement/achievement_background.png");
    private Minecraft minecraft;
    private int width;
    private int height;
    private String title;
    private String description;
    private long notificationTime;
    private RenderItem itemRenderer;
    private ItemStack iconStack;
    private ResourceLocation iconLocation;

    public GuiNotification(Minecraft minecraft) {
        this.minecraft = minecraft;
        this.itemRenderer = new RenderItem();
    }

    public void updateNotification(String title, String description) {
        this.title = title;
        this.description = description;
        this.notificationTime = Minecraft.func_71386_F();
    }

    public void updateNotificationIcon(ResourceLocation iconLocation) {
        this.iconLocation = iconLocation;
    }

    public void updateNotificationIcon(ItemStack stack) {
        this.iconStack = stack;
    }

    private void updateNotificationScale() {
        GL11.glViewport((int)0, (int)0, (int)this.minecraft.field_71443_c, (int)this.minecraft.field_71440_d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        this.width = this.minecraft.field_71443_c;
        this.height = this.minecraft.field_71440_d;
        ScaledResolution scaledresolution = new ScaledResolution(this.minecraft, this.minecraft.field_71443_c, this.minecraft.field_71440_d);
        this.width = scaledresolution.func_78326_a();
        this.height = scaledresolution.func_78328_b();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
    }

    public void renderNotification() {
        if (this.notificationTime != 0L && Minecraft.func_71410_x().field_71439_g != null) {
            double progression = (double)(Minecraft.func_71386_F() - this.notificationTime) / 3000.0;
            if (progression < 0.0 || progression > 1.0) {
                this.notificationTime = 0L;
                return;
            }
            if (progression > 0.5) {
                progression = 0.5;
            }
            this.updateNotificationScale();
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            double slideDistance = progression * 2.0;
            if (slideDistance > 1.0) {
                slideDistance = 2.0 - slideDistance;
            }
            slideDistance *= 4.0;
            if ((slideDistance = 1.0 - slideDistance) < 0.0) {
                slideDistance = 0.0;
            }
            slideDistance *= slideDistance;
            slideDistance *= slideDistance;
            int posX = this.width - 160;
            int posY = 0 - (int)(slideDistance * 36.0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            this.minecraft.func_110434_K().func_110577_a(BACKGROUND);
            GL11.glDisable((int)2896);
            this.func_73729_b(posX, posY, 96, 202, 160, 32);
            this.minecraft.field_71466_p.func_78276_b(this.title, posX + 30, posY + 7, -256);
            this.minecraft.field_71466_p.func_78276_b(this.description, posX + 30, posY + 18, -1);
            RenderHelper.func_74520_c();
            GL11.glDisable((int)2896);
            GL11.glEnable((int)32826);
            GL11.glEnable((int)2903);
            GL11.glEnable((int)2896);
            if (this.iconStack != null) {
                this.itemRenderer.func_82406_b(this.minecraft.field_71466_p, this.minecraft.func_110434_K(), this.iconStack, posX + 8, posY + 8);
            } else if (this.iconLocation != null) {
                this.minecraft.field_71446_o.func_110577_a(this.iconLocation);
                RenderUtils.drawTextureModalRectSize(posX + 8, posY + 8, 0, 0, 16, 16, 16.0f, 1.0f);
            }
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2929);
        }
    }

    public void stopNotification() {
        this.notificationTime = 0L;
        this.title = null;
        this.description = null;
        this.iconLocation = null;
        this.iconStack = null;
    }
}

