/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.handler;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.event.CreativeTabEvent;
import net.darkhax.bookshelf.event.ItemEnchantedEvent;
import net.darkhax.bookshelf.event.PotionCuredEvent;
import net.darkhax.bookshelf.event.PotionEffectEvent;
import net.darkhax.bookshelf.lib.Tuple;
import net.darkhax.bookshelf.lib.util.Utilities;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.MinecraftForge;

public class BookshelfHooks {
    public static List<Tuple> conflictingPotions = new ArrayList<Tuple>();

    public static List<EnchantmentData> onItemEnchanted(EntityPlayer player, ItemStack stack, int levels, List<EnchantmentData> enchantments) {
        if (enchantments != null) {
            ItemEnchantedEvent event = new ItemEnchantedEvent(player, stack, levels, enchantments);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.enchantments;
        }
        return enchantments;
    }

    public static boolean onCreativeTabDisplayPre(CreativeTabs tab, List itemList) {
        return MinecraftForge.EVENT_BUS.post((Event)new CreativeTabEvent.Pre(tab, itemList));
    }

    public static void onCreativeTabDisplayPost(CreativeTabs tab, List itemList) {
        MinecraftForge.EVENT_BUS.post((Event)new CreativeTabEvent.Post(tab, itemList));
    }

    public static boolean onPotionsCured(EntityLivingBase entity, ItemStack cureItem) {
        return MinecraftForge.EVENT_BUS.post((Event)new PotionCuredEvent(entity, cureItem));
    }

    public static void onPotionConstructed(Potion potion) {
        if (potion != null && Utilities.getPotion(potion.field_76415_H) != null && Loader.instance() != null && Loader.instance().activeModContainer() != null) {
            conflictingPotions.add(new Tuple(Loader.instance().activeModContainer().getName(), potion));
        }
    }

    public static void onNewPotionEffect(PotionEffect potion, EntityLivingBase entity) {
        MinecraftForge.EVENT_BUS.post((Event)new PotionEffectEvent.PotionEffectStartEvent(potion, entity));
    }

    public static void onChangedPotionEffect(PotionEffect potion, EntityLivingBase entity) {
        MinecraftForge.EVENT_BUS.post((Event)new PotionEffectEvent.PotionEffectChangeEvent(potion, entity));
    }

    public static void onFinishedPotionEffect(PotionEffect potion, EntityLivingBase entity) {
        MinecraftForge.EVENT_BUS.post((Event)new PotionEffectEvent.PotionEffectFinishEvent(potion, entity));
    }
}

