/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.lib.util;

import net.darkhax.bookshelf.lib.VanillaColor;
import net.darkhax.bookshelf.lib.util.NBTUtils;
import net.darkhax.bookshelf.lib.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemStackUtils {
    public static NBTTagCompound prepareDataTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static ItemStack setLore(ItemStack stack, String[] lore) {
        ItemStackUtils.prepareDataTag(stack);
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagList loreList = new NBTTagList();
        if (!tag.func_150297_b("display", 10)) {
            tag.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        for (String line : lore) {
            loreList.func_74742_a((NBTBase)new NBTTagString(line));
        }
        tag.func_74775_l("display").func_74782_a("Lore", (NBTBase)loreList);
        stack.func_77982_d(tag);
        return stack;
    }

    public static String writeStackToString(ItemStack stack) {
        return Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()) + "#" + stack.func_77960_j();
    }

    public static ItemStack createStackFromString(String stackString) {
        String[] parts = stackString.split("#");
        Object contents = Utilities.getThingByName(parts[0]);
        int damage = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
        return contents instanceof Item ? new ItemStack((Item)contents, 1, damage) : new ItemStack((Block)contents, 1, damage);
    }

    public static int getDyeColor(ItemStack stack) {
        if (ItemStackUtils.isValidStack(stack)) {
            for (VanillaColor color : VanillaColor.values()) {
                for (ItemStack oreStack : OreDictionary.getOres((String)color.getDyeName())) {
                    if (!oreStack.func_77969_a(stack)) continue;
                    return color.color.getRGB();
                }
            }
        }
        return -1337;
    }

    public static boolean isValidStack(ItemStack stack) {
        return stack != null && stack.func_77973_b() != null;
    }

    public static boolean compareStackToOreName(ItemStack stack, String oreName) {
        for (int stackName : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)stackName).equalsIgnoreCase(oreName)) continue;
            return true;
        }
        return false;
    }

    public static boolean doStacksShareOreName(ItemStack firstStack, ItemStack secondStack) {
        for (int firstName : OreDictionary.getOreIDs((ItemStack)firstStack)) {
            for (int secondName : OreDictionary.getOreIDs((ItemStack)secondStack)) {
                if (firstName != secondName) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areStacksSimilar(ItemStack firstStack, ItemStack secondStack) {
        return firstStack == null && secondStack == null ? true : ItemStackUtils.isValidStack(firstStack) && ItemStackUtils.isValidStack(secondStack) && firstStack.func_77960_j() == secondStack.func_77960_j() && firstStack.func_77973_b() == secondStack.func_77973_b();
    }

    public static boolean areStacksSimilarWithSize(ItemStack firstStack, ItemStack secondStack) {
        return firstStack == null && secondStack == null ? true : ItemStackUtils.isValidStack(firstStack) && ItemStackUtils.isValidStack(secondStack) && firstStack.func_77960_j() == secondStack.func_77960_j() && firstStack.func_77973_b() == secondStack.func_77973_b() && firstStack.field_77994_a == secondStack.field_77994_a;
    }

    public static int getItemColor(ItemStack stack) {
        return stack.func_77978_p().func_74764_b("bookshelfColor") ? stack.func_77978_p().func_74762_e("bookshelfColor") : 0xFFFFFF;
    }

    public static void setItemColor(ItemStack stack, int color) {
        ItemStackUtils.prepareDataTag(stack);
        stack.func_77978_p().func_74768_a("bookshelfColor", color);
    }

    public static void removeItemColor(ItemStack stack) {
        ItemStackUtils.prepareDataTag(stack);
        stack.func_77978_p().func_82580_o("bookshelfColor");
    }

    public static void writeStackToTag(ItemStack stack, NBTTagCompound tag, String tagName) {
        NBTTagCompound stackTag = new NBTTagCompound();
        stack.func_77955_b(stackTag);
        tag.func_74782_a(tagName, (NBTBase)stackTag);
    }

    public static ItemStack decreaseStackSize(ItemStack stack, int amount) {
        stack.field_77994_a -= amount;
        return stack.field_77994_a <= 0 ? null : stack;
    }

    public static boolean areStacksEqual(ItemStack firstStack, ItemStack secondStack, boolean checkNBT) {
        if (firstStack == null || secondStack == null) {
            return firstStack == secondStack;
        }
        Item firstItem = firstStack.func_77973_b();
        Item secondItem = secondStack.func_77973_b();
        if (firstItem == null || secondItem == null) {
            return firstItem == secondItem;
        }
        if (firstItem == secondItem) {
            if (checkNBT && NBTUtils.NBT_COMPARATOR.compare(firstStack.func_77978_p(), secondStack.func_77978_p()) != 0) {
                return false;
            }
            return firstStack.func_77960_j() == Short.MAX_VALUE || secondStack.func_77960_j() == Short.MAX_VALUE || firstStack.func_77960_j() == secondStack.func_77960_j();
        }
        return false;
    }

    public static boolean isStackInArray(ItemStack stack, boolean checkNBT, ItemStack ... stacks) {
        for (ItemStack currentStack : stacks) {
            if (!ItemStackUtils.areStacksEqual(stack, currentStack, checkNBT)) continue;
            return true;
        }
        return false;
    }
}

