/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.bookmark;

import codechicken.nei.BookmarkPanel;
import codechicken.nei.ItemSorter;
import codechicken.nei.bookmark.BookmarkGrid;
import codechicken.nei.bookmark.BookmarkGroup;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.bookmark.BookmarksGridSlot;
import codechicken.nei.bookmark.RecipeChainDetails;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BookmarkGridGenerator {
    protected final BookmarkGrid grid;
    public List<BookmarksGridSlot> gridMask = null;
    public final Map<Integer, Integer> rowToGroupId = new HashMap<Integer, Integer>();
    public final Map<Integer, Recipe.RecipeId> itemToRecipe = new HashMap<Integer, Recipe.RecipeId>();
    public final Map<Integer, Integer> slotToItem = new LinkedHashMap<Integer, Integer>();
    public final Map<Integer, Integer> itemToSlot = new LinkedHashMap<Integer, Integer>();
    public final Map<Integer, RecipeChainDetails.BookmarkChainItem> caclulatedItems = new HashMap<Integer, RecipeChainDetails.BookmarkChainItem>();
    public int pageCount = 0;
    public int maxAbsoluteSlotIndex = 0;

    public BookmarkGridGenerator(BookmarkGrid grid) {
        this.grid = grid;
    }

    public int getRowGroupId(int rowIndex) {
        int absoluteRowIndex = rowIndex + (this.grid.getPage() - 1) * this.grid.getRows();
        return this.rowToGroupId.getOrDefault(absoluteRowIndex, 0);
    }

    public void generate() {
        BookmarkItem prevBookmarkItem = null;
        HashMap<Integer, String> borderGrid = new HashMap<Integer, String>();
        int gridColumns = this.grid.getColumns();
        int size = this.grid.size();
        int absoluteSlotIndex = -2;
        int itemIndex = 0;
        this.pageCount = 0;
        this.maxAbsoluteSlotIndex = 0;
        this.gridMask = new ArrayList<BookmarksGridSlot>();
        this.itemToRecipe.clear();
        this.caclulatedItems.clear();
        this.slotToItem.clear();
        this.itemToSlot.clear();
        this.rowToGroupId.clear();
        if (this.grid.isEmpty() || this.grid.getPerPage() == 0) {
            return;
        }
        while (itemIndex < size && absoluteSlotIndex != -1) {
            int collapsedItemIndex;
            BookmarkItem item;
            int index2;
            List<Integer> results;
            BookmarkItem bookmarkItem = this.grid.getBookmarkItem(itemIndex);
            BookmarkGroup group = this.grid.getGroup(bookmarkItem.groupId);
            if (group.crafting != null && (!group.crafting.calculatedItems.containsKey(itemIndex) || bookmarkItem.recipeId != null && !bookmarkItem.recipeId.equals(group.crafting.itemToRecipe.getOrDefault(itemIndex, bookmarkItem.recipeId)))) {
                ++itemIndex;
                continue;
            }
            if (group.collapsed) {
                int nextSlotIndex;
                results = this.getGroupResults(bookmarkItem.groupId, itemIndex, size);
                String groupKey = "group:" + bookmarkItem.groupId;
                for (index2 = 0; index2 < results.size() && (nextSlotIndex = this.nextSlotIndex(absoluteSlotIndex + 1, prevBookmarkItem, item = this.grid.getBookmarkItem(collapsedItemIndex = results.get(index2).intValue()), BookmarkPanel.BookmarkViewMode.DEFAULT)) != -1 && (index2 <= 0 || nextSlotIndex % gridColumns != 0); ++index2) {
                    prevBookmarkItem = item;
                    absoluteSlotIndex = nextSlotIndex;
                    this.slotToItem.put(absoluteSlotIndex, collapsedItemIndex);
                    this.itemToSlot.put(collapsedItemIndex, absoluteSlotIndex);
                    this.caclulatedItems.put(collapsedItemIndex, this.getItem(group, collapsedItemIndex));
                    borderGrid.put(absoluteSlotIndex, groupKey);
                }
                while (itemIndex < size && this.grid.getBookmarkItem((int)itemIndex).groupId == bookmarkItem.groupId) {
                    ++itemIndex;
                }
                continue;
            }
            if (group.crafting != null && group.viewMode == BookmarkPanel.BookmarkViewMode.DEFAULT) {
                results = this.getGroupResults(bookmarkItem.groupId, itemIndex, size);
                for (index2 = 0; index2 < results.size() && absoluteSlotIndex != -1; ++index2) {
                    List<Integer> shadows;
                    collapsedItemIndex = results.get(index2);
                    item = this.grid.getBookmarkItem(collapsedItemIndex);
                    if ((absoluteSlotIndex = this.nextSlotIndex(absoluteSlotIndex + 1, prevBookmarkItem, item, BookmarkPanel.BookmarkViewMode.DEFAULT)) == -1) continue;
                    prevBookmarkItem = item;
                    this.slotToItem.put(absoluteSlotIndex, collapsedItemIndex);
                    this.itemToSlot.put(collapsedItemIndex, absoluteSlotIndex);
                    this.caclulatedItems.put(collapsedItemIndex, this.getItem(group, collapsedItemIndex));
                    if (item.recipeId == null || (shadows = this.getShadows(group, item.recipeId)).isEmpty()) continue;
                    borderGrid.put(absoluteSlotIndex, "recipe:" + shadows.get(0));
                }
                while (itemIndex < size && this.grid.getBookmarkItem((int)itemIndex).groupId == bookmarkItem.groupId) {
                    ++itemIndex;
                }
                continue;
            }
            if (group.crafting != null && group.crafting.itemToRecipe.values().contains(bookmarkItem.recipeId)) {
                absoluteSlotIndex = this.generateCollapsedRecipe(prevBookmarkItem, itemIndex, absoluteSlotIndex, borderGrid);
                prevBookmarkItem = bookmarkItem;
                while (itemIndex < size && bookmarkItem.equalsRecipe(this.grid.getBookmarkItem(itemIndex))) {
                    ++itemIndex;
                }
                continue;
            }
            if ((absoluteSlotIndex = this.nextSlotIndex(absoluteSlotIndex + 1, prevBookmarkItem, bookmarkItem, group.viewMode)) == -1) continue;
            prevBookmarkItem = bookmarkItem;
            this.slotToItem.put(absoluteSlotIndex, itemIndex);
            this.itemToSlot.put(itemIndex, absoluteSlotIndex);
            this.caclulatedItems.put(itemIndex, this.getItem(group, itemIndex));
            ++itemIndex;
        }
        this.maxAbsoluteSlotIndex = this.slotToItem.keySet().stream().mapToInt(index -> index).max().orElse(-1) + 1;
        this.generateGroups();
        this.splitGridMask();
        this.calculateGroupBorders(borderGrid);
    }

    private List<Integer> getGroupResults(int groupId, int itemIndex, int size) {
        BookmarkItem bookmarkItem;
        BookmarkGroup group = this.grid.getGroup(groupId);
        ArrayList<Integer> results = new ArrayList<Integer>();
        while (itemIndex < size && (bookmarkItem = this.grid.getBookmarkItem(itemIndex)) != null && bookmarkItem.groupId == groupId) {
            if (bookmarkItem.type != BookmarkItem.BookmarkItemType.INGREDIENT && (group.crafting == null || group.crafting.calculatedItems.containsKey(itemIndex))) {
                results.add(itemIndex);
            }
            ++itemIndex;
        }
        return results;
    }

    private int generateCollapsedRecipe(BookmarkItem prevBookmarkItem, int itemIndex, int absoluteSlotIndex, Map<Integer, String> borderGrid) {
        BookmarkItem bookmarkItem = this.grid.getBookmarkItem(itemIndex);
        BookmarkGroup group = this.grid.getGroup(bookmarkItem.groupId);
        List<Integer> shadows = this.getShadows(group, bookmarkItem.recipeId);
        String borderId = "recipe:" + shadows.get(0);
        shadows.sort(this.generateSortingComparator(group.crafting.calculatedItems));
        for (int shadowIndex : shadows) {
            boolean isIngredient = shadows.get(0) != shadowIndex || group.crafting.calculatedItems.get((Object)Integer.valueOf((int)shadowIndex)).calculatedType == RecipeChainDetails.CalculatedType.INGREDIENT;
            BookmarkItem shadowBookmarkItem = BookmarkItem.of(bookmarkItem.groupId, bookmarkItem.itemStack, 1L, bookmarkItem.recipeId, isIngredient ? BookmarkItem.BookmarkItemType.INGREDIENT : BookmarkItem.BookmarkItemType.RESULT, Collections.emptyMap());
            if ((absoluteSlotIndex = this.nextSlotIndex(absoluteSlotIndex + 1, prevBookmarkItem, shadowBookmarkItem, group.viewMode)) == -1) continue;
            this.slotToItem.put(absoluteSlotIndex, shadowIndex);
            this.itemToSlot.put(shadowIndex, absoluteSlotIndex);
            this.caclulatedItems.put(shadowIndex, this.getItem(group, shadowIndex));
            this.itemToRecipe.put(shadowIndex, bookmarkItem.recipeId);
            borderGrid.put(absoluteSlotIndex, borderId);
            prevBookmarkItem = shadowBookmarkItem;
        }
        return absoluteSlotIndex;
    }

    private List<Integer> getShadows(BookmarkGroup group, Recipe.RecipeId recipeId) {
        return group.crafting.itemToRecipe.entrySet().stream().filter(entry -> recipeId.equals(entry.getValue())).map(entry -> (Integer)entry.getKey()).collect(Collectors.toList());
    }

    private int nextSlotIndex(int index, BookmarkItem previousMeta, BookmarkItem meta, BookmarkPanel.BookmarkViewMode viewMode) {
        int gridColumns = this.grid.getColumns();
        int maxIndex = this.grid.getRows() * gridColumns;
        int j = 0;
        index = Math.max(0, index);
        while (j++ < maxIndex) {
            boolean isFirstColumn;
            boolean bl = isFirstColumn = index % gridColumns == 0;
            if (this.grid.isInvalidSlot(index % maxIndex)) {
                ++index;
                continue;
            }
            if (!(isFirstColumn || previousMeta != null && previousMeta.groupId == meta.groupId)) {
                ++index;
                continue;
            }
            if (viewMode == BookmarkPanel.BookmarkViewMode.DEFAULT) {
                return index;
            }
            if (isFirstColumn && (meta.recipeId == null || previousMeta == null || previousMeta.groupId != meta.groupId || meta.type == BookmarkItem.BookmarkItemType.ITEM || !meta.recipeId.equals(previousMeta.recipeId) || index + 1 < maxIndex && this.grid.isInvalidSlot((index + 1) % maxIndex))) {
                return index;
            }
            if (!isFirstColumn && meta.type != BookmarkItem.BookmarkItemType.ITEM && previousMeta.type != BookmarkItem.BookmarkItemType.ITEM && meta.recipeId != null && meta.recipeId.equals(previousMeta.recipeId)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void generateGroups() {
        int gridColumns = this.grid.getColumns();
        int previousGroupId = 0;
        for (int absoluteSlotIndex = 0; absoluteSlotIndex < this.maxAbsoluteSlotIndex; ++absoluteSlotIndex) {
            int absoluteRowIndex = absoluteSlotIndex / gridColumns;
            if (this.rowToGroupId.getOrDefault(absoluteRowIndex, 0) != 0) continue;
            int groupId = 0;
            if (this.slotToItem.containsKey(absoluteSlotIndex)) {
                groupId = this.caclulatedItems.get((Object)this.slotToItem.get((Object)Integer.valueOf((int)absoluteSlotIndex))).getItem().groupId;
            }
            this.rowToGroupId.put(absoluteRowIndex, groupId);
            if (groupId == 0 || previousGroupId != (previousGroupId = groupId)) continue;
            while (--absoluteRowIndex >= 0 && this.rowToGroupId.get(absoluteRowIndex) == 0) {
                this.rowToGroupId.put(absoluteRowIndex, groupId);
            }
        }
    }

    private Comparator<Integer> generateSortingComparator(Map<Integer, RecipeChainDetails.BookmarkChainItem> calculatedItems) {
        return Comparator.comparingInt(index -> ((RecipeChainDetails.BookmarkChainItem)calculatedItems.get((Object)index)).calculatedType.toInt()).thenComparing(index -> StackInfo.getFluid(((RecipeChainDetails.BookmarkChainItem)calculatedItems.get((Object)index)).getItem().itemStack) != null).thenComparing((i1, i2) -> ItemSorter.instance.compare(((RecipeChainDetails.BookmarkChainItem)calculatedItems.get((Object)i1)).getItem().itemStack, ((RecipeChainDetails.BookmarkChainItem)calculatedItems.get((Object)i2)).getItem().itemStack));
    }

    private void splitGridMask() {
        int gridColumns = this.grid.getColumns();
        int rows = this.grid.getRows();
        int perPage = rows * gridColumns;
        this.pageCount = (int)Math.ceil((float)this.maxAbsoluteSlotIndex / (float)perPage);
        int page = Math.max(0, Math.min(this.grid.getPage(), this.pageCount) - 1);
        for (int absoluteSlotIndex = page * perPage; absoluteSlotIndex < Math.min(this.maxAbsoluteSlotIndex, (page + 1) * perPage); ++absoluteSlotIndex) {
            if (this.slotToItem.get(absoluteSlotIndex) == null) continue;
            this.gridMask.add(this.getBookmarkGridSlot(absoluteSlotIndex % perPage, this.slotToItem.get(absoluteSlotIndex)));
        }
    }

    private RecipeChainDetails.BookmarkChainItem getItem(BookmarkGroup group, int itemIndex) {
        if (group.crafting != null) {
            return group.crafting.calculatedItems.get(itemIndex);
        }
        RecipeChainDetails.BookmarkChainItem item = RecipeChainDetails.BookmarkChainItem.of(this.grid.getBookmarkItem(itemIndex));
        item.setRealAmount(item.getShiftAmount());
        return item;
    }

    private BookmarksGridSlot getBookmarkGridSlot(int slotIndex, int itemIndex) {
        RecipeChainDetails.BookmarkChainItem chainItem = this.caclulatedItems.get(itemIndex);
        BookmarkGroup group = this.grid.getGroup(chainItem.getItem().groupId);
        if (group.crafting == null) {
            return new BookmarksGridSlot(slotIndex, itemIndex, chainItem.getRealAmount(), 0L, 0L, chainItem.getItem(), null, group);
        }
        return new BookmarksGridSlot(slotIndex, itemIndex, chainItem.getRealAmount(), chainItem.getShiftAmount(), chainItem.getCalculatedAmount(), chainItem.getItem(), chainItem.calculatedType, group);
    }

    protected void calculateGroupBorders(Map<Integer, String> borderGrid) {
        int gridColumns = this.grid.getColumns();
        int page = Math.max(1, Math.min(this.grid.getPage(), this.pageCount)) - 1;
        int shiftIndex = page * this.grid.getRows() * gridColumns;
        for (BookmarksGridSlot slot : this.gridMask) {
            if (borderGrid.get(shiftIndex + slot.slotIndex) == null) continue;
            String groupIndex = borderGrid.get(shiftIndex + slot.slotIndex);
            int column = slot.slotIndex % gridColumns;
            int row = slot.slotIndex / gridColumns;
            int prevSlotIndex = shiftIndex + (row - 1) * gridColumns + column;
            int nextSlotIndex = shiftIndex + (row + 1) * gridColumns + column;
            BookmarkGroup group = slot.getGroup();
            slot.borderColor = group.crafting == null ? BookmarkGrid.GROUP_NONE_COLOR : (group.collapsed ? BookmarkGrid.GROUP_CHAIN_COLOR : BookmarkGrid.RECIPE_COLOR);
            slot.borderLeft = column == 0 || !groupIndex.equals(borderGrid.get(shiftIndex + slot.slotIndex - 1));
            slot.borderRight = column + 1 == gridColumns || !groupIndex.equals(borderGrid.get(shiftIndex + slot.slotIndex + 1));
            slot.borderTop = !groupIndex.equals(borderGrid.get(prevSlotIndex));
            slot.borderBottom = !groupIndex.equals(borderGrid.get(nextSlotIndex));
        }
    }
}

