/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ItemPanels;
import codechicken.nei.ItemStackAmount;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.RestartableTask;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeHandlerRef;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.recipe.chain.RecipeChainIterator;
import codechicken.nei.recipe.chain.RecipeChainMath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;

public class AutoCraftingManager {
    private static RecipeChainMath math;
    private static final RestartableTask task;

    private AutoCraftingManager() {
    }

    public static void runProcessing(RecipeChainMath math) {
        task.stop();
        AutoCraftingManager.math = math;
        if (AutoCraftingManager.math != null) {
            ItemPanels.bookmarkPanel.clearTooltips();
            math.createMasterRoot();
            task.restart();
        }
    }

    public static boolean processing() {
        return math != null && !task.interrupted();
    }

    public static ItemStackAmount getInventoryItems(GuiContainer guiContainer) {
        ItemStackAmount inventory = new ItemStackAmount();
        for (Slot slot : guiContainer.field_147002_h.field_75151_b) {
            if (!slot.func_75216_d() || slot instanceof SlotCrafting || !slot.func_82869_a((EntityPlayer)guiContainer.field_146297_k.field_71439_g)) continue;
            inventory.add(slot.func_75211_c());
        }
        return inventory;
    }

    static {
        task = new RestartableTask("NEI Bookmark AutoCraft Processing"){

            @Override
            public void execute() {
                GuiContainer guiContainer = NEIClientUtils.getGuiContainer();
                List<BookmarkItem> initialItems = this.prepareInitialItems(math, AutoCraftingManager.getInventoryItems(guiContainer));
                boolean processed = false;
                boolean changed = false;
                StackInfo.pauseItemDamageSound(true);
                do {
                    changed = false;
                    RecipeChainIterator iterator = new RecipeChainIterator(math, initialItems);
                    iterator.updateInventory(AutoCraftingManager.getInventoryItems(guiContainer));
                    while (iterator.hasNext() && !this.interrupted(guiContainer)) {
                        Object recipes = iterator.next();
                        boolean craft = false;
                        for (Map.Entry entry : recipes.entrySet()) {
                            RecipeHandlerRef handler = RecipeHandlerRef.of((Recipe.RecipeId)entry.getKey());
                            if (handler != null && handler.canCraft(guiContainer)) {
                                long multiplier;
                                for (multiplier = ((Long)entry.getValue()).longValue(); multiplier > 0L && !this.interrupted(guiContainer) && handler.craft(guiContainer, (int)Math.min(64L, multiplier)); multiplier -= 64L) {
                                }
                                boolean bl = craft = multiplier != (Long)entry.getValue();
                            }
                            if (!this.interrupted(guiContainer)) continue;
                            break;
                        }
                        if (!craft) continue;
                        changed = true;
                        processed = true;
                        iterator.updateInventory(AutoCraftingManager.getInventoryItems(guiContainer));
                    }
                } while (changed && !this.interrupted(guiContainer));
                StackInfo.pauseItemDamageSound(false);
                if (processed && !changed && !this.interrupted(guiContainer)) {
                    NEIClientUtils.playClickSound();
                }
            }

            @Override
            public void clearTasks() {
                super.clearTasks();
                math = null;
            }

            private boolean interrupted(GuiContainer guiContainer) {
                return this.interrupted() || guiContainer != NEIClientUtils.getGuiContainer();
            }

            private List<BookmarkItem> prepareInitialItems(RecipeChainMath math, ItemStackAmount inventory) {
                ArrayList<BookmarkItem> initialItems = new ArrayList<BookmarkItem>();
                for (BookmarkItem item : math.initialItems) {
                    long invStackSize = inventory.getOrDefault(item.itemStack, 0L);
                    long amount = Math.max(0L, item.amount - invStackSize * (long)item.fluidCellAmount);
                    if (amount <= 0L) continue;
                    initialItems.add(item.copyWithAmount(amount));
                }
                return initialItems;
            }
        };
    }
}

