/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.NEIRecipeWidget;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.RecipeHandlerRef;
import codechicken.nei.scroll.GuiHelper;
import java.awt.Dimension;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class RecipeTooltipLineHandler
implements GuiDraw.ITooltipLineHandler {
    private static final int BG_PADDING = 5;
    private static final DrawableResource BG_TEXTURE = new DrawableBuilder("nei:textures/gui/recipebg.png", 0, 0, 176, 166).build();
    protected long lastUpdate = System.currentTimeMillis();
    protected String recipeName = "";
    protected GuiRecipe<?> gui = null;
    protected RecipeHandlerRef handlerRef = null;
    protected NEIRecipeWidget widget = null;
    protected Recipe.RecipeId recipeId = null;
    protected boolean createdGui = false;

    public RecipeTooltipLineHandler(Recipe.RecipeId recipeId) {
        this.recipeId = recipeId;
    }

    public ItemStack getItemStack() {
        return this.recipeId.getResult();
    }

    public Recipe.RecipeId getRecipeId() {
        return this.recipeId;
    }

    public Dimension getSize() {
        if (this.widget == null && !this.createdGui) {
            this.handlerRef = RecipeHandlerRef.of(this.recipeId);
            this.createdGui = true;
            if (this.handlerRef != null) {
                this.widget = new NEIRecipeWidget(this.handlerRef);
                this.widget.showAsWidget(true);
                this.widget.x = 5;
                this.widget.y = 17;
                this.recipeName = this.widget.getRecipeHandlerRef().handler.getRecipeName().trim();
            }
        }
        if (this.widget != null) {
            return new Dimension(this.widget.w + 10, this.widget.h + 10 + 12);
        }
        return new Dimension(0, 0);
    }

    public void draw(int x, int y) {
        if (this.widget == null) {
            return;
        }
        if (System.currentTimeMillis() - this.lastUpdate > 50L) {
            this.lastUpdate = System.currentTimeMillis();
            this.handlerRef.handler.onUpdate();
            this.widget.update();
        }
        Dimension size = this.getSize();
        GL11.glPushAttrib((int)24640);
        int zTranslation = 400;
        GL11.glTranslatef((float)x, (float)y, (float)400.0f);
        GuiContainerManager.enable2DRender();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BG_TEXTURE.draw(0, 0, size.width, size.height, 5, 5, 5, 5);
        GL11.glEnable((int)3008);
        GuiDraw.drawRect((int)5, (int)5, (int)(size.width - 10), (int)12, (int)0x30000000);
        GuiDraw.drawStringC((String)this.recipeName, (int)(this.widget.w / 2), (int)7, (int)0xFFFFFF);
        GuiHelper.useScissor(this.widget.x, this.widget.y, this.widget.w, this.widget.h, () -> this.widget.draw(0, 0));
        GL11.glPopAttrib();
        GL11.glTranslatef((float)(-x), (float)(-y), (float)-400.0f);
    }
}

