/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.scroll;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.drawable.DrawableResource;
import codechicken.nei.scroll.ScrollContainer;
import java.awt.Color;
import org.lwjgl.opengl.GL11;

public class ScrollBar {
    private static final int MINIMUM_THUMB_SIZE = 6;
    private static final Color BACKGROUND_COLOR = new Color(-1867393824);
    private static final Color THUMB_COLOR = new Color(-267100768);
    private static final Color THUMB_SELECTED_COLOR = new Color(-265385024);
    private ScrollType scrollType = ScrollType.VERTICAL;
    private OverflowType overflowType = OverflowType.SCROLL;
    private ScrollPlace scrollPlace = ScrollPlace.END;
    private float handleClickOffset = -1.0f;
    private int trackWidth = 6;
    private int thumbPaddingLeft = 0;
    private int thumbPaddingRight = 0;
    private int thumbPaddingTop = 0;
    private int thumbPaddingBottom = 0;
    private int trackPaddingLeft = 0;
    private int trackPaddingRight = 0;
    private int trackPaddingTop = 0;
    private int trackPaddingBottom = 0;
    private DrawableResource thumbTexture;
    private int thumbSliceStart;
    private int thumbSliceEnd;
    private DrawableResource trackTexture;
    private int trackSliceStart;
    private int trackSliceEnd;

    public static ScrollBar defaultScrollBar() {
        return new ScrollBar();
    }

    public static ScrollBar defaultVerticalBar() {
        return new ScrollBar().setTrackWidth(8).setTrackTexture(new DrawableBuilder("nei:textures/nei_sprites.png", 29, 95, 8, 11).build(), 3, 4).setThumbTexture(new DrawableBuilder("nei:textures/nei_sprites.png", 22, 96, 6, 9).build(), 3, 2).setThumbPadding(1, 1, 1, 1);
    }

    public static ScrollBar defaultHorizontalBar() {
        return new ScrollBar().setTrackWidth(8).setOverflowType(OverflowType.SCROLL).setTrackTexture(new DrawableBuilder("nei:textures/nei_sprites.png", 0, 97, 11, 8).build(), 3, 4).setThumbTexture(new DrawableBuilder("nei:textures/nei_sprites.png", 12, 98, 9, 6).build(), 3, 2).setThumbPadding(1, 1, 1, 1);
    }

    public ScrollBar setTrackWidth(int trackWidth) {
        this.trackWidth = trackWidth;
        return this;
    }

    public ScrollBar setTrackPadding(int left, int top, int right, int bottom) {
        this.trackPaddingLeft = left;
        this.trackPaddingRight = right;
        this.trackPaddingTop = top;
        this.trackPaddingBottom = bottom;
        return this;
    }

    public ScrollBar setThumbPadding(int left, int top, int right, int bottom) {
        this.thumbPaddingLeft = left;
        this.thumbPaddingRight = right;
        this.thumbPaddingTop = top;
        this.thumbPaddingBottom = bottom;
        return this;
    }

    public int getTrackWidth() {
        if (this.trackTexture != null) {
            return this.scrollType == ScrollType.HORIZONTAL ? this.trackTexture.getHeight() : this.trackTexture.getWidth();
        }
        return this.trackWidth;
    }

    protected int getThumbWidth() {
        if (this.thumbTexture != null) {
            return this.scrollType == ScrollType.HORIZONTAL ? this.thumbTexture.getHeight() : this.thumbTexture.getWidth();
        }
        return this.getTrackWidth();
    }

    public ScrollBar setThumbTexture(DrawableResource texture, int sliceStart, int sliceEnd) {
        this.thumbTexture = texture;
        this.thumbSliceStart = sliceStart;
        this.thumbSliceEnd = sliceEnd;
        return this;
    }

    public ScrollBar setTrackTexture(DrawableResource texture, int sliceStart, int sliceEnd) {
        this.trackTexture = texture;
        this.trackSliceStart = sliceStart;
        this.trackSliceEnd = sliceEnd;
        return this;
    }

    public ScrollBar setOverflowType(OverflowType overflowType) {
        this.overflowType = overflowType;
        return this;
    }

    public OverflowType getOverflowType() {
        return this.overflowType;
    }

    public ScrollBar setScrollPlace(ScrollPlace scrollPlace) {
        this.scrollPlace = scrollPlace;
        return this;
    }

    public ScrollPlace getScrollPlace() {
        return this.scrollPlace;
    }

    public ScrollBar setScrollType(ScrollType scrollType) {
        this.scrollType = scrollType;
        return this;
    }

    private int getActualSize(ScrollContainer container) {
        if (this.scrollType == ScrollType.HORIZONTAL) {
            return container.getActualWidth();
        }
        return container.getActualHeight();
    }

    public int getVisibleSize(ScrollContainer container) {
        if (this.scrollType == ScrollType.HORIZONTAL) {
            return container.getVisibleWidth();
        }
        return container.getVisibleHeight();
    }

    private int getMaxThumbSize(ScrollContainer container) {
        if (this.scrollType == ScrollType.HORIZONTAL) {
            return this.getMaxTrackSize(container) - this.thumbPaddingLeft - this.thumbPaddingRight;
        }
        return this.getMaxTrackSize(container) - this.thumbPaddingTop - this.thumbPaddingBottom;
    }

    private int getMaxTrackSize(ScrollContainer container) {
        if (this.scrollType == ScrollType.HORIZONTAL) {
            return container.w - this.trackPaddingLeft - this.trackPaddingRight;
        }
        return container.h - this.trackPaddingTop - this.trackPaddingBottom;
    }

    private int getMinThumbSize() {
        if (this.thumbTexture != null) {
            return this.scrollType == ScrollType.HORIZONTAL ? this.thumbTexture.getWidth() : this.thumbTexture.getHeight();
        }
        return 6;
    }

    public float getScrollOffset(ScrollContainer container) {
        float thumbSize = (float)this.getMaxThumbSize(container) - this.calculateMainAxisSize(container);
        if (this.scrollType == ScrollType.HORIZONTAL) {
            return (float)container.getHorizontalScrollOffset() / (float)(container.getActualWidth() - container.getVisibleWidth()) * thumbSize;
        }
        return (float)container.getVerticalScrollOffset() / (float)(container.getActualHeight() - container.getVisibleHeight()) * thumbSize;
    }

    public float calculateMainAxisSize(ScrollContainer container) {
        int visibleSize = this.getVisibleSize(container);
        int actualSize = this.getActualSize(container);
        int trackSize = this.getMaxThumbSize(container);
        return Math.max(Math.min((float)trackSize, (float)trackSize / (float)actualSize * (float)visibleSize), (float)this.getMinThumbSize());
    }

    public Rectangle4i trackBounds(ScrollContainer container) {
        int trackWidth = this.getTrackWidth();
        if (this.scrollType == ScrollType.HORIZONTAL) {
            int y = this.scrollPlace == ScrollPlace.START ? container.y - trackWidth - this.trackPaddingBottom : container.y + container.h + this.trackPaddingTop;
            return new Rectangle4i(container.x + this.trackPaddingLeft, y, this.getMaxTrackSize(container), trackWidth);
        }
        int x = this.scrollPlace == ScrollPlace.START ? container.x - trackWidth - this.trackPaddingRight : container.x + container.w + this.trackPaddingLeft;
        return new Rectangle4i(x, container.y + this.trackPaddingTop, trackWidth, this.getMaxTrackSize(container));
    }

    public Rectangle4i thumbBounds(ScrollContainer container) {
        int mainAxisSize = (int)this.calculateMainAxisSize(container);
        int offset = (int)Math.ceil(this.getScrollOffset(container));
        Rectangle4i bounds = this.trackBounds(container);
        if (this.scrollType == ScrollType.HORIZONTAL) {
            int y = this.scrollPlace == ScrollPlace.START ? bounds.y + bounds.h - this.getThumbWidth() - this.thumbPaddingBottom : bounds.y + this.thumbPaddingTop;
            return new Rectangle4i(bounds.x + this.thumbPaddingLeft + offset, y, mainAxisSize, bounds.h - this.thumbPaddingTop - this.thumbPaddingBottom);
        }
        int x = this.scrollPlace == ScrollPlace.START ? bounds.x + bounds.w - this.getThumbWidth() - this.thumbPaddingRight : bounds.x + this.thumbPaddingLeft;
        return new Rectangle4i(x, bounds.y + this.thumbPaddingTop + offset, bounds.w - this.thumbPaddingLeft - this.thumbPaddingRight, mainAxisSize);
    }

    public boolean setScrollOffset(ScrollContainer container, int offset) {
        if (this.scrollType == ScrollType.HORIZONTAL) {
            return container.setHorizontalScrollOffset(offset);
        }
        return container.setVerticalScrollOffset(offset);
    }

    public boolean onClick(ScrollContainer container, int mx, int my, int button) {
        Rectangle4i bounds = this.trackBounds(container);
        if (bounds.contains(mx, my)) {
            float mainAxisSize = this.calculateMainAxisSize(container);
            float thumbSize = (float)this.getMaxThumbSize(container) - mainAxisSize;
            Rectangle4i thumbBounds = this.thumbBounds(container);
            if (this.scrollType == ScrollType.HORIZONTAL) {
                int relativeX = mx - bounds.x - this.thumbPaddingLeft;
                this.handleClickOffset = mx < thumbBounds.x || mx > thumbBounds.x + thumbBounds.w ? mainAxisSize / 2.0f : (float)(mx - thumbBounds.x);
                float newOffset = ((float)relativeX - this.handleClickOffset) * (float)(container.getActualWidth() - container.getVisibleWidth()) / thumbSize;
                container.setHorizontalScrollOffset((int)newOffset);
            } else {
                int relativeY = my - bounds.y - this.thumbPaddingTop;
                this.handleClickOffset = my < thumbBounds.y || my > thumbBounds.y + thumbBounds.h ? mainAxisSize / 2.0f : (float)(my - thumbBounds.y);
                float newOffset = ((float)relativeY - this.handleClickOffset) * (float)(container.getActualHeight() - container.getVisibleHeight()) / thumbSize;
                container.setVerticalScrollOffset((int)newOffset);
            }
            return true;
        }
        return false;
    }

    public boolean onMouseDragged(ScrollContainer container, int mx, int my, int buttonId, long heldTime) {
        if (this.handleClickOffset >= 0.0f) {
            Rectangle4i bounds = this.trackBounds(container);
            float mainAxisSize = this.calculateMainAxisSize(container);
            float thumbSize = (float)this.getMaxThumbSize(container) - mainAxisSize;
            if (this.scrollType == ScrollType.HORIZONTAL) {
                int relativeX = mx - bounds.x - this.thumbPaddingLeft;
                float newOffset = ((float)relativeX - this.handleClickOffset) * (float)(container.getActualWidth() - container.getVisibleWidth()) / thumbSize;
                container.setHorizontalScrollOffset((int)newOffset);
            } else {
                int relativeY = my - bounds.y - this.thumbPaddingTop;
                float newOffset = ((float)relativeY - this.handleClickOffset) * (float)(container.getActualHeight() - container.getVisibleHeight()) / thumbSize;
                container.setVerticalScrollOffset((int)newOffset);
            }
            return true;
        }
        return false;
    }

    public boolean onClickReleased(ScrollContainer container, int mx, int my, int buttonId) {
        if (this.handleClickOffset >= 0.0f) {
            this.handleClickOffset = -1.0f;
            return true;
        }
        return false;
    }

    public boolean isMouseDragged() {
        return this.handleClickOffset >= 0.0f;
    }

    public void draw(ScrollContainer container, int mx, int my, float opacity) {
        boolean disabled;
        if (opacity <= 0.0f && this.overflowType == OverflowType.OVERLAY) {
            return;
        }
        if (this.overflowType != OverflowType.OVERLAY) {
            opacity = 1.0f;
        }
        Rectangle4i trackBounds = this.trackBounds(container);
        Rectangle4i thumbBounds = this.thumbBounds(container);
        boolean selected = this.isMouseDragged() || thumbBounds.contains(mx, my);
        boolean bl = disabled = this.getVisibleSize(container) >= this.getActualSize(container);
        if (this.trackTexture != null) {
            this.drawTexture(this.trackTexture, this.trackSliceStart, this.trackSliceEnd, trackBounds, false, opacity);
        } else {
            this.drawTrackRect(container, trackBounds, opacity);
        }
        if (this.thumbTexture != null) {
            this.drawTexture(this.thumbTexture, this.thumbSliceStart, this.thumbSliceEnd, thumbBounds, disabled, opacity);
        } else {
            this.drawThumbRect(container, thumbBounds, selected, opacity);
        }
    }

    private void drawTrackRect(ScrollContainer container, Rectangle4i bounds, float opacity) {
        float trackSize = (float)this.trackWidth / 3.0f;
        Color trackColor = new Color(BACKGROUND_COLOR.getRed(), BACKGROUND_COLOR.getGreen(), BACKGROUND_COLOR.getBlue(), (int)((float)BACKGROUND_COLOR.getAlpha() * opacity));
        if (this.scrollType == ScrollType.HORIZONTAL) {
            NEIClientUtils.drawRect(bounds.x, (float)bounds.y + trackSize, bounds.w, trackSize, trackColor);
        } else {
            NEIClientUtils.drawRect((float)bounds.x + trackSize, bounds.y, trackSize, bounds.h, trackColor);
        }
    }

    private void drawThumbRect(ScrollContainer container, Rectangle4i bounds, boolean selected, float opacity) {
        Color color = selected ? THUMB_SELECTED_COLOR : THUMB_COLOR;
        Color thumbColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((float)color.getAlpha() * opacity));
        NEIClientUtils.drawRect(bounds.x, bounds.y, bounds.w, bounds.h, thumbColor);
    }

    private void drawTexture(DrawableResource texture, int sliceStart, int sliceEnd, Rectangle4i bounds, boolean disabled, float opacity) {
        float c = disabled ? 0.65f : 1.0f;
        GL11.glColor4f((float)c, (float)c, (float)c, (float)opacity);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.scrollType == ScrollType.HORIZONTAL) {
            texture.draw(bounds.x, bounds.y, bounds.w, texture.getHeight(), sliceStart, sliceEnd, 0, 0);
        } else {
            texture.draw(bounds.x, bounds.y, texture.getWidth(), bounds.h, 0, 0, sliceStart, sliceEnd);
        }
    }

    public static enum ScrollType {
        HORIZONTAL,
        VERTICAL;

    }

    public static enum OverflowType {
        NONE,
        AUTO,
        SCROLL,
        OVERLAY;

    }

    public static enum ScrollPlace {
        START,
        END;

    }
}

