/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.util;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.api.ItemFilter;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.IntStream;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackFilterParser {
    private ItemStackFilterParser() {
    }

    public static ItemFilter parse(String filterText) {
        ArrayList<ItemFilter> searchTokens = new ArrayList<ItemFilter>();
        if (!(filterText = filterText.trim()).isEmpty()) {
            for (String part : filterText.split("\\s*\\|\\s*")) {
                ItemList.AllMultiItemFilter filter = ItemStackFilterParser.parsePart(part);
                if (filter.filters.isEmpty()) continue;
                searchTokens.add(filter);
            }
        }
        if (searchTokens.isEmpty()) {
            return null;
        }
        if (searchTokens.size() == 1) {
            return (ItemFilter)searchTokens.get(0);
        }
        return new ItemList.AnyMultiItemFilter(searchTokens);
    }

    private static ItemList.AllMultiItemFilter parsePart(String part) {
        ItemList.AllMultiItemFilter searchTokens = new ItemList.AllMultiItemFilter();
        for (String token : part.split("\\s+")) {
            ItemFilter ruleFilter = ItemStackFilterParser.parseRules(token);
            if (ruleFilter == null) continue;
            searchTokens.filters.add(ruleFilter);
        }
        return searchTokens;
    }

    protected static ItemFilter parseRules(String token) {
        ItemList.AnyMultiItemFilter orFilter = new ItemList.AnyMultiItemFilter();
        ItemList.AnyMultiItemFilter orNotFilter = new ItemList.AnyMultiItemFilter();
        ItemList.AllMultiItemFilter ruleFilter = new ItemList.AllMultiItemFilter();
        for (String rule : token.split(",")) {
            ItemFilter filter;
            boolean ignore = rule.startsWith("!");
            if (ignore) {
                rule = rule.substring(1);
            }
            if ((filter = rule.startsWith("$") ? ItemStackFilterParser.getOreDictFilter(rule.substring(1)) : (rule.startsWith("tag.") ? ItemStackFilterParser.getTagFilter(rule.substring(4)) : (Pattern.matches("^\\d+(-\\d+)?$", rule) ? ItemStackFilterParser.getDamageFilter(rule) : (rule.startsWith("<") && rule.endsWith(">") ? ItemStackFilterParser.getStrictIdentifierFilter(rule.substring(1, rule.length() - 1)) : ItemStackFilterParser.getStringIdentifierFilter(rule))))) == null) continue;
            if (ignore) {
                orNotFilter.filters.add(filter);
                continue;
            }
            orFilter.filters.add(filter);
        }
        if (!orFilter.filters.isEmpty()) {
            ruleFilter.filters.add(orFilter);
        }
        if (!orNotFilter.filters.isEmpty()) {
            ruleFilter.filters.add(new ItemList.NegatedItemFilter(orNotFilter));
        }
        return ruleFilter.filters.isEmpty() ? null : ruleFilter;
    }

    protected static Predicate<String> getMatcher(String searchText) {
        if (searchText.length() >= 3 && searchText.startsWith("r/") && searchText.endsWith("/")) {
            try {
                Pattern pattern = Pattern.compile(searchText.substring(2, searchText.length() - 1), 74);
                return value -> pattern.matcher((CharSequence)value).find();
            }
            catch (PatternSyntaxException pattern) {}
        } else if (!searchText.isEmpty()) {
            String lowerCase = searchText.toLowerCase();
            return value -> value.toLowerCase().contains(lowerCase);
        }
        return null;
    }

    protected static ItemFilter getOreDictFilter(String rule) {
        Predicate<String> matcher = ItemStackFilterParser.getMatcher(rule);
        if (matcher == null) {
            return null;
        }
        return stack -> IntStream.of(OreDictionary.getOreIDs((ItemStack)stack)).anyMatch(id -> matcher.test(OreDictionary.getOreName((int)id)));
    }

    protected static ItemFilter getTagFilter(String rule) {
        String[] parts = rule.split("=", 2);
        String[] path = parts[0].split("\\.");
        Predicate<String> value = ItemStackFilterParser.getMatcher(parts[1]);
        return stack -> {
            Object tag = stack.func_77978_p();
            for (int i = 0; i < path.length && tag != null; ++i) {
                tag = tag instanceof NBTTagCompound ? tag.func_74781_a(path[i]) : (tag instanceof NBTTagList ? ((NBTTagList)tag).field_74747_a.get(Integer.parseInt(path[i])) : null);
            }
            return tag == null ? value == null : value != null && value.test(tag.toString());
        };
    }

    protected static ItemFilter getDamageFilter(String rule) {
        IntPredicate matcher;
        String[] range = rule.split("-");
        if (range.length == 1) {
            int damage = Integer.parseInt(range[0]);
            matcher = dmg -> dmg == damage;
        } else {
            int damageStart = Integer.parseInt(range[0]);
            int damageEnd = Integer.parseInt(range[1]);
            matcher = dmg -> dmg >= damageStart && dmg <= damageEnd;
        }
        return stack -> matcher.test(stack.func_77960_j());
    }

    private static ItemFilter getStrictIdentifierFilter(String rule) {
        ItemStack item = NEIServerUtils.getModdedItem(rule, null);
        return stack -> OreDictionary.itemMatches((ItemStack)item, (ItemStack)stack, (boolean)false);
    }

    protected static ItemFilter getStringIdentifierFilter(String rule) {
        FMLControlledNamespacedRegistry iItemRegistry = GameData.getItemRegistry();
        Predicate<String> matcher = ItemStackFilterParser.getMatcher(rule);
        return stack -> {
            String name = iItemRegistry.func_148750_c((Object)stack.func_77973_b());
            return name != null && !name.isEmpty() && matcher.test(name);
        };
    }
}

