/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Auxiliary;

import Reika.DragonAPI.Instantiable.Event.Client.ResourceReloadEvent;
import Reika.DragonAPI.Instantiable.IO.XMLInterface;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.RadiationShield;
import Reika.ReactorCraft.Registry.ReactorBook;
import Reika.ReactorCraft.Registry.ReactorTiles;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraftforge.common.MinecraftForge;

public final class ReactorDescriptions {
    private static String PARENT = ReactorDescriptions.getParent(true);
    public static final String DESC_SUFFIX = ":desc";
    public static final String NOTE_SUFFIX = ":note";
    private static HashMap<ReactorBook, String> data = new HashMap();
    private static HashMap<ReactorBook, String> notes = new HashMap();
    private static HashMap<ReactorTiles, Object[]> machineData = new HashMap();
    private static HashMap<ReactorTiles, Object[]> machineNotes = new HashMap();
    private static HashMap<ReactorBook, Object[]> miscData = new HashMap();
    private static ArrayList<ReactorBook> categories = new ArrayList();
    private static final XMLInterface parents = ReactorDescriptions.loadData("categories");
    private static final XMLInterface machines = ReactorDescriptions.loadData("machines");
    private static final XMLInterface tools = ReactorDescriptions.loadData("tools");
    private static final XMLInterface resources = ReactorDescriptions.loadData("resource");
    private static final XMLInterface infos = ReactorDescriptions.loadData("info");

    private static XMLInterface loadData(String name) {
        XMLInterface xml = new XMLInterface(ReactorCraft.class, PARENT + name + ".xml", !ReikaObfuscationHelper.isDeObfEnvironment());
        xml.setFallback(ReactorDescriptions.getParent(false) + name + ".xml");
        xml.init();
        return xml;
    }

    private static String getParent(boolean locale) {
        return locale && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? ReactorDescriptions.getLocalizedParent() : "Resources/";
    }

    @SideOnly(value=Side.CLIENT)
    private static String getLocalizedParent() {
        Language language = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        String lang = language.func_135034_a();
        if (ReactorDescriptions.hasLocalizedFor(language) && !"en_US".equals(lang)) {
            return "Resources/" + lang + "/";
        }
        return "Resources/";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SideOnly(value=Side.CLIENT)
    private static boolean hasLocalizedFor(Language language) {
        String lang = language.func_135034_a();
        try (InputStream o = ReactorCraft.class.getResourceAsStream("Resources/" + lang + "/categories.xml");){
            boolean bl = o != null;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getTOC() {
        List<ReactorBook> toctabs = ReactorBook.getTOCTabs();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toctabs.size(); ++i) {
            ReactorBook h = toctabs.get(i);
            sb.append("Page ");
            sb.append(h.getScreen());
            sb.append(" - ");
            sb.append(h.getTitle());
            if (i >= toctabs.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private static void addData(ReactorTiles m, Object ... data) {
        machineData.put(m, data);
    }

    private static void addData(ReactorBook h, Object ... data) {
        miscData.put(h, data);
    }

    private static void addData(ReactorBook h, int[] data) {
        Object[] o = new Object[data.length];
        for (int i = 0; i < o.length; ++i) {
            o[i] = data[i];
        }
        miscData.put(h, o);
    }

    private static void addNotes(ReactorTiles m, Object ... data) {
        machineNotes.put(m, data);
    }

    public static void reload() {
        PARENT = ReactorDescriptions.getParent(true);
        data.clear();
        ReactorDescriptions.loadNumericalData();
        machines.reread();
        tools.reread();
        resources.reread();
        infos.reread();
        parents.reread();
        ReactorDescriptions.loadData();
    }

    private static void addEntry(ReactorBook h, String sg) {
        data.put(h, sg);
    }

    public static void loadData() {
        String desc;
        ReactorBook h;
        int i;
        List<ReactorBook> parenttabs = ReactorBook.getCategoryTabs();
        List<ReactorBook> machinetabs = ReactorBook.getMachineTabs();
        ReactorBook[] tooltabs = ReactorBook.getToolTabs();
        ReactorBook[] resourcetabs = ReactorBook.getResourceTabs();
        ReactorBook[] infotabs = ReactorBook.getInfoTabs();
        for (i = 0; i < parenttabs.size(); ++i) {
            h = parenttabs.get(i);
            desc = parents.getValueAtNode("categories:" + h.name().toLowerCase(Locale.ENGLISH));
            ReactorDescriptions.addEntry(h, desc);
        }
        for (i = 0; i < machinetabs.size(); ++i) {
            h = machinetabs.get(i);
            ReactorTiles m = h.getMachine();
            String desc2 = machines.getValueAtNode("machines:" + m.name().toLowerCase(Locale.ENGLISH) + DESC_SUFFIX);
            String aux = machines.getValueAtNode("machines:" + m.name().toLowerCase(Locale.ENGLISH) + NOTE_SUFFIX);
            desc2 = String.format(desc2, machineData.get((Object)m));
            aux = String.format(aux, machineNotes.get((Object)m));
            if ("#NULL!".equals(desc2)) {
                desc2 = "There is no handbook data for this machine yet.";
            }
            if (m.isDummiedOut()) {
                desc2 = desc2 + "\nThis machine is currently unavailable.";
                aux = aux + "\nNote: Dummied Out";
            }
            ReactorDescriptions.addEntry(h, desc2);
            notes.put(h, aux);
        }
        for (i = 0; i < tooltabs.length; ++i) {
            h = tooltabs[i];
            desc = tools.getValueAtNode("tools:" + h.name().toLowerCase(Locale.ENGLISH));
            ReactorDescriptions.addEntry(h, desc);
        }
        for (i = 0; i < resourcetabs.length; ++i) {
            h = resourcetabs[i];
            desc = resources.getValueAtNode("resource:" + h.name().toLowerCase(Locale.ENGLISH));
            ReactorDescriptions.addEntry(h, desc);
        }
        for (i = 0; i < infotabs.length; ++i) {
            h = infotabs[i];
            desc = infos.getValueAtNode("info:" + h.name().toLowerCase(Locale.ENGLISH));
            desc = String.format(desc, miscData.get((Object)h));
            ReactorDescriptions.addEntry(h, desc);
        }
    }

    public static String getData(ReactorBook h) {
        if (!data.containsKey((Object)h)) {
            return "";
        }
        return data.get((Object)h);
    }

    public static String getNotes(ReactorBook h) {
        if (!notes.containsKey((Object)h)) {
            return "";
        }
        return notes.get((Object)h);
    }

    private static void loadNumericalData() {
        ReactorDescriptions.addNotes(ReactorTiles.CENTRIFUGE, 262144);
        ReactorDescriptions.addNotes(ReactorTiles.ELECTROLYZER, 801);
        ReactorDescriptions.addNotes(ReactorTiles.SYNTHESIZER, 220);
        ReactorDescriptions.addNotes(ReactorTiles.TURBINECORE, 65536, 32768);
        ReactorDescriptions.addNotes(ReactorTiles.BIGTURBINE, 131072);
        ReactorDescriptions.addNotes(ReactorTiles.PUMP, 16384L, 1024);
        ReactorDescriptions.addNotes(ReactorTiles.EXCHANGER, 8192, 512);
        ReactorDescriptions.addNotes(ReactorTiles.FUEL, 1800);
        ReactorDescriptions.addNotes(ReactorTiles.CPU, 1024);
        ReactorDescriptions.addNotes(ReactorTiles.BREEDER, 1800);
        ReactorDescriptions.addNotes(ReactorTiles.HEATER, 150000000);
        ReactorDescriptions.addNotes(ReactorTiles.SOLENOID, 256, 32768, 8192);
        ReactorDescriptions.addData(ReactorTiles.BOILER, 650);
        ReactorDescriptions.addData(ReactorTiles.FLUIDEXTRACTOR, 45, 16);
        ReactorDescriptions.addNotes(ReactorTiles.FLUIDEXTRACTOR, 65536, 512);
        ReactorDescriptions.addNotes(ReactorTiles.TURBINEMETER, 65536, 131072);
        ReactorDescriptions.addData(ReactorTiles.FUELDUMP, 1100);
        ReactorDescriptions.addData(ReactorTiles.SOLARTOP, ReactorTiles.SOLARTOP.getName());
        ReactorDescriptions.addData(ReactorTiles.SOLAR, ReactorTiles.SOLAR.getName());
        ReactorDescriptions.addNotes(ReactorTiles.SOLAR, 65536, 2048);
        ReactorDescriptions.addNotes(ReactorTiles.WASTEDECAYER, 400);
        notes.put(ReactorBook.SHIELDING, RadiationShield.getDataAsString());
    }

    static {
        ReactorDescriptions.loadNumericalData();
        MinecraftForge.EVENT_BUS.register((Object)new ReloadListener());
    }

    public static class ReloadListener {
        @SubscribeEvent
        public void reload(ResourceReloadEvent evt) {
            ReactorDescriptions.reload();
        }
    }
}

