/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Base;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import java.util.Locale;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"buildcraft.api.transport.IPipeConnection"})
public abstract class TileEntityTankedReactorMachine
extends TileEntityReactorBase
implements IFluidHandler,
PipeConnector,
IPipeConnection {
    protected final HybridTank tank = new HybridTank(ReikaStringParser.stripSpaces((String)this.getTEName().toLowerCase(Locale.ENGLISH)), this.getCapacity());

    public abstract int getCapacity();

    public abstract boolean canReceiveFrom(ForgeDirection var1);

    public abstract Fluid getInputFluid();

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int getLevel() {
        return this.tank.getLevel();
    }

    public Fluid getContainedFluid() {
        return this.tank.getActualFluid();
    }

    public void addLiquid(int amt) {
        this.tank.addLiquid(amt, this.getInputFluid());
    }

    public boolean canFill(ForgeDirection from, Fluid f) {
        return this.canReceiveFrom(from) && this.isValidFluid(f);
    }

    public boolean isValidFluid(Fluid f) {
        return f.equals(this.getInputFluid());
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.tank.fill(resource, doFill);
    }

    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canReceiveFrom(side) && this.canConnectToPipe(p);
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection side) {
        return type == IPipeTile.PipeType.FLUID ? (this.getFlowForSide(side) != TileEntityPiping.Flow.NONE ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT) : IPipeConnection.ConnectOverride.DEFAULT;
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return this.canReceiveFrom(side) ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.tank.writeToNBT(NBT);
    }
}

