/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Blocks.Multi;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.StructuredBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Interfaces.Registry.TileEnum;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.NeutronBlock;
import Reika.ReactorCraft.Base.BlockReCMultiBlock;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Fusion.TileEntityFusionInjector;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockInjectorMulti
extends BlockReCMultiBlock
implements NeutronBlock {
    public BlockInjectorMulti(Material par2Material) {
        super(par2Material);
    }

    public int getNumberVariants() {
        return 8;
    }

    public Boolean checkForFullMultiBlock(World world, int x, int y, int z, ForgeDirection dir, FilledBlockArray.BlockMatchFailCallback call) {
        dir = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)this, (int)7);
        if (dir == null) {
            return false;
        }
        ForgeDirection left = ReikaDirectionHelper.getLeftBy90((ForgeDirection)dir);
        StructuredBlockArray blocks = new StructuredBlockArray(world);
        blocks.recursiveAddWithBounds((IBlockAccess)world, x, y, z, (Block)this, x - 8, y - 5, z - 8, x + 8, y + 5, z + 8);
        while (world.func_147439_a(x, y - 1, z) == this && world.func_72805_g(x, y - 1, z) == 5) {
            --y;
        }
        if (!this.checkTop(world, x, y, z, dir, left, blocks, call)) {
            return false;
        }
        if (!this.checkBottom(world, x, y, z, dir, left, blocks, call)) {
            return false;
        }
        if (!this.checkSides(world, x, y, z, dir, left, blocks, call)) {
            return false;
        }
        if (!this.checkCorners(world, x, y, z, dir, left, blocks, call)) {
            return false;
        }
        if (!this.checkFiller(world, x, y, z, dir, left, blocks, call)) {
            return false;
        }
        if (!this.checkPipes(world, x, y, z, dir, left, blocks, call)) {
            return false;
        }
        return true;
    }

    private boolean checkAt(World world, int dx, int dy, int dz, int metas, FilledBlockArray.BlockMatchFailCallback call) {
        return this.checkAt(world, dx, dy, dz, (Block)this, metas, call);
    }

    private boolean checkAt(World world, int dx, int dy, int dz, Block bs, int metas, FilledBlockArray.BlockMatchFailCallback call) {
        Block b = world.func_147439_a(dx, dy, dz);
        int meta = world.func_72805_g(dx, dy, dz);
        if (b != bs || meta != metas) {
            if (call != null) {
                call.onBlockFailure(world, dx, dy, dz, (BlockCheck)new BlockKey(bs, metas));
            }
            return false;
        }
        return true;
    }

    private boolean checkCorners(World world, int x, int y, int z, ForgeDirection dir, ForgeDirection left, StructuredBlockArray blocks, FilledBlockArray.BlockMatchFailCallback call) {
        int i;
        for (i = 0; i <= 4; ++i) {
            if (!this.checkAt(world, x + dir.offsetX * i + left.offsetX, y + 3, z + dir.offsetZ * i + left.offsetZ, 4, call)) {
                return false;
            }
            if (this.checkAt(world, x + dir.offsetX * i - left.offsetX, y + 3, z + dir.offsetZ * i - left.offsetZ, 4, call)) continue;
            return false;
        }
        for (i = 5; i <= 6; ++i) {
            if (!this.checkAt(world, x + dir.offsetX * i + left.offsetX, y + 2, z + dir.offsetZ * i + left.offsetZ, 4, call)) {
                return false;
            }
            if (this.checkAt(world, x + dir.offsetX * i - left.offsetX, y + 2, z + dir.offsetZ * i - left.offsetZ, 4, call)) continue;
            return false;
        }
        for (i = 7; i <= 8; ++i) {
            if (!this.checkAt(world, x + dir.offsetX * i + left.offsetX, y + 1, z + dir.offsetZ * i + left.offsetZ, 4, call)) {
                return false;
            }
            if (this.checkAt(world, x + dir.offsetX * i - left.offsetX, y + 1, z + dir.offsetZ * i - left.offsetZ, 4, call)) continue;
            return false;
        }
        for (i = 0; i <= 8; ++i) {
            if (this.checkAt(world, x + dir.offsetX * i + left.offsetX, y - 1, z + dir.offsetZ * i + left.offsetZ, 1, call)) continue;
            return false;
        }
        for (i = 0; i <= 8; ++i) {
            if (this.checkAt(world, x + dir.offsetX * i - left.offsetX, y - 1, z + dir.offsetZ * i - left.offsetZ, 1, call)) continue;
            return false;
        }
        for (int k = 0; k <= 2; ++k) {
            if (!this.checkAt(world, x + left.offsetX, y + k, z + left.offsetZ, 6, call)) {
                return false;
            }
            if (this.checkAt(world, x - left.offsetX, y + k, z - left.offsetZ, 6, call)) continue;
            return false;
        }
        if (!this.checkAt(world, x + left.offsetX + dir.offsetX * 8, y, z + left.offsetZ + dir.offsetZ * 8, 6, call)) {
            return false;
        }
        return this.checkAt(world, x - left.offsetX + dir.offsetX * 8, y, z - left.offsetZ + dir.offsetZ * 8, 6, call);
    }

    private boolean checkTop(World world, int x, int y, int z, ForgeDirection dir, ForgeDirection left, StructuredBlockArray blocks, FilledBlockArray.BlockMatchFailCallback call) {
        int i;
        for (i = 0; i <= 4; ++i) {
            if (this.checkAt(world, x + dir.offsetX * i, y + 3, z + dir.offsetZ * i, 3, call)) continue;
            return false;
        }
        for (i = 5; i <= 6; ++i) {
            if (this.checkAt(world, x + dir.offsetX * i, y + 2, z + dir.offsetZ * i, 3, call)) continue;
            return false;
        }
        for (i = 7; i <= 8; ++i) {
            if (this.checkAt(world, x + dir.offsetX * i, y + 1, z + dir.offsetZ * i, 3, call)) continue;
            return false;
        }
        return true;
    }

    private boolean checkBottom(World world, int x, int y, int z, ForgeDirection dir, ForgeDirection left, StructuredBlockArray blocks, FilledBlockArray.BlockMatchFailCallback call) {
        for (int i = 0; i <= 8; ++i) {
            if (this.checkAt(world, x + dir.offsetX * i, y - 1, z + dir.offsetZ * i, 0, call)) continue;
            return false;
        }
        return true;
    }

    private boolean checkSides(World world, int x, int y, int z, ForgeDirection dir, ForgeDirection left, StructuredBlockArray blocks, FilledBlockArray.BlockMatchFailCallback call) {
        int i;
        for (i = 1; i <= 1; ++i) {
            if (!this.checkAt(world, x + dir.offsetX * i + left.offsetX, y, z + dir.offsetZ * i + left.offsetZ, 2, call)) {
                return false;
            }
            if (this.checkAt(world, x + dir.offsetX * i - left.offsetX, y, z + dir.offsetZ * i - left.offsetZ, 2, call)) continue;
            return false;
        }
        for (i = 3; i <= 7; ++i) {
            if (!this.checkAt(world, x + dir.offsetX * i + left.offsetX, y, z + dir.offsetZ * i + left.offsetZ, 2, call)) {
                return false;
            }
            if (this.checkAt(world, x + dir.offsetX * i - left.offsetX, y, z + dir.offsetZ * i - left.offsetZ, 2, call)) continue;
            return false;
        }
        for (i = 1; i <= 6; ++i) {
            if (!this.checkAt(world, x + dir.offsetX * i + left.offsetX, y + 1, z + dir.offsetZ * i + left.offsetZ, 2, call)) {
                return false;
            }
            if (this.checkAt(world, x + dir.offsetX * i - left.offsetX, y + 1, z + dir.offsetZ * i - left.offsetZ, 2, call)) continue;
            return false;
        }
        for (i = 1; i <= 4; ++i) {
            if (!this.checkAt(world, x + dir.offsetX * i + left.offsetX, y + 2, z + dir.offsetZ * i + left.offsetZ, 2, call)) {
                return false;
            }
            if (this.checkAt(world, x + dir.offsetX * i - left.offsetX, y + 2, z + dir.offsetZ * i - left.offsetZ, 2, call)) continue;
            return false;
        }
        for (i = 0; i <= 2; ++i) {
            if (this.checkAt(world, x, y + i, z, 5, call)) continue;
            return false;
        }
        if (!this.checkAt(world, x + dir.offsetX * 2 + left.offsetX, y, z + dir.offsetZ * 2 + left.offsetZ, Blocks.field_150350_a, 0, call)) {
            return false;
        }
        return this.checkAt(world, x + dir.offsetX * 2 - left.offsetX, y, z + dir.offsetZ * 2 - left.offsetZ, Blocks.field_150350_a, 0, call);
    }

    private boolean checkFiller(World world, int x, int y, int z, ForgeDirection dir, ForgeDirection left, StructuredBlockArray blocks, FilledBlockArray.BlockMatchFailCallback call) {
        int i;
        for (i = 1; i <= 1; ++i) {
            if (this.checkAt(world, x + dir.offsetX * i, y, z + dir.offsetZ * i, 7, call)) continue;
            return false;
        }
        for (i = 1; i <= 6; ++i) {
            if (this.checkAt(world, x + dir.offsetX * i, y + 1, z + dir.offsetZ * i, 7, call)) continue;
            return false;
        }
        for (i = 1; i <= 4; ++i) {
            if (this.checkAt(world, x + dir.offsetX * i, y + 2, z + dir.offsetZ * i, 7, call)) continue;
            return false;
        }
        return true;
    }

    private boolean checkPipes(World world, int x, int y, int z, ForgeDirection dir, ForgeDirection left, StructuredBlockArray blocks, FilledBlockArray.BlockMatchFailCallback call) {
        for (int i = 3; i <= 8; ++i) {
            int meta;
            Block b = world.func_147439_a(x + dir.offsetX * i, y, z + dir.offsetZ * i);
            if (ReactorTiles.getMachineFromIDandMetadata(b, meta = world.func_72805_g(x + dir.offsetX * i, y, z + dir.offsetZ * i)) == ReactorTiles.MAGNETPIPE) continue;
            if (call != null) {
                call.onBlockFailure(world, x + dir.offsetX * i, y, z + dir.offsetZ * i, (BlockCheck)new BlockKey((TileEnum)ReactorTiles.MAGNETPIPE));
            }
            return false;
        }
        if (ReactorTiles.getTE((IBlockAccess)world, x + dir.offsetX * 2, y, z + dir.offsetZ * 2) != ReactorTiles.INJECTOR) {
            if (call != null) {
                call.onBlockFailure(world, x + dir.offsetX * 2, y, z + dir.offsetZ * 2, (BlockCheck)new BlockKey((TileEnum)ReactorTiles.INJECTOR));
            }
            return false;
        }
        return true;
    }

    public void onCreateFullMultiBlock(World world, int x, int y, int z, Boolean complete) {
        BlockArray blocks = new BlockArray();
        blocks.recursiveAddWithBounds((IBlockAccess)world, x, y, z, (Block)this, x - 8, y - 5, z - 8, x + 8, y + 5, z + 8);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            int meta = c.getBlockMetadata((IBlockAccess)world);
            if (meta < 8) {
                world.func_72921_c(c.xCoord, c.yCoord, c.zCoord, meta + 8, 3);
            }
            if (meta != 0 || ReactorTiles.getTE((IBlockAccess)world, c.xCoord, c.yCoord + 1, c.zCoord) != ReactorTiles.INJECTOR) continue;
            TileEntityFusionInjector te = (TileEntityFusionInjector)world.func_147438_o(c.xCoord, c.yCoord + 1, c.zCoord);
            te.setHasMultiBlock(true);
        }
    }

    public void breakMultiBlock(World world, int x, int y, int z) {
        BlockArray blocks = new BlockArray();
        blocks.recursiveAddWithBounds((IBlockAccess)world, x, y, z, (Block)this, x - 8, y - 5, z - 8, x + 8, y + 5, z + 8);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            int meta = c.getBlockMetadata((IBlockAccess)world);
            if (meta >= 8) {
                world.func_72921_c(c.xCoord, c.yCoord, c.zCoord, meta - 8, 3);
            }
            if (meta != 8 || ReactorTiles.getTE((IBlockAccess)world, c.xCoord, c.yCoord + 1, c.zCoord) != ReactorTiles.INJECTOR) continue;
            TileEntityFusionInjector te = (TileEntityFusionInjector)world.func_147438_o(c.xCoord, c.yCoord + 1, c.zCoord);
            te.setHasMultiBlock(false);
        }
    }

    @Override
    protected String getIconBaseName() {
        return "injector";
    }

    public int getTextureIndex(IBlockAccess world, int x, int y, int z, int side, int meta) {
        if (meta >= 8) {
            if (meta == 13) {
                return 0;
            }
            int index = 10 + this.getTextureIndex(world, x, y, z, side, meta - 8);
            if (side > 1 && (index == 19 || index == 23 || index == 24 || index == 25)) {
                index = 9;
            }
            if (meta == 12 && side == 1) {
                boolean s = world.func_147439_a(x + 1, y, z) == this && world.func_72805_g(x + 1, y, z) == 11;
                boolean s0 = world.func_147439_a(x - 1, y, z) == this && world.func_72805_g(x - 1, y, z) == 11;
                boolean s1 = world.func_147439_a(x, y, z + 1) == this && world.func_72805_g(x, y, z + 1) == 11;
                int a = 25;
                int b = 23;
                if (!s && !s0) {
                    a = 19;
                    b = 24;
                }
                int n = index = s || s1 ? a : b;
            }
            if (meta == 11 && side == 1) {
                index = 9;
            }
            return index;
        }
        switch (meta) {
            case 0: {
                if (side == 0) {
                    return 9;
                }
                return side < 2 ? 0 : 4;
            }
            case 1: {
                if (side == 1) {
                    return 9;
                }
                if (side == 3 || side == 2) {
                    if (world.func_147439_a(x + 1, y, z) == this && (world.func_72805_g(x + 1, y, z) & 7) == 0) {
                        return side == 3 ? 5 : 6;
                    }
                    if (world.func_147439_a(x - 1, y, z) == this && (world.func_72805_g(x - 1, y, z) & 7) == 0) {
                        return side == 3 ? 6 : 5;
                    }
                }
                if (side == 4 || side == 5) {
                    if (world.func_147439_a(x, y, z + 1) == this && (world.func_72805_g(x, y, z + 1) & 7) == 0) {
                        return side == 4 ? 5 : 6;
                    }
                    if (world.func_147439_a(x, y, z - 1) == this && (world.func_72805_g(x, y, z - 1) & 7) == 0) {
                        return side == 4 ? 6 : 5;
                    }
                }
                return 9;
            }
            case 2: {
                ForgeDirection dir = dirs[side];
                int dx = x + dir.offsetX;
                int dy = y + dir.offsetY;
                int dz = z + dir.offsetZ;
                Block b = world.func_147439_a(dx, dy, dz);
                if (b == Blocks.field_150350_a) {
                    return 9;
                }
                return b == ReactorTiles.MAGNETPIPE.getBlock() ? 0 : 9;
            }
            case 3: {
                if (side == 1) {
                    return 9;
                }
                return side < 2 ? 0 : 3;
            }
            case 4: {
                if (side == 1) {
                    return 9;
                }
                if (side == 3 || side == 2) {
                    if (world.func_147439_a(x + 1, y, z) == this && (world.func_72805_g(x + 1, y, z) & 7) == 3) {
                        return side == 3 ? 8 : 7;
                    }
                    if (world.func_147439_a(x - 1, y, z) == this && (world.func_72805_g(x - 1, y, z) & 7) == 3) {
                        return side == 3 ? 7 : 8;
                    }
                }
                if (side == 4 || side == 5) {
                    if (world.func_147439_a(x, y, z + 1) == this && (world.func_72805_g(x, y, z + 1) & 7) == 3) {
                        return side == 4 ? 8 : 7;
                    }
                    if (world.func_147439_a(x, y, z - 1) == this && (world.func_72805_g(x, y, z - 1) & 7) == 3) {
                        return side == 4 ? 7 : 8;
                    }
                }
                return 9;
            }
            case 5: {
                return 22;
            }
            case 6: {
                if (world.func_147439_a(x + 1, y, z) == this && (world.func_72805_g(x + 1, y, z) & 7) == 5) {
                    if (side == 3) {
                        return 2;
                    }
                    if (side == 2) {
                        return 1;
                    }
                }
                if (world.func_147439_a(x - 1, y, z) == this && (world.func_72805_g(x - 1, y, z) & 7) == 5) {
                    if (side == 3) {
                        return 1;
                    }
                    if (side == 2) {
                        return 2;
                    }
                }
                if (world.func_147439_a(x, y, z + 1) == this && (world.func_72805_g(x, y, z + 1) & 7) == 5) {
                    if (side == 5) {
                        return 1;
                    }
                    if (side == 4) {
                        return 2;
                    }
                }
                if (world.func_147439_a(x, y, z - 1) == this && (world.func_72805_g(x, y, z - 1) & 7) == 5) {
                    if (side == 4) {
                        return 1;
                    }
                    if (side == 5) {
                        return 2;
                    }
                }
                if (world.func_147439_a(x + 1, y, z) != this && world.func_147439_a(x - 1, y, z) != this) {
                    if (ReactorTiles.getTE(world, x + 1, y, z) == ReactorTiles.MAGNETPIPE) {
                        if (side == 3) {
                            return 2;
                        }
                        if (side == 2) {
                            return 1;
                        }
                        if (side == 5) {
                            return 0;
                        }
                    }
                    if (ReactorTiles.getTE(world, x - 1, y, z) == ReactorTiles.MAGNETPIPE) {
                        if (side == 3) {
                            return 1;
                        }
                        if (side == 2) {
                            return 2;
                        }
                        if (side == 4) {
                            return 0;
                        }
                    }
                }
                if (world.func_147439_a(x, y, z + 1) != this && world.func_147439_a(x, y, z - 1) != this) {
                    if (ReactorTiles.getTE(world, x, y, z + 1) == ReactorTiles.MAGNETPIPE) {
                        if (side == 5) {
                            return 1;
                        }
                        if (side == 4) {
                            return 2;
                        }
                        if (side == 3) {
                            return 0;
                        }
                    }
                    if (ReactorTiles.getTE(world, x, y, z - 1) == ReactorTiles.MAGNETPIPE) {
                        if (side == 4) {
                            return 1;
                        }
                        if (side == 5) {
                            return 2;
                        }
                        if (side == 2) {
                            return 0;
                        }
                    }
                }
                return 9;
            }
            case 7: {
                return 0;
            }
        }
        return 0;
    }

    public int getItemTextureIndex(int meta, int side) {
        if ((meta &= 7) == 0) {
            return side == 0 ? 9 : (side == 1 ? 0 : 4);
        }
        if (meta == 1) {
            return side == 1 ? 0 : (side == 0 ? 9 : 28);
        }
        if (meta == 4) {
            return side == 0 ? 0 : (side == 1 ? 9 : 27);
        }
        if (meta == 3) {
            return side == 1 ? 9 : (side == 0 ? 0 : 3);
        }
        if (meta == 6) {
            return side < 2 ? 21 : 26;
        }
        if (meta == 2) {
            return 9;
        }
        if (meta == 7) {
            return 0;
        }
        if (meta == 5) {
            return 22;
        }
        if (meta == 5 || meta == 7 || meta == 3 || meta == 0 || meta == 2) {
            return 22;
        }
        return 21;
    }

    public boolean canTriggerMultiBlockCheck(World world, int x, int y, int z, int meta) {
        return meta == 5;
    }

    public int getNumberTextures() {
        return 29;
    }

    protected TileEntity getTileEntityForPosition(World world, int x, int y, int z) {
        BlockArray blocks = new BlockArray();
        blocks.recursiveAddWithBounds((IBlockAccess)world, x, y, z, (Block)this, x - 8, y - 5, z - 8, x + 8, y + 5, z + 8);
        for (int i = 0; i < blocks.getSize(); ++i) {
            Coordinate c = blocks.getNthBlock(i);
            if (ReactorTiles.getTE((IBlockAccess)world, c.xCoord, c.yCoord + 1, c.zCoord) != ReactorTiles.INJECTOR) continue;
            TileEntityFusionInjector te = (TileEntityFusionInjector)world.func_147438_o(c.xCoord, c.yCoord + 1, c.zCoord);
            return te;
        }
        return null;
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        return false;
    }
}

