/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Entities;

import Reika.DragonAPI.Base.ParticleEntity;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Entities.EntityFusion;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.RotaryCraft.API.Interfaces.CustomFanEntity;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityPlasma
extends ParticleEntity
implements CustomFanEntity {
    private int targetX;
    private int targetZ;
    public int magnetOrdinal = -1;
    private int escapeTicks = 0;
    private String placerOfInjector;

    public EntityPlasma(World world) {
        super(world);
    }

    public EntityPlasma(World world, int x, int y, int z, String placer) {
        super(world, x, y, z);
        this.placerOfInjector = placer;
    }

    public double getSpeed() {
        return 0.75;
    }

    public boolean onEnterBlock(World world, int x, int y, int z) {
        if (!world.field_72995_K && ReikaWorldHelper.flammable((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            ReikaWorldHelper.ignite((World)world, (int)x, (int)y, (int)z);
        }
        return false;
    }

    public void setTarget(int x, int z) {
        this.targetX = x;
        this.targetZ = z;
        double dx = (double)this.targetX + 0.5 - this.field_70165_t;
        double dz = (double)this.targetZ + 0.5 - this.field_70161_v;
        double dd = ReikaMathLibrary.py3d((double)dx, (double)0.0, (double)dz);
        double v = this.getSpeed();
        this.field_70159_w = dx * v / dd;
        this.field_70179_y = dz * v / dd;
        this.field_70133_I = true;
    }

    private void checkFusion() {
        AxisAlignedBB box = ReikaAABBHelper.getEntityCenteredAABB((Entity)this, (double)1.0);
        List li = this.field_70170_p.func_72872_a(EntityPlasma.class, box);
        if (li.size() >= this.getFusionThreshold() && !((EntityPlasma)((Object)li.get(0))).hasEscaped() && !((EntityPlasma)((Object)li.get(li.size() - 1))).hasEscaped()) {
            EntityFusion fus = new EntityFusion(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.placerOfInjector);
            this.field_70170_p.func_72838_d((Entity)fus);
            this.func_70106_y();
        }
    }

    public int getFusionThreshold() {
        return 15 + this.field_70146_Z.nextInt(6);
    }

    public void func_70108_f(Entity e) {
        int dmg = e instanceof EntityLivingBase && ((EntityLivingBase)e).func_70644_a(Potion.field_76426_n) ? 4 : Integer.MAX_VALUE;
        e.func_70097_a((DamageSource)ReactorCraft.fusionDamage, (float)dmg);
        if (e instanceof EntityPlayer && (e.field_70128_L || ((EntityLivingBase)e).func_110143_aJ() <= 0.0f)) {
            ReactorAchievements.PLASMADIE.triggerAchievement((EntityPlayer)e);
        }
    }

    protected void onTick() {
        if (this.field_70173_aa > 1200) {
            // empty if block
        }
        if (!this.field_70170_p.field_72995_K && !this.hasEscapedSeverely() && this.field_70146_Z.nextInt(this.hasEscaped() ? 48 : 12) == 0) {
            this.checkFusion();
        }
        this.field_70181_x = 0.0;
        if (this.getSpawnLocation() != null) {
            this.field_70163_u = (double)this.getSpawnLocation().yCoord + 0.5;
        }
        if (this.field_70173_aa > 300 && this.hasEscapedSeverely()) {
            this.func_70106_y();
        }
        ++this.escapeTicks;
    }

    public double getHitboxSize() {
        return 0.5;
    }

    public boolean despawnOverTime() {
        return false;
    }

    public long getBlowPower() {
        return 0x1000000L;
    }

    public double getMaxDeflection() {
        return 0.5;
    }

    public void resetEscapeTimer() {
        this.escapeTicks = 0;
    }

    public boolean hasEscaped() {
        return this.escapeTicks >= 6;
    }

    public boolean hasEscapedSeverely() {
        return this.escapeTicks >= 12;
    }

    public boolean canInteractWithSpawnLocation() {
        return false;
    }

    public boolean despawnOverDistance() {
        return true;
    }

    protected double getDespawnDistance() {
        return 100.0;
    }

    public double getRenderRangeSquared() {
        return Double.POSITIVE_INFINITY;
    }
}

