/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fission;

import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.ReactorCoreTE;
import Reika.ReactorCraft.Auxiliary.Temperatured;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Storage.TileEntityReservoir;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityWaterCell
extends TileEntityReactorBase
implements ReactorCoreTE,
Temperatured {
    private LiquidStates internalLiquid;

    public TileEntityWaterCell() {
        this.setLiquidState(LiquidStates.EMPTY);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        IFluidHandler ic;
        FluidStack liq;
        Fluid f;
        TileEntityReservoir te;
        MachineRegistry m;
        TileEntityWaterCell te2;
        this.thermalTicker.update();
        if (ReactorTiles.getTE((IBlockAccess)world, x, y - 1, z) == this.getTile() && (te2 = (TileEntityWaterCell)world.func_147438_o(x, y - 1, z)).getLiquidState() == LiquidStates.EMPTY && this.getLiquidState() != LiquidStates.EMPTY) {
            te2.setLiquidState(this.getLiquidState());
            this.setLiquidState(LiquidStates.EMPTY);
        }
        if ((m = MachineRegistry.getMachine((IBlockAccess)world, (int)x, (int)(y + 1), (int)z)) == MachineRegistry.RESERVOIR && (te = (TileEntityReservoir)this.getAdjacentTileEntity(ForgeDirection.UP)).getLevel() >= 1000 && this.canIntakeFluid(f = te.getFluid())) {
            te.removeLiquid(1000);
            LiquidStates lq = LiquidStates.getState(f);
            this.setLiquidState(lq);
        }
        if (this.thermalTicker.checkCap() && !world.field_72995_K) {
            this.updateTemperature(world, x, y, z);
        }
        if (this.getLiquidState() == LiquidStates.EMPTY && (te = world.func_147438_o(x, y + 1, z)) instanceof IFluidHandler && (liq = (ic = (IFluidHandler)te).drain(ForgeDirection.DOWN, 1000, false)) != null && liq.amount >= 1000) {
            ic.drain(ForgeDirection.DOWN, 1000, true);
            if (liq.getFluid().equals(FluidRegistry.WATER)) {
                this.setLiquidState(LiquidStates.WATER);
            } else if (liq.getFluid().equals(ReactorCraft.D2O)) {
                this.setLiquidState(LiquidStates.HEAVY);
            }
        }
    }

    private boolean canIntakeFluid(Fluid f) {
        return f != null && LiquidStates.getState(f) != null && this.internalLiquid == LiquidStates.EMPTY;
    }

    @Override
    protected void updateTemperature(World world, int x, int y, int z) {
        super.updateTemperature(world, x, y, z);
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        int dT = this.temperature - Tamb;
        if (dT > 0) {
            this.temperature -= dT / 8;
        }
        for (int i = 0; i < 6; ++i) {
            int t;
            int dt;
            ForgeDirection dir = this.dirs[i];
            TileEntity te = this.getAdjacentTileEntity(dir);
            if (!(te instanceof Temperatured)) continue;
            Temperatured tr = (Temperatured)te;
            if (this.internalLiquid == LiquidStates.HEAVY || !tr.canDumpHeatInto(this.internalLiquid) || (dt = (t = tr.getTemperature()) - this.getTemperature()) <= 0) continue;
            this.temperature += dt / 2;
            tr.setTemperature(t - dt / 2);
            if (rand.nextInt(5) != 0) continue;
            this.setLiquidState(LiquidStates.EMPTY);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.COOLANT;
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        if (this.getLiquidState() == LiquidStates.HEAVY) {
            e.moderate();
            ReactorAchievements.CANDU.triggerAchievement(this.getPlacer());
        }
        return false;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(int T) {
        this.temperature = T;
    }

    @Override
    public int getTextureState(ForgeDirection side) {
        return this.getLiquidState().ordinal();
    }

    public int getChanceToStop() {
        if (this.internalLiquid == null) {
            return 0;
        }
        if (this.internalLiquid == LiquidStates.HEAVY) {
            return 75;
        }
        if (this.internalLiquid == LiquidStates.WATER) {
            return 50;
        }
        return 0;
    }

    public LiquidStates getLiquidState() {
        return this.internalLiquid;
    }

    public void setLiquidState(LiquidStates liq) {
        this.internalLiquid = liq;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public int getMaxTemperature() {
        return 1000;
    }

    private void onMeltdown(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.setLiquidState(LiquidStates.list[NBT.func_74762_e("liq")]);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("liq", this.getLiquidState().ordinal());
    }

    @Override
    public boolean canDumpHeatInto(LiquidStates liq) {
        return liq != LiquidStates.EMPTY && this.getLiquidState().isWater() == liq.isWater();
    }

    public static enum LiquidStates {
        EMPTY(null),
        WATER(FluidRegistry.WATER),
        HEAVY(FluidRegistry.getFluid((String)"rc heavy water")),
        SODIUM(FluidRegistry.getFluid((String)"rc sodium")),
        LITHIUM(FluidRegistry.getFluid((String)"rc lifbe"));

        public static final LiquidStates[] list;
        private static final HashMap<Fluid, LiquidStates> map;
        private final Fluid fluid;

        private LiquidStates(Fluid f) {
            this.fluid = f;
        }

        public boolean isWater() {
            return this == WATER || this == HEAVY;
        }

        public static LiquidStates getState(Fluid f) {
            return map.get(f);
        }

        static {
            list = LiquidStates.values();
            map = new HashMap();
            for (int i = 1; i < list.length; ++i) {
                LiquidStates lq = list[i];
                map.put(lq.fluid, lq);
            }
        }
    }
}

