/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fusion;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.MultiBlockTile;
import Reika.ReactorCraft.Base.BlockReCMultiBlock;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.TileEntityMagneticPipe;
import Reika.RotaryCraft.API.Interfaces.Laserable;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFusionHeater
extends TileEntityReactorBase
implements TemperatureTE,
Laserable,
IFluidHandler,
PipeConnector,
MultiBlockTile {
    public static final int PLASMA_TEMP = 150000000;
    private int temperature;
    private boolean hasMultiBlock = false;
    private final HybridTank tank = new HybridTank("fusionheater", 8000);
    private final HybridTank h2 = new HybridTank("fusionheaterh2", 4000);
    private final HybridTank h3 = new HybridTank("fusionheaterh3", 4000);

    @Override
    public boolean hasMultiBlock() {
        return this.hasMultiBlock && !ReikaWorldHelper.isExposedToAir((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
    }

    @Override
    public void setHasMultiBlock(boolean has) {
        this.hasMultiBlock = has && !ReikaWorldHelper.isExposedToAir((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
    }

    public void whenInBeam(World world, int x, int y, int z, long power, int range) {
        if (this.hasMultiBlock()) {
            this.temperature = (int)((double)this.temperature + 640.0 * ReikaMathLibrary.logbase((long)power, (int)2));
        }
    }

    public boolean blockBeam(World world, int x, int y, int z, long power) {
        return this.hasMultiBlock();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.updateTemperature(world, x, y, z, meta);
        if (DragonAPICore.debugtest) {
            this.temperature = 200000000;
        }
        if (this.canMake()) {
            this.make();
        }
    }

    private boolean canMake() {
        return this.hasMultiBlock() && this.temperature >= 150000000 && this.h2.getLevel() >= 50 && this.h3.getLevel() >= 50 && this.tank.canTakeIn(100);
    }

    private void make() {
        ReactorAchievements.PLASMA.triggerAchievement(this.getPlacer());
        this.h2.removeLiquid(50);
        this.h3.removeLiquid(50);
        this.tank.addLiquid(100, FluidRegistry.getFluid((String)"rc fusion plasma"));
    }

    public void updateTemperature(World world, int x, int y, int z, int meta) {
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        int dT = this.temperature - Tamb;
        if (dT != 0) {
            this.temperature = (int)((double)this.temperature - (1.0 + (double)dT / 16384.0));
        }
    }

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.HEATER;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    private boolean isHydrogen(Fluid f) {
        if (f.equals(FluidRegistry.getFluid((String)"rc deuterium"))) {
            return true;
        }
        return f.equals(FluidRegistry.getFluid((String)"rc tritium"));
    }

    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getThermalDamage() {
        return this.temperature / 1000;
    }

    public void overheat(World world, int x, int y, int z) {
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("temp", this.temperature);
        this.tank.writeToNBT(NBT);
        this.h2.writeToNBT(NBT);
        this.h3.writeToNBT(NBT);
        NBT.func_74757_a("multi", this.hasMultiBlock);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.temperature = NBT.func_74762_e("temp");
        this.tank.readFromNBT(NBT);
        this.h2.readFromNBT(NBT);
        this.h3.readFromNBT(NBT);
        this.hasMultiBlock = NBT.func_74767_n("multi");
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        if (resource.getFluid().equals(FluidRegistry.getFluid((String)"rc deuterium"))) {
            return this.h2.fill(resource, doFill);
        }
        if (resource.getFluid().equals(FluidRegistry.getFluid((String)"rc tritium"))) {
            return this.h3.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.canDrain(from, null) ? this.tank.drain(maxDrain, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.isHydrogen(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UP && this.getAdjacentTileEntity(from) instanceof TileEntityMagneticPipe && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.h2.getInfo(), this.h3.getInfo(), this.tank.getInfo()};
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return p.isStandardPipe() && side != ForgeDirection.UP;
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == ForgeDirection.UP ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.INPUT;
    }

    @Override
    public int getTextureState(ForgeDirection side) {
        return 0;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    public int getMaxTemperature() {
        return Integer.MAX_VALUE;
    }

    public void breakBlock() {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                int dx = this.field_145851_c + dir.offsetX;
                int dy = this.field_145848_d + dir.offsetY;
                int dz = this.field_145849_e + dir.offsetZ;
                Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
                if (!(b instanceof BlockReCMultiBlock)) continue;
                ((BlockReCMultiBlock)b).breakMultiBlock(this.field_145850_b, dx, dy, dz);
            }
        }
    }
}

