/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fusion;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.FlyingBlocksExplosion;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.ReactorCraft.Auxiliary.MultiBlockTile;
import Reika.ReactorCraft.Auxiliary.NeutronTile;
import Reika.ReactorCraft.Auxiliary.ReactorPowerReceiver;
import Reika.ReactorCraft.Base.BlockReCMultiBlock;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Blocks.Multi.BlockSolenoidMulti;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Fusion.TileEntityToroidMagnet;
import Reika.RotaryCraft.API.Power.PowerTransferHelper;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySolenoidMagnet
extends TileEntityReactorBase
implements ReactorPowerReceiver,
MultiBlockTile,
NeutronTile {
    private boolean hasMultiBlock = false;
    private boolean checkForToroids = true;
    private int torque;
    private int omega;
    private long power;
    private int iotick;
    private float speed = 0.0f;
    public static final int MINOMEGA = 256;
    public static final int MAX_SPEED = 8192;
    public static final int MINTORQUE = 32768;
    private static final int MAX_SAFE_SPEED = 30;

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.SOLENOID;
    }

    @Override
    public boolean hasMultiBlock() {
        return this.hasMultiBlock;
    }

    @Override
    public void setHasMultiBlock(boolean has) {
        if (this.hasMultiBlock && !has) {
            this.testBreakageFailure();
        }
        this.hasMultiBlock = has;
    }

    private void testBreakageFailure() {
        if (this.omega > 32) {
            this.fail(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void fail(World world, int x, int y, int z) {
        world.func_147468_f(x, y, z);
        new FlyingBlocksExplosion((TileEntity)this, 12.0f).doExplosion();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (!PowerTransferHelper.checkPowerFrom((TileEntity)this, (ForgeDirection)ForgeDirection.DOWN)) {
            this.noInputMachine();
        }
        float v = 0.1f;
        if (this.canTurn()) {
            if (this.speed > 30.0f) {
                v *= 3.0f;
            }
            this.speed = Math.min(this.speed + v, this.getMaxRenderSpeed());
        } else {
            this.speed = Math.max(0.0f, this.speed - v);
        }
        if (DragonAPICore.debugtest) {
            this.hasMultiBlock = true;
            this.torque = 262144;
            this.omega = 4096;
            this.power = (long)this.omega * (long)this.torque;
        }
        if (ReactorCraft.logger.shouldDebug()) {
            if (world.field_72995_K) {
                ReactorCraft.logger.log((Object)("Clientside " + this + " receiving " + this.torque + " Nm @ " + this.omega + " rad/s. Phi=" + this.phi));
            } else {
                ReactorCraft.logger.log((Object)("Serverside " + this + " receiving " + this.torque + " Nm @ " + this.omega + " rad/s."));
            }
        }
        if (DragonAPICore.debugtest || this.hasMultiBlock && this.checkForToroids && this.arePowerReqsMet()) {
            this.addToToroids();
        }
        if (!this.hasMultiBlock || !this.arePowerReqsMet()) {
            this.removeFromToroids();
        }
        if (this.hasMultiBlock && this.torque >= 32768 && this.speed > 120.0f) {
            world.func_147468_f(x, y, z);
            new FlyingBlocksExplosion((TileEntity)this, 16.0f).doExplosion();
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        if (!this.hasMultiBlock) {
            this.checkForMultiBlock(world, x, y, z);
        }
    }

    private void checkForMultiBlock(World world, int x, int y, int z) {
        BlockSolenoidMulti b;
        Block id = world.func_147439_a(x, y - 1, z);
        if (id == ReactorBlocks.SOLENOIDMULTI.getBlockInstance() && (b = (BlockSolenoidMulti)ReactorBlocks.SOLENOIDMULTI.getBlockInstance()).checkForFullMultiBlock(world, x, y - 1, z, ForgeDirection.UNKNOWN, null).booleanValue()) {
            b.onCreateFullMultiBlock(world, x, y - 1, z, true);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        this.phi = this.hasMultiBlock ? (this.phi += this.speed) : 0.0f;
    }

    private float getMaxRenderSpeed() {
        if (this.omega > 8192) {
            return 512.0f;
        }
        if (this.omega >= 4096) {
            return 30.0f;
        }
        if (this.omega >= 2048) {
            return 20.0f;
        }
        if (this.omega >= 1024) {
            return 7.5f;
        }
        return 4.5f;
    }

    public boolean canTurn() {
        return this.hasMultiBlock && this.power > 0L && this.torque >= 32768;
    }

    public boolean arePowerReqsMet() {
        return this.omega >= 256 && this.canTurn();
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74757_a("multi", this.hasMultiBlock);
        NBT.func_74768_a("omg", this.omega);
        NBT.func_74768_a("tq", this.torque);
        NBT.func_74772_a("pwr", this.power);
        NBT.func_74776_a("phi", this.phi);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.hasMultiBlock = NBT.func_74767_n("multi");
        this.omega = NBT.func_74762_e("omg");
        this.torque = NBT.func_74762_e("tq");
        this.power = NBT.func_74763_f("pwr");
        this.phi = NBT.func_74760_g("phi");
    }

    public void addToToroids() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x += 14, y, z -= 2);
        TileEntityToroidMagnet.Aim a = TileEntityToroidMagnet.Aim.W;
        for (int c = 0; (r == ReactorTiles.MAGNET || r == ReactorTiles.INJECTOR) && c <= 38; ++c) {
            if (r == ReactorTiles.MAGNET) {
                TileEntityToroidMagnet te = (TileEntityToroidMagnet)world.func_147438_o(x, y, z);
                te.hasSolenoid = true;
                a = te.getAim();
            }
            r = ReactorTiles.getTE((IBlockAccess)world, x += a.xOffset, y, z += a.zOffset);
        }
        this.checkForToroids = false;
    }

    public void removeFromToroids() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, x += 14, y, z -= 2);
        TileEntityToroidMagnet.Aim a = TileEntityToroidMagnet.Aim.W;
        for (int c = 0; (r == ReactorTiles.MAGNET || r == ReactorTiles.INJECTOR) && c < 38; ++c) {
            if (r == ReactorTiles.MAGNET) {
                TileEntityToroidMagnet te = (TileEntityToroidMagnet)world.func_147438_o(x, y, z);
                te.hasSolenoid = false;
                a = te.getAim();
            }
            r = ReactorTiles.getTE((IBlockAccess)world, x += a.xOffset, y, z += a.zOffset);
        }
        this.checkForToroids = true;
    }

    public boolean canRenderCoil() {
        return this.hasMultiBlock;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e).func_72314_b(9.0, 2.0, 9.0);
    }

    public int getOmega() {
        return this.omega;
    }

    public int getTorque() {
        return this.torque;
    }

    public long getPower() {
        return this.power;
    }

    public int getIORenderAlpha() {
        return this.iotick;
    }

    public void setIORenderAlpha(int io) {
        this.iotick = io;
    }

    public void setOmega(int omega) {
        this.omega = omega;
    }

    public void setTorque(int torque) {
        this.torque = torque;
    }

    public void setPower(long power) {
        this.power = power;
    }

    public boolean canReadFrom(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN;
    }

    public boolean isReceiving() {
        return true;
    }

    public void noInputMachine() {
        this.omega = 0;
        this.torque = 0;
        this.power = 0L;
    }

    public int getMinTorque(int available) {
        return 32768;
    }

    @Override
    public int getMinTorque() {
        return 32768;
    }

    @Override
    public int getMinSpeed() {
        return 256;
    }

    @Override
    public long getMinPower() {
        return 1L;
    }

    public int getUpdatePacketRadius() {
        return 96;
    }

    public void breakBlock() {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                int dx = this.field_145851_c + dir.offsetX;
                int dy = this.field_145848_d + dir.offsetY;
                int dz = this.field_145849_e + dir.offsetZ;
                Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
                if (!(b instanceof BlockReCMultiBlock)) continue;
                ((BlockReCMultiBlock)b).breakMultiBlock(this.field_145850_b, dx, dy, dz);
            }
        }
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        return false;
    }
}

