/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.PowerGen;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Base.TankedReactorPowerReceiver;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityReactorBoiler;
import Reika.RotaryCraft.Auxiliary.Interfaces.TemperatureTE;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileEntityHeatExchanger
extends TankedReactorPowerReceiver
implements TemperatureTE {
    public static final int CAPACITY = 2000;
    public static final int MINTEMP = -140;
    public static final int MAXTEMP = 1500;
    public static final int COOL_AMOUNT = 100;
    public static final int MINPOWER = 8192;
    public static final int MINSPEED = 512;
    private final HybridTank output = new HybridTank("exchangerout", this.getCapacity());
    private StepTimer temp = new StepTimer(20);
    private Exchange currentRecipe;

    @Override
    public final FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo(), this.output.getInfo()};
    }

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.EXCHANGER;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        this.currentRecipe = this.getExchange();
        if (this.canCool()) {
            this.cool();
        }
        this.temp.update();
        if (this.temp.checkCap()) {
            this.distributeHeat(world, x, y, z);
            this.updateTemperature(world, x, y, z, meta);
        }
    }

    public Exchange getCurrentRecipe() {
        return this.currentRecipe;
    }

    private void distributeHeat(World world, int x, int y, int z) {
        for (int i = 2; i < 6; ++i) {
            TileEntityReactorBoiler te;
            int dT;
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (r != ReactorTiles.BOILER || (dT = this.temperature - (te = (TileEntityReactorBoiler)world.func_147438_o(dx, dy, dz)).getTemperature()) <= 0) continue;
            this.temperature -= dT / 4;
            int add = dT / 4;
            te.setTemperature(te.getTemperature() + add);
            te.setReactorType(this.currentRecipe != null ? this.currentRecipe.type : ReactorType.NONE, add);
        }
    }

    private void cool() {
        this.tank.removeLiquid(100);
        this.output.addLiquid(100 * this.currentRecipe.expansionRatio, this.currentRecipe.coldFluid);
        double eff = Math.min(1.0, Math.max(0.1, 1.0 - (double)(this.temperature - 100) / ((double)this.currentRecipe.maxTemperature - 100.0)));
        this.temperature = (int)((double)this.temperature + this.currentRecipe.heatCapacity * 100.0 * eff);
        if (this.temperature > 1500) {
            this.temperature = 1500;
        }
        if (this.temperature < -140) {
            this.temperature = -140;
        }
    }

    private Exchange getExchange() {
        for (int i = 0; i < Exchange.list.length; ++i) {
            Exchange e = Exchange.list[i];
            Fluid in = e.hotFluid;
            if (in == null || !in.equals(this.tank.getActualFluid())) continue;
            return e;
        }
        return null;
    }

    private boolean canCoolFluid(Fluid f) {
        for (int i = 0; i < Exchange.list.length; ++i) {
            Fluid fl = Exchange.list[i].hotFluid;
            if (!fl.equals(f)) continue;
            return true;
        }
        return false;
    }

    private boolean canCool() {
        if (this.currentRecipe == null) {
            return false;
        }
        if (!this.sufficientPower()) {
            return false;
        }
        return this.temperature < this.currentRecipe.maxTemperature && this.tank.getLevel() >= 100 && this.output.getRemainingSpace() >= 100 * this.currentRecipe.expansionRatio && this.canCoolFluid(this.tank.getActualFluid());
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from, null)) {
            return null;
        }
        return this.output.drain(maxDrain, doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.offsetY == 0 && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return side != ForgeDirection.DOWN && this.canConnectToPipe(p);
    }

    @Override
    public int getCapacity() {
        return 2000;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return from == ForgeDirection.UP;
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public boolean isValidFluid(Fluid f) {
        for (int i = 0; i < Exchange.list.length; ++i) {
            Fluid in = Exchange.list[i].hotFluid;
            if (!f.equals(in)) continue;
            return true;
        }
        return false;
    }

    public void updateTemperature(World world, int x, int y, int z, int meta) {
        ForgeDirection lavaside;
        ForgeDirection fireside;
        ForgeDirection iceside;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        ForgeDirection waterside = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h);
        if (waterside != null) {
            Tamb /= 2;
        }
        if ((iceside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
            if (Tamb > 0) {
                Tamb /= 4;
            }
            ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)iceside, (Block)Blocks.field_150358_i, (int)0);
        }
        if ((fireside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150480_ab)) != null) {
            Tamb += 200;
            if (this.temperature < 100) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)fireside, (Block)Blocks.field_150350_a, (int)0);
            } else {
                world.func_147468_f(x, y, z);
                world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 6.0f, ConfigRegistry.BLOCKDAMAGE.getState());
            }
        }
        if ((lavaside = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i)) != null) {
            Tamb += 600;
            if (this.temperature < 100) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)lavaside, (Block)Blocks.field_150348_b, (int)0);
            } else {
                world.func_147468_f(x, y, z);
                world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 6.0f, ConfigRegistry.BLOCKDAMAGE.getState());
            }
        }
        if (this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > Tamb * 2) {
            --this.temperature;
        }
        if (this.temperature < Tamb) {
            ++this.temperature;
        }
        if (this.temperature * 2 < Tamb) {
            ++this.temperature;
        }
        if (this.temperature > 1500) {
            this.temperature = 1500;
        }
        if (this.temperature < -140) {
            this.temperature = -140;
        }
        if (this.temperature > 100) {
            ForgeDirection side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150433_aE);
            if (side != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150350_a, (int)0);
            }
            if ((side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150358_i, (int)0);
            }
        }
    }

    public void addTemperature(int temp) {
        this.temperature += temp;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public int getThermalDamage() {
        return this.temperature / 250;
    }

    public void overheat(World world, int x, int y, int z) {
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return TileEntityPiping.Flow.NONE;
        }
        return this.canReceiveFrom(side) ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.OUTPUT;
    }

    public boolean canReadFrom(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection side) {
        return type == IPipeTile.PipeType.FLUID && side != ForgeDirection.DOWN ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.output.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.output.writeToNBT(NBT);
    }

    public int getMinTorque(int available) {
        return 16;
    }

    @Override
    public int getMinTorque() {
        return 1;
    }

    @Override
    public int getMinSpeed() {
        return 512;
    }

    @Override
    public long getMinPower() {
        return 8192L;
    }

    @Override
    public boolean canBeCooledWithFins() {
        return true;
    }

    @Override
    public boolean allowExternalHeating() {
        return false;
    }

    public void setTemperature(int temp) {
        this.temperature = temp;
    }

    public int getMaxTemperature() {
        return 1500;
    }

    public static enum Exchange {
        SODIUM(ReactorCraft.NA_hot, ReactorCraft.NA, 1.23, 600, ReactorType.BREEDER),
        CO2("rc hot co2", "rc co2", 1.168, 800, ReactorType.HTGR),
        LIFBE("rc hot lifbe", "rc lifbe", 1.102, 1000, ReactorType.THORIUM),
        OXYGEN("rc liquid oxygen", "rc oxygen", 4, -1.0265625, 500, ReactorType.NONE),
        SOLARSODIUM(ReactorCraft.NA_warm, ReactorCraft.NA, 0.46125, 400, ReactorType.SOLAR),
        NITROGEN("rc liquid nitrogen", "nitrogen", 12, -3.833, 500, ReactorType.NONE);

        public final Fluid hotFluid;
        public final Fluid coldFluid;
        public final double heatCapacity;
        public final int maxTemperature;
        public final int expansionRatio;
        public final ReactorType type;
        public static final Exchange[] list;

        private Exchange(String from, String to, double c, int max, ReactorType t) {
            this(from, to, 1, c, max, t);
        }

        private Exchange(Fluid from, Fluid to, double c, int max, ReactorType t) {
            this(from, to, 1, c, max, t);
        }

        private Exchange(String from, String to, int r, double c, int max, ReactorType t) {
            this(FluidRegistry.getFluid((String)from), FluidRegistry.getFluid((String)to), r, c, max, t);
        }

        private Exchange(Fluid from, Fluid to, int r, double c, int max, ReactorType t) {
            this.coldFluid = to;
            this.hotFluid = from;
            this.heatCapacity = c;
            this.maxTemperature = max;
            this.type = t;
            this.expansionRatio = r;
        }

        static {
            list = Exchange.values();
        }
    }
}

