/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.PowerGen;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Collections.RelativePositionList;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Proportionality;
import Reika.DragonAPI.Instantiable.FlyingBlocksExplosion;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import Reika.DragonAPI.ModInteract.AtmosphereHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.BCMachineHandler;
import Reika.ReactorCraft.Auxiliary.MultiBlockTile;
import Reika.ReactorCraft.Base.BlockReCMultiBlock;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.ReactorType;
import Reika.ReactorCraft.Registry.WorkingFluid;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntitySteamInjector;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntitySteamLine;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityTurbineCore;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Storage.TileEntityReservoir;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityHiPTurbine
extends TileEntityTurbineCore
implements MultiBlockTile {
    public static final int GEN_OMEGA = 131072;
    public static final int FLUID_PER_RESERVOIR = 32;
    private WorkingFluid fluid = WorkingFluid.EMPTY;
    private int dripBuffer;

    private RelativePositionList getInjectors() {
        RelativePositionList injectors = new RelativePositionList();
        ForgeDirection dir = this.getSteamMovement();
        if (dir.offsetX == 0) {
            injectors.addPosition(1, 1, 0);
            injectors.addPosition(0, 1, 0);
            injectors.addPosition(-1, 1, 0);
            injectors.addPosition(1, 0, 0);
            injectors.addPosition(-1, 0, 0);
            injectors.addPosition(1, -1, 0);
            injectors.addPosition(0, -1, 0);
            injectors.addPosition(-1, -1, 0);
        } else if (dir.offsetZ == 0) {
            injectors.addPosition(0, 1, 1);
            injectors.addPosition(0, 1, 0);
            injectors.addPosition(0, 1, -1);
            injectors.addPosition(0, 0, 1);
            injectors.addPosition(0, 0, -1);
            injectors.addPosition(0, -1, 1);
            injectors.addPosition(0, -1, 0);
            injectors.addPosition(0, -1, -1);
        }
        return injectors;
    }

    @Override
    public boolean needsMultiblock() {
        return !DragonAPICore.debugtest;
    }

    @Override
    public void setHasMultiBlock(boolean has) {
        if (this.hasMultiBlock && !has) {
            this.testBreakageFailure();
        }
        super.setHasMultiBlock(has);
    }

    private void testBreakageFailure() {
        if (this.omega > 2048) {
            this.fail(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void fail(World world, int x, int y, int z) {
        world.func_147468_f(x, y, z);
        new FlyingBlocksExplosion(world, (double)x, (double)y + 0.5, (double)z, 4.0f).doExplosion();
    }

    @Override
    protected boolean checkForMultiblock(World world, int x, int y, int z, int meta) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = this.dirs[i];
            if (dir == this.getSteamMovement() || dir.getOpposite() == this.getSteamMovement()) continue;
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            Block mid = world.func_147439_a(dx, dy, dz);
            int mmeta = world.func_72805_g(dx, dy, dz);
            if (mid != ReactorBlocks.TURBINEMULTI.getBlockInstance()) {
                return false;
            }
            if (mmeta >= 8) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getMaxTorque() {
        return this.fluid.efficiency > 1.0f ? 131072 : 65536;
    }

    @Override
    public int getMaxSpeed() {
        return 131072;
    }

    @Override
    protected int getMaxStage() {
        return 6;
    }

    @Override
    protected double getRadius() {
        return 1.5 + (double)(this.getStage() / 2);
    }

    @Override
    protected void copyDataFrom(TileEntityTurbineCore tile) {
        super.copyDataFrom(tile);
        TileEntityHiPTurbine te = (TileEntityHiPTurbine)tile;
        this.fluid = te.fluid;
        this.dripBuffer = te.dripBuffer;
        te.dripBuffer = 0;
    }

    @Override
    protected void dumpSteam(World world, int x, int y, int z, int meta) {
        if (this.dripBuffer > 0 && this.dumpLiquid(world, x, y, z, meta)) {
            ForgeDirection s = this.getSteamMovement();
            ForgeDirection dir = ReikaDirectionHelper.getLeftBy90((ForgeDirection)s);
            int th = (int)this.getRadius();
            if (!world.field_72995_K) {
                for (int d = 0; d <= 1; ++d) {
                    for (int dy = 2; dy < 5; ++dy) {
                        int ty = y - th - dy;
                        for (int i = -th; i <= th; ++i) {
                            int tx = x + dir.offsetX * i + s.offsetX * d;
                            int tz = z + dir.offsetZ * i + s.offsetZ * d;
                            MachineRegistry m = MachineRegistry.getMachine((IBlockAccess)world, (int)tx, (int)ty, (int)tz);
                            if (this.fluid == null || this.fluid.getLowPressureFluid() == null) {
                                // empty if block
                            }
                            FluidStack fs = new FluidStack(this.fluid.getLowPressureFluid(), 32);
                            if (m == MachineRegistry.RESERVOIR) {
                                TileEntity te = this.getTileEntity(tx, ty, tz);
                                ((TileEntityReservoir)te).addLiquid(fs.amount, fs.getFluid());
                                this.dripBuffer -= fs.amount;
                                break;
                            }
                            if (world.func_147439_a(tx, ty, tz) == BCMachineHandler.getInstance().tankID) {
                                TileEntity te = this.getTileEntity(tx, ty, tz);
                                ((IFluidHandler)te).fill(ForgeDirection.UP, fs, true);
                                this.dripBuffer -= fs.amount;
                                break;
                            }
                            int py = ty + 1 + rand.nextInt(th * 2);
                            if (!(ReikaMathLibrary.py3d((double)(dir.offsetX * i), (double)(py - y), (double)(dir.offsetZ * i)) < (double)th)) continue;
                            ReikaParticleHelper.DRIPWATER.spawnAroundBlock(world, x + dir.offsetX * i, py, z + dir.offsetZ * i, 5);
                        }
                        if (this.dripBuffer <= 0) break;
                    }
                    if (this.dripBuffer <= 0) break;
                }
            }
            int n = ConfigRegistry.SPRINKLER.getValue() * 12;
            double ax = s.offsetX > 0 ? 1.2 : -0.2;
            double az = s.offsetZ > 0 ? 1.2 : -0.2;
            int d = -s.offsetX + s.offsetZ;
            for (int i = 0; i < n; ++i) {
                double px = (double)x + ((double)(-th) + rand.nextDouble() * (double)th * 2.0 + (double)d) * (double)dir.offsetX;
                double pz = (double)z + ((double)(-th) + rand.nextDouble() * (double)th * 2.0 + (double)d) * (double)dir.offsetZ;
                ReikaParticleHelper.RAIN.spawnAt(world, px + ax, (double)(y - th + 1 + rand.nextInt(th * 2)), pz + az);
            }
        }
    }

    private boolean dumpLiquid(World world, int x, int y, int z, int meta) {
        if (AtmosphereHandler.isNoAtmo((World)world, (int)(x + this.getSteamMovement().offsetX), (int)y, (int)(z + this.getSteamMovement().offsetZ), (Block)this.field_145854_h, (boolean)false)) {
            return false;
        }
        return this.getStage() == this.getNumberStagesTotal() - 1;
    }

    @Override
    protected double getEfficiency() {
        switch (this.getNumberStagesTotal()) {
            case 1: {
                return 0.0125;
            }
            case 2: {
                return 0.025;
            }
            case 3: {
                return 0.075;
            }
            case 4: {
                return 0.125;
            }
            case 5: {
                return 0.25;
            }
            case 6: {
                return 0.5;
            }
            case 7: {
                return 1.0;
            }
        }
        return 0.0;
    }

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.BIGTURBINE;
    }

    @Override
    protected double getAnimationSpeed() {
        return 0.5;
    }

    @Override
    protected void intakeLubricant(World world, int x, int y, int z, int meta) {
        ForgeDirection dir = this.getSteamMovement().getOpposite();
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        if (this.getStage() == 0) {
            RelativePositionList li = this.getInjectors();
            BlockArray pos = li.getPositionsRelativeTo(dx, dy, dz);
            for (int i = 0; i < pos.getSize(); ++i) {
                TileEntitySteamInjector te;
                int lube;
                int rem;
                Coordinate c = pos.getNthBlock(i);
                int sx = c.xCoord;
                int sy = c.yCoord;
                int sz = c.zCoord;
                TileEntity tile = world.func_147438_o(sx, sy, sz);
                if (!(tile instanceof TileEntitySteamInjector) || (rem = Math.min(lube = (te = (TileEntitySteamInjector)tile).getLubricant(), this.tank.getRemainingSpace())) <= 0) continue;
                te.remove(rem);
                this.tank.addLiquid(rem, FluidRegistry.getFluid((String)"rc lubricant"));
            }
        }
    }

    @Override
    protected boolean enabled(World world, int x, int y, int z) {
        if (!DragonAPICore.debugtest && this.tank.isEmpty()) {
            return false;
        }
        if (this.isRedstoned(world, x, y, z)) {
            return false;
        }
        return super.enabled(world, x, y, z);
    }

    private boolean isRedstoned(World world, int x, int y, int z) {
        ForgeDirection dir = this.getSteamMovement().getOpposite();
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        RelativePositionList li = this.getInjectors();
        BlockArray pos = li.getPositionsRelativeTo(dx, dy, dz);
        for (int i = 0; i < pos.getSize(); ++i) {
            Coordinate c = pos.getNthBlock(i);
            int sx = c.xCoord;
            int sy = c.yCoord;
            int sz = c.zCoord;
            if (!world.func_72864_z(sx, sy, sz)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean intakeSteam(World world, int x, int y, int z, int meta) {
        ForgeDirection dir = this.getSteamMovement().getOpposite();
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        boolean flag = false;
        if (DragonAPICore.debugtest) {
            this.steam = 5000;
            this.fluid = WorkingFluid.WATER;
            this.dripBuffer = 5000;
            return true;
        }
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
        if (r == ReactorTiles.STEAMLINE) {
            TileEntitySteamLine te = (TileEntitySteamLine)this.getAdjacentTileEntity(dir);
            int s = te.getSteam();
            if (s > 8 && this.canTakeIn(te.getWorkingFluid())) {
                Proportionality<ReactorType> source = te.getSourceReactorType();
                int n = s = source != null ? this.getEffectiveUsable(s, source) : 0;
                if (s > 0) {
                    int rm = s / 8 + 1;
                    if (this.steam < this.getMaxSteam()) {
                        int rm2 = Math.min(rm, this.getMaxSteam() - this.steam);
                        this.steam += rm2;
                        this.fluid = te.getWorkingFluid();
                        te.removeSteam(rm2);
                        this.dripBuffer += rm2 * 1000;
                    }
                    flag = s > rm + 32 && this.steam >= this.getMaxSteam() / 15;
                }
            }
        } else if (r == this.getTile()) {
            TileEntityHiPTurbine te = (TileEntityHiPTurbine)this.getAdjacentTileEntity(dir);
            this.fluid = te.fluid;
        }
        if (this.steam == 0) {
            this.fluid = WorkingFluid.EMPTY;
        }
        return flag;
    }

    private int getEffectiveUsable(int s, Proportionality<ReactorType> source) {
        float ret = 0.0f;
        for (ReactorType r : source.getElements()) {
            if (r == null) continue;
            ret = (float)((double)ret + source.getFraction((Object)r) * (double)s * r.getHPTurbineMultiplier());
        }
        return (int)ret;
    }

    private int getMaxSteam() {
        return 3250;
    }

    @Override
    protected int getConsumedLubricant() {
        return 100;
    }

    private boolean canTakeIn(WorkingFluid f) {
        return this.fluid == WorkingFluid.EMPTY || f == this.fluid;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.fluid = WorkingFluid.getFromNBT(NBT);
        this.dripBuffer = NBT.func_74762_e("dripb");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        this.fluid.saveToNBT(NBT);
        NBT.func_74768_a("dripb", this.dripBuffer);
    }

    @Override
    protected float getTorqueFactor() {
        float base = super.getTorqueFactor();
        if (this.steam < this.getMaxSteam() / 2) {
            float f = (float)this.steam / (float)this.getMaxSteam();
            base = (float)((double)base * ReikaMathLibrary.cosInterpolation((double)0.0, (double)1.0, (double)f, (double)0.0, (double)1.0));
        }
        if (this.fluid.efficiency > 1.0f) {
            base *= 1.0f + (this.fluid.efficiency - 1.0f) * 0.25f;
        }
        return base;
    }

    @Override
    public void breakBlock() {
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = this.dirs[i];
                int dx = this.field_145851_c + dir.offsetX;
                int dy = this.field_145848_d + dir.offsetY;
                int dz = this.field_145849_e + dir.offsetZ;
                Block b = this.field_145850_b.func_147439_a(dx, dy, dz);
                if (!(b instanceof BlockReCMultiBlock)) continue;
                ((BlockReCMultiBlock)b).breakMultiBlock(this.field_145850_b, dx, dy, dz);
            }
        }
    }

    @Override
    protected int getLubricantCapacity() {
        return 128000;
    }

    @Override
    protected boolean canCollideCheck() {
        return false;
    }
}

