/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.PowerGen;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.ModInteract.AtmosphereHandler;
import Reika.ReactorCraft.Auxiliary.SteamTile;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Blocks.BlockSteam;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.Registry.WorkingFluid;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntitySteamLine;
import Reika.RotaryCraft.API.Interfaces.Screwdriverable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySteamGrate
extends TileEntityReactorBase
implements Screwdriverable,
SteamTile {
    private int steam;
    private boolean requireRedstone;
    private WorkingFluid fluid = WorkingFluid.EMPTY;

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.getSteam(world, x, y, z);
        if (!world.field_72995_K && this.canMakeSteam(world, x, y, z)) {
            --this.steam;
            world.func_147465_d(x, y + 1, z, ReactorBlocks.STEAM.getBlockInstance(), this.getSteamMetadata(), 3);
        }
        if (this.steam <= 0) {
            this.fluid = WorkingFluid.EMPTY;
        }
        if (DragonAPICore.debugtest) {
            this.steam = 3;
        }
    }

    private boolean canMakeSteam(World world, int x, int y, int z) {
        if (this.steam <= 0) {
            return false;
        }
        if (this.hasRedstoneSignal() != this.requireRedstone) {
            return false;
        }
        if (AtmosphereHandler.isNoAtmo((World)world, (int)x, (int)(y + 1), (int)z, (Block)this.field_145854_h, (boolean)false)) {
            return false;
        }
        return ((BlockSteam)ReactorBlocks.STEAM.getBlockInstance()).canMoveInto(world, x, y + 1, z);
    }

    private ForgeDirection getFacing(int meta) {
        switch (meta) {
            case 0: {
                return ForgeDirection.EAST;
            }
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.NORTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    private int getSteamMetadata() {
        if (this.fluid == WorkingFluid.AMMONIA) {
            return 7;
        }
        return 3;
    }

    private boolean canTakeInWorkingFluid(WorkingFluid f) {
        if (f == WorkingFluid.EMPTY) {
            return false;
        }
        if (this.fluid == WorkingFluid.EMPTY) {
            return true;
        }
        return this.fluid == f;
    }

    private void getSteam(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            TileEntitySteamLine te;
            ForgeDirection dir = this.dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            ReactorTiles rt = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
            if (rt != ReactorTiles.STEAMLINE || !this.canTakeInWorkingFluid((te = (TileEntitySteamLine)world.func_147438_o(dx, dy, dz)).getWorkingFluid())) continue;
            this.fluid = te.getWorkingFluid();
            int ds = te.getSteam() - this.steam;
            if (ds <= 0) continue;
            int rm = ds / 4 + 1;
            this.steam += rm;
            te.removeSteam(rm);
        }
    }

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.GRATE;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.steam = NBT.func_74762_e("energy");
        this.fluid = WorkingFluid.getFromNBT(NBT);
        this.requireRedstone = NBT.func_74767_n("red");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("energy", this.steam);
        this.fluid.saveToNBT(NBT);
        NBT.func_74757_a("red", this.requireRedstone);
    }

    public boolean onShiftRightClick(World world, int x, int y, int z, ForgeDirection side) {
        this.requireRedstone = !this.requireRedstone;
        return this.requireRedstone;
    }

    public boolean onRightClick(World world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    @Override
    public int getSteam() {
        return this.steam;
    }
}

