/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Processing;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.ReactorCraft.Auxiliary.ReactorPowerReceiver;
import Reika.ReactorCraft.Auxiliary.ReactorStacks;
import Reika.ReactorCraft.Base.TileEntityInventoriedReactorBase;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.API.Power.BasicPowerHandler;
import Reika.RotaryCraft.API.Power.PowerTransferHelper;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityCentrifuge
extends TileEntityInventoriedReactorBase
implements IFluidHandler,
ReactorPowerReceiver,
PipeConnector {
    public static final int MINSPEED = 262144;
    public static final int UF6_PER_DUST = 50;
    public static final int FUEL_CHANCE = 9;
    private static final HashMap<Fluid, Centrifuging> recipes = new HashMap();
    private final HybridTank tank = new HybridTank("centri", 12000);
    private StepTimer timer = new StepTimer(900);
    private final BasicPowerHandler powerHandler = new BasicPowerHandler();
    public int split;

    public TileEntityCentrifuge() {
        ReikaJavaLibrary.initClass(Centrifuging.class, (boolean)true);
    }

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.CENTRIFUGE;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
        int omega = this.powerHandler.getOmega();
        if (omega >= 262144) {
            this.phi += 40.0f;
        } else if (omega >= 65536) {
            this.phi += 30.0f;
        } else if (omega >= 16384) {
            this.phi += 20.0f;
        } else if (omega >= 4096) {
            this.phi += 15.0f;
        }
        if (omega >= 1024) {
            this.phi += 10.0f;
        }
        if (omega >= 256) {
            this.phi += 7.0f;
        } else if (omega > 0) {
            this.phi += 5.0f;
        }
        this.powerHandler.decrementIOTick(8);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.timer.setCap(this.setTimer());
        if (!PowerTransferHelper.checkPowerFrom((TileEntity)this, (ForgeDirection)ForgeDirection.DOWN)) {
            this.noInputMachine();
        }
        if (this.powerHandler.getPower() > 0L && this.powerHandler.getOmega() >= 262144 && !this.tank.isEmpty()) {
            Centrifuging recipe = recipes.get(this.tank.getActualFluid());
            if (recipe != null && this.tank.getLevel() >= recipe.fluidAmount && this.hasInventorySpace(recipe)) {
                this.timer.update(recipe.speedFactor);
                if (this.timer.checkCap() && !world.field_72995_K) {
                    this.make(recipe);
                }
            } else {
                this.timer.reset();
            }
        } else {
            this.timer.reset();
        }
        if (!world.field_72995_K) {
            this.split = this.timer.getTick();
        }
    }

    private int setTimer() {
        int omega = this.powerHandler.getOmega();
        if (omega >= 0x4000000) {
            return 8;
        }
        if (omega >= 0x2000000) {
            return 20;
        }
        if (omega >= 0x1000000) {
            return 50;
        }
        if (omega >= 0x800000) {
            return 100;
        }
        if (omega >= 0x400000) {
            return 240;
        }
        if (omega >= 0x200000) {
            return 400;
        }
        if (omega >= 0x100000) {
            return 600;
        }
        if (omega >= 524288) {
            return 800;
        }
        return 900;
    }

    private void make(Centrifuging recipe) {
        this.tank.removeLiquid(recipe.fluidAmount);
        if (ReikaRandomHelper.doWithPercentChance((double)recipe.chanceOfAOverB)) {
            ReikaInventoryHelper.addOrSetStack((ItemStack)recipe.getOutputA(), (ItemStack[])this.inv, (int)0);
        } else if (recipe.outputB != null) {
            ReikaInventoryHelper.addOrSetStack((ItemStack)recipe.getOutputB(), (ItemStack[])this.inv, (int)1);
        }
    }

    private boolean hasInventorySpace(Centrifuging recipe) {
        if (this.inv[0] != null && !ReikaItemHelper.matchStacks((ItemStack)this.inv[0], (ItemStack)recipe.outputA)) {
            return false;
        }
        if (this.inv[1] != null && recipe.outputB != null && !ReikaItemHelper.matchStacks((ItemStack)this.inv[1], (ItemStack)recipe.outputB)) {
            return false;
        }
        if (this.inv[0] != null && this.inv[0].field_77994_a >= this.inv[0].func_77976_d()) {
            return false;
        }
        return this.inv[1] == null || this.inv[1].field_77994_a < this.inv[1].func_77976_d();
    }

    public int getProcessingScaled(int p) {
        return (int)((float)(p * this.split) / (float)this.timer.getCap());
    }

    public int getFluidScaled(int p) {
        return p * this.tank.getLevel() / this.tank.getCapacity();
    }

    @Override
    public boolean canRemoveItem(int i, ItemStack itemstack) {
        return true;
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public int getOmega() {
        return this.powerHandler.getOmega();
    }

    public int getTorque() {
        return this.powerHandler.getTorque();
    }

    public long getPower() {
        return this.powerHandler.getPower();
    }

    public int getIORenderAlpha() {
        return this.powerHandler.getIORenderAlpha();
    }

    public void setIORenderAlpha(int io) {
        this.powerHandler.setIORenderAlpha(io);
    }

    public void setOmega(int omega) {
        this.powerHandler.setOmega(omega);
    }

    public void setTorque(int torque) {
        this.powerHandler.setTorque(torque);
    }

    public void setPower(long power) {
        this.powerHandler.setPower(power);
    }

    public boolean canReadFrom(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN;
    }

    public boolean isReceiving() {
        return true;
    }

    public void noInputMachine() {
        this.powerHandler.noInputMachine();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.tank.fill(resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from == ForgeDirection.UP && recipes.containsKey(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.split = NBT.func_74762_e("time");
        this.powerHandler.readFromNBT(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("time", this.split);
        this.powerHandler.writeToNBT(NBT);
        this.tank.writeToNBT(NBT);
    }

    public boolean canAcceptMoreUF6(int amt) {
        return this.tank.getFluid() == null || this.tank.getFluid().amount + amt <= this.tank.getCapacity();
    }

    public void addUF6(int amt) {
        this.tank.addLiquid(amt, ReactorCraft.UF6);
    }

    public void removeFluid(int volume) {
        this.tank.removeLiquid(volume);
    }

    @Override
    public boolean canItemEnterFromSide(ForgeDirection dir) {
        return false;
    }

    @Override
    public boolean canItemExitToSide(ForgeDirection dir) {
        return dir.offsetY != 0;
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p) && side == ForgeDirection.UP;
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == ForgeDirection.UP ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }

    public int getMinTorque(int available) {
        return 1;
    }

    @Override
    public int getMinTorque() {
        return 1;
    }

    @Override
    public int getMinSpeed() {
        return 262144;
    }

    @Override
    public long getMinPower() {
        return 1L;
    }

    public int getUF6() {
        return this.tank.getActualFluid() == ReactorCraft.UF6 ? this.tank.getLevel() : 0;
    }

    public Fluid getFluid() {
        return this.tank.getActualFluid();
    }

    public static Collection<Centrifuging> getRecipes() {
        ReikaJavaLibrary.initClass(Centrifuging.class, (boolean)true);
        return Collections.unmodifiableCollection(recipes.values());
    }

    public static Centrifuging getRecipe(Fluid f) {
        ReikaJavaLibrary.initClass(Centrifuging.class, (boolean)true);
        return recipes.get(f);
    }

    public static enum Centrifuging {
        UF6(ReactorCraft.UF6, 50, ReactorStacks.fueldust, ReactorStacks.depdust, 9.0f);

        public final Fluid input;
        public final int fluidAmount;
        private final ItemStack outputA;
        private final ItemStack outputB;
        public final float chanceOfAOverB;
        public final int minSpeed;
        public final int speedFactor;

        private Centrifuging(Fluid f, int amt, ItemStack a, ItemStack b, float c) {
            this(f, amt, a, b, c, 262144, 1);
        }

        private Centrifuging(Fluid f, int amt, ItemStack a, ItemStack b, float c, int ms, int sf) {
            this.input = f;
            this.fluidAmount = amt;
            this.outputA = a;
            this.outputB = b;
            this.chanceOfAOverB = c;
            this.minSpeed = ms;
            this.speedFactor = sf;
            if (recipes.containsKey(f)) {
                throw new IllegalArgumentException("Fluid " + f.getName() + " already registered to a recipe!");
            }
            recipes.put(f, this);
        }

        public ItemStack getOutputA() {
            return this.outputA.func_77946_l();
        }

        public ItemStack getOutputB() {
            return this.outputB != null ? this.outputB.func_77946_l() : null;
        }

        public boolean produces(ItemStack result) {
            return ReikaItemHelper.matchStacks((ItemStack)this.outputA, (ItemStack)result) || this.outputB != null && ReikaItemHelper.matchStacks((ItemStack)this.outputB, (ItemStack)result);
        }
    }
}

