/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Processing;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.Recipe.FlexibleIngredient;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.ReactorStacks;
import Reika.ReactorCraft.Base.TileEntityInventoriedReactorBase;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.API.Interfaces.ThermalMachine;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import buildcraft.api.tiles.IHasWork;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@APIStripper.Strippable(value={"buildcraft.api.tiles.IHasWork"})
public class TileEntitySynthesizer
extends TileEntityInventoriedReactorBase
implements IFluidHandler,
ThermalMachine,
PipeConnector,
IHasWork {
    private static final int WATER_PER_AMMONIA = 250;
    private static final int AMMONIA_PER_STEP = 1000;
    public static final int AMMONIATEMP = 220;
    private static final int MAXTEMP = 1000;
    private static final HashMap<Fluid, FluidSynthesis> fluidMap = new HashMap();
    public int timer;
    private FluidSynthesis recipe;
    private final HybridTank tank = new HybridTank("synthout", 24000);
    private final HybridTank water = new HybridTank("synthwater", 24000);
    private StepTimer steptimer = new StepTimer(1800);
    private StepTimer tempTimer = new StepTimer(20);

    public static void addRecipe(String name, Fluid in, Fluid out, int amtin, int amtout, int temp, int time, int curve, FlexibleIngredient a, FlexibleIngredient b) {
        Class[] types = new Class[]{Fluid.class, Fluid.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, FlexibleIngredient.class, FlexibleIngredient.class};
        Object[] args = new Object[]{in, out, amtin, amtout, temp, time, curve, a, b};
        FluidSynthesis c = (FluidSynthesis)EnumHelper.addEnum(FluidSynthesis.class, (String)name.toUpperCase(), (Class[])types, (Object[])args);
    }

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.SYNTHESIZER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.getWaterBuckets();
        this.recipe = this.getRecipe();
        if (this.recipe != null) {
            this.steptimer.setCap(this.recipe.getDuration(this.temperature));
        }
        if (this.recipe != null && this.water.getLevel() >= this.recipe.fluidConsumed && this.temperature >= this.recipe.minTemp && this.tank.canTakeIn(this.recipe.output, this.recipe.fluidProduced)) {
            this.steptimer.update();
            if (this.steptimer.checkCap()) {
                this.make();
            }
        } else {
            this.steptimer.reset();
        }
        this.timer = this.steptimer.getTick();
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z, meta);
        }
    }

    private FluidSynthesis getRecipe() {
        if (this.water.isEmpty()) {
            return null;
        }
        FluidSynthesis fr = fluidMap.get(this.water.getActualFluid());
        if (fr == null) {
            return null;
        }
        if (!ReikaItemHelper.matchStacks((ItemStack)this.inv[1], (Object)fr.itemA)) {
            return null;
        }
        if (!ReikaItemHelper.matchStacks((ItemStack)this.inv[2], (Object)fr.itemB)) {
            return null;
        }
        return fr;
    }

    public void updateTemperature(World world, int x, int y, int z, int meta) {
        ForgeDirection lavaside;
        ForgeDirection fireside;
        ForgeDirection iceside;
        int Tamb = ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z);
        ForgeDirection waterside = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151586_h);
        if (waterside != null) {
            Tamb /= 2;
        }
        if ((iceside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
            if (Tamb > 0) {
                Tamb /= 4;
            }
            ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)iceside, (Block)Blocks.field_150358_i, (int)0);
        }
        if ((fireside = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150480_ab)) != null) {
            Tamb += 200;
        }
        if ((lavaside = ReikaWorldHelper.checkForAdjMaterial((World)world, (int)x, (int)y, (int)z, (Material)Material.field_151587_i)) != null) {
            Tamb += 600;
        }
        if (this.temperature > Tamb) {
            --this.temperature;
        }
        if (this.temperature > Tamb * 2) {
            --this.temperature;
        }
        if (this.temperature < Tamb) {
            ++this.temperature;
        }
        if (this.temperature * 2 < Tamb) {
            ++this.temperature;
        }
        if (this.temperature > 1000) {
            this.temperature = 1000;
        }
        if (this.temperature > 100) {
            ForgeDirection side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150433_aE);
            if (side != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150350_a, (int)0);
            }
            if ((side = ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150432_aD)) != null) {
                ReikaWorldHelper.changeAdjBlock((World)world, (int)x, (int)y, (int)z, (ForgeDirection)side, (Block)Blocks.field_150358_i, (int)0);
            }
        }
    }

    private void make() {
        if (this.recipe.itemA != null) {
            ReikaInventoryHelper.decrStack((int)1, (ItemStack[])this.inv);
        }
        if (this.recipe.itemB != null) {
            ReikaInventoryHelper.decrStack((int)2, (ItemStack[])this.inv);
        }
        this.water.removeLiquid(this.recipe.fluidConsumed);
        this.tank.addLiquid(this.recipe.fluidProduced, this.recipe.output);
    }

    public int getWaterScaled(int px) {
        return this.water.getLevel() * px / this.water.getCapacity();
    }

    public int getAmmoniaScaled(int px) {
        return this.tank.getLevel() * px / this.tank.getCapacity();
    }

    public int getTimerScaled(int px) {
        return this.steptimer.getTick() * px / this.steptimer.getCap();
    }

    private void getWaterBuckets() {
        if (this.inv[0] != null && this.inv[0].field_77994_a == 1 && this.inv[0].func_77973_b() == Items.field_151131_as && this.water.canTakeIn(FluidRegistry.WATER, 1000)) {
            this.water.addLiquid(1000, FluidRegistry.WATER);
            this.inv[0] = new ItemStack(Items.field_151133_ar);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.canDrain(from, null) ? this.tank.drain(maxDrain, doDrain) : null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.water.fill(resource, doFill);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluidMap.get(fluid) != null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.water.getInfo(), this.tank.getInfo()};
    }

    @Override
    public boolean canRemoveItem(int i, ItemStack itemstack) {
        return itemstack.func_77973_b() == Items.field_151133_ar;
    }

    public int func_70302_i_() {
        return 3;
    }

    public boolean func_94041_b(int i, ItemStack is) {
        if (i == 0) {
            return is.func_77973_b() == Items.field_151131_as;
        }
        for (FluidSynthesis rec : FluidSynthesis.values()) {
            if (rec.itemA != null && rec.itemA.match(is)) {
                return i == 1;
            }
            if (rec.itemB == null || !rec.itemB.match(is)) continue;
            return i == 2;
        }
        return false;
    }

    public String getInputFluid() {
        return this.water.isEmpty() ? null : this.water.getActualFluid().getLocalizedName();
    }

    public String getOutputFluid() {
        return this.tank.isEmpty() ? null : this.tank.getActualFluid().getLocalizedName();
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.timer = NBT.func_74762_e("time");
        this.water.readFromNBT(NBT);
        this.tank.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("time", this.timer);
        this.water.writeToNBT(NBT);
        this.tank.writeToNBT(NBT);
    }

    public int getTemperature() {
        return this.temperature;
    }

    public void setTemperature(int T) {
        this.temperature = T;
    }

    public void addTemperature(int T) {
        this.temperature += T;
    }

    public int getMaxTemperature() {
        return 1000;
    }

    public void onOverheat(World world, int x, int y, int z) {
    }

    public boolean canBeFrictionHeated() {
        return true;
    }

    public boolean addWater(int amt) {
        if (this.water.canTakeIn(amt)) {
            this.water.addLiquid(amt, FluidRegistry.WATER);
            return true;
        }
        return false;
    }

    @Override
    public boolean canItemEnterFromSide(ForgeDirection dir) {
        return true;
    }

    @Override
    public boolean canItemExitToSide(ForgeDirection dir) {
        return true;
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe() || m == MachineRegistry.FUELLINE;
    }

    public boolean canConnectToPipeOnSide(MachineRegistry m, ForgeDirection side) {
        return this.canConnectToPipe(m);
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side.offsetY == 0 ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.OUTPUT;
    }

    public float getMultiplier() {
        return 1.0f;
    }

    public void resetAmbientTemperatureTimer() {
        this.tempTimer.reset();
    }

    public boolean hasWork() {
        return this.recipe != null && this.tank.canTakeIn(this.recipe.output, this.recipe.fluidProduced);
    }

    public static enum FluidSynthesis {
        AMMONIA(FluidRegistry.WATER, ReactorCraft.NH3, 250, 1000, 220, 50, 0, FluidSynthesis.constructItemMatch("dustQuicklime", ReactorStacks.lime, 1), FluidSynthesis.constructItemMatch("dustAmmonium", ReactorStacks.ammonium, 1)),
        HOTLIFBE(ReactorCraft.LIFBe_fuel, ReactorCraft.LIFBe_fuel_preheat, 50, 50, 350, 100, 5);

        public final Fluid input;
        public final Fluid output;
        public final int fluidConsumed;
        public final int fluidProduced;
        public final int minTemp;
        public final int baseDuration;
        private final int temperatureSpeedCurve;
        private final FlexibleIngredient itemA;
        private final FlexibleIngredient itemB;

        private FluidSynthesis(Fluid in, Fluid out, int amtin, int amtout, int temp, int time, int tc) {
            this(in, out, amtin, amtout, temp, time, tc, null);
        }

        private FluidSynthesis(Fluid in, Fluid out, int amtin, int amtout, int temp, int time, int tc, FlexibleIngredient is) {
            this(in, out, amtin, amtout, temp, time, tc, is, null);
        }

        private FluidSynthesis(Fluid in, Fluid out, int amtin, int amtout, int temp, int time, int tc, FlexibleIngredient a, FlexibleIngredient b) {
            this.input = in;
            this.output = out;
            this.fluidConsumed = amtin;
            this.fluidProduced = amtout;
            this.minTemp = temp;
            this.baseDuration = time;
            this.temperatureSpeedCurve = tc;
            this.itemA = a;
            this.itemB = b;
            if (fluidMap.containsKey(this.input)) {
                throw new IllegalArgumentException("Fluid " + this.input.getName() + " already mapped to a recipe!");
            }
            fluidMap.put(this.input, this);
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack getAForDisplay() {
            return this.itemA != null ? this.itemA.getItemForDisplay(true) : null;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack getBForDisplay() {
            return this.itemB != null ? this.itemB.getItemForDisplay(true) : null;
        }

        public boolean usesItem(ItemStack item) {
            return this.itemA != null && this.itemA.match(item) || this.itemB != null && this.itemB.match(item);
        }

        private static FlexibleIngredient constructItemMatch(ItemStack is) {
            return new FlexibleIngredient(is, 100.0f, is.field_77994_a);
        }

        private static FlexibleIngredient constructItemMatch(String ore, int amt) {
            return FluidSynthesis.constructItemMatch(ore, null, amt);
        }

        private static FlexibleIngredient constructItemMatch(String ore, ItemStack is, int amt) {
            FlexibleIngredient ret = new FlexibleIngredient(ore, 100.0f, amt);
            if (is != null) {
                ret.addItem(is);
            }
            return ret;
        }

        public int getDuration(int temperature) {
            return Math.max(5, this.baseDuration - this.temperatureSpeedCurve * (temperature - this.minTemp) / 100);
        }
    }
}

