/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Processing;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.ParallelTicker;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2Handler;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.Auxiliary.ReactorStacks;
import Reika.ReactorCraft.Base.TileEntityInventoriedReactorBase;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorItems;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import buildcraft.api.tiles.IHasWork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

@APIStripper.Strippable(value={"buildcraft.api.tiles.IHasWork"})
public class TileEntityUProcessor
extends TileEntityInventoriedReactorBase
implements IFluidHandler,
PipeConnector,
IHasWork {
    private final HybridTank output = new HybridTank("uprocout", 3000);
    private final HybridTank intermediate = new HybridTank("uprocmid", 3000);
    private final HybridTank input = new HybridTank("uprocin", 3000);
    public int intermediate_timer;
    public int output_timer;
    private ForgeDirection facing;
    private ParallelTicker timer = new ParallelTicker().addTicker("intermediate", 0).addTicker("output", 0);

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.PROCESSOR;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.getFacing(meta);
        this.getFluidContainers();
        Processes p = this.getProcess();
        if (p == null) {
            return;
        }
        this.timer.setCap("intermediate", p.intermediateTime);
        this.timer.setCap("output", p.ouputTime);
        if (p.hasIntermediate() && this.canRunIntermediate(p)) {
            this.timer.updateTicker("intermediate");
            if (this.timer.checkCap("intermediate")) {
                this.runIntermediate(p);
            }
        } else {
            this.timer.resetTicker("intermediate");
        }
        if (this.canRunOutput(p)) {
            this.timer.updateTicker("output");
            if (this.timer.checkCap("output")) {
                this.runOutput(p);
            }
        } else {
            this.timer.resetTicker("output");
        }
        if (!world.field_72995_K) {
            this.intermediate_timer = this.timer.getTickOf("intermediate");
            this.output_timer = this.timer.getTickOf("output");
        }
    }

    private Processes getProcess() {
        Fluid f = this.input.getActualFluid();
        if (f == null) {
            return null;
        }
        Processes p = (Processes)((Object)Processes.processMap.get(f.getName()));
        if (p == null) {
            return null;
        }
        if (!p.hasIntermediate() || !this.hasFluorite()) {
            // empty if block
        }
        if (!this.hasInputItem(p)) {
            // empty if block
        }
        return p;
    }

    public boolean canRunOutput(Processes p) {
        return this.hasInputItem(p) && (!p.hasIntermediate() || this.getIntermediate() >= p.intermediateFluidConsumed) && this.canAcceptMoreOutput(p.outputFluidProduced);
    }

    private boolean hasInputItem(Processes p) {
        if (this.inv[2] == null) {
            return false;
        }
        return p.isValidItem(this.inv[2]);
    }

    private boolean hasFluorite() {
        if (this.inv[0] == null) {
            return false;
        }
        return this.isFluorite(this.inv[0]);
    }

    private boolean isFluorite(ItemStack is) {
        return ReactorItems.FLUORITE.matchWith(is) || ReikaItemHelper.isInOreTag((ItemStack)is, (String)"gemFluorite");
    }

    public boolean canRunIntermediate(Processes p) {
        return this.getInput() > 0 && this.canAcceptMoreIntermediate(p.intermediateFluidProduced) && this.hasFluorite();
    }

    private void runIntermediate(Processes p) {
        ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
        this.addIntermediate(p.intermediateFluidProduced, p.intermediateFluid);
        this.input.drain(p.inputFluidConsumed, true);
    }

    private void runOutput(Processes p) {
        ReikaInventoryHelper.decrStack((int)2, (ItemStack[])this.inv);
        if (!p.hasIntermediate()) {
            ReikaInventoryHelper.decrStack((int)0, (ItemStack[])this.inv);
            this.input.drain(p.inputFluidConsumed, true);
        }
        this.output.fill(new FluidStack(p.outputFluid, p.outputFluidProduced), true);
        this.intermediate.drain(p.intermediateFluidConsumed, true);
        if (p == Processes.UF6) {
            ReactorAchievements.UF6.triggerAchievement(this.getPlacer());
        }
    }

    public int getIntermediateTimerScaled(int p) {
        return (int)((float)p * this.timer.getPortionOfCap("intermediate"));
    }

    public int getOutputTimerScaled(int p) {
        return (int)((float)p * this.timer.getPortionOfCap("output"));
    }

    public int getInputScaled(int p) {
        return p * this.getInput() / this.input.getCapacity();
    }

    public int getIntermediateScaled(int p) {
        return p * this.getIntermediate() / this.intermediate.getCapacity();
    }

    public int getOutputScaled(int p) {
        return p * this.getOutput() / this.output.getCapacity();
    }

    public int getCapacity() {
        return this.input.getCapacity();
    }

    public int getInput() {
        return this.input.getLevel();
    }

    public int getIntermediate() {
        return this.intermediate.getLevel();
    }

    public int getOutput() {
        return this.output.getLevel();
    }

    public Fluid getInputFluid() {
        return this.input.getActualFluid();
    }

    public Fluid getIntermediateFluid() {
        return this.intermediate.getActualFluid();
    }

    public Fluid getOutputFluid() {
        return this.output.getActualFluid();
    }

    private void getFluidContainers() {
        FluidStack fs;
        if (this.inv[1] != null && (fs = ReikaFluidHelper.getFluidForItem((ItemStack)this.inv[1])) != null && Processes.processMap.get(fs.getFluid().getName()) != null && this.canAcceptMoreInput(fs.amount)) {
            this.input.fill(fs.copy(), true);
            this.inv[1] = FluidContainerRegistry.drainFluidContainer((ItemStack)this.inv[1]);
        }
    }

    public boolean canAcceptMoreInput(int amt) {
        return this.input.getFluid() == null || this.input.getFluid().amount + amt <= this.input.getCapacity();
    }

    public boolean canAcceptMoreIntermediate(int amt) {
        return this.intermediate.getFluid() == null || this.intermediate.getFluid().amount + amt <= this.intermediate.getCapacity();
    }

    public boolean canAcceptMoreOutput(int amt) {
        return this.output.getFluid() == null || this.output.getFluid().amount + amt <= this.output.getCapacity();
    }

    @Override
    public boolean canRemoveItem(int i, ItemStack itemstack) {
        return false;
    }

    public int func_70302_i_() {
        return 3;
    }

    public boolean func_94041_b(int i, ItemStack is) {
        switch (i) {
            case 0: {
                return this.isFluorite(is);
            }
            case 1: {
                return TileEntityUProcessor.getProcessByFluidItem(is) != null;
            }
            case 2: {
                return TileEntityUProcessor.getProcessByMainItem(is) != null;
            }
        }
        return false;
    }

    public static Processes getProcessByMainItem(ItemStack is) {
        for (int i = 0; i < Processes.list.length; ++i) {
            Processes p = Processes.list[i];
            if (!p.isValidItem(is)) continue;
            return p;
        }
        return null;
    }

    public static Processes getProcessByFluidItem(ItemStack is) {
        FluidStack fs = ReikaFluidHelper.getFluidForItem((ItemStack)is);
        if (fs == null) {
            return null;
        }
        return (Processes)((Object)Processes.processMap.get(fs.getFluid().getName()));
    }

    public static Processes getProcessByFluidOutputItem(ItemStack is) {
        FluidStack fs = ReikaFluidHelper.getFluidForItem((ItemStack)is);
        if (fs == null) {
            return null;
        }
        return (Processes)((Object)Processes.processOutputMap.get(fs.getFluid().getName()));
    }

    public static Processes getProcessByInput(Fluid f) {
        return (Processes)((Object)Processes.processMap.get(f.getName()));
    }

    public static Processes getProcessByOutput(Fluid f) {
        return (Processes)((Object)Processes.processOutputMap.get(f.getName()));
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        return this.input.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.output.drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.output.drain(resource.amount, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        for (int i = 0; i < Processes.list.length; ++i) {
            if (Processes.list[i].inputFluid.equals(fluid)) {
                return true;
            }
            if (Processes.list[i].intermediateFluid == null || !Processes.list[i].intermediateFluid.equals(fluid)) continue;
            return true;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        for (int i = 0; i < Processes.list.length; ++i) {
            if (!Processes.list[i].outputFluid.equals(fluid)) continue;
            return true;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.input.getInfo(), this.intermediate.getInfo(), this.output.getInfo()};
    }

    public void addIntermediate(int amt, Fluid f) {
        int a = this.intermediate.fill(new FluidStack(f, amt), true);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.output_timer = NBT.func_74762_e("uf6");
        this.intermediate_timer = NBT.func_74762_e("hf");
        this.input.readFromNBT(NBT);
        this.intermediate.readFromNBT(NBT);
        this.output.readFromNBT(NBT);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("uf6", this.output_timer);
        NBT.func_74768_a("hf", this.intermediate_timer);
        this.input.writeToNBT(NBT);
        this.intermediate.writeToNBT(NBT);
        this.output.writeToNBT(NBT);
    }

    @Override
    public boolean canItemEnterFromSide(ForgeDirection dir) {
        return true;
    }

    @Override
    public boolean canItemExitToSide(ForgeDirection dir) {
        return false;
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p);
    }

    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == this.facing ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.INPUT;
    }

    private void getFacing(int meta) {
        switch (meta) {
            case 0: {
                this.facing = ForgeDirection.WEST;
                break;
            }
            case 1: {
                this.facing = ForgeDirection.EAST;
                break;
            }
            case 2: {
                this.facing = ForgeDirection.NORTH;
                break;
            }
            case 3: {
                this.facing = ForgeDirection.SOUTH;
            }
        }
    }

    public boolean hasWork() {
        Processes p = this.getProcess();
        return p != null && this.output.canTakeIn(p.outputFluid, p.outputFluidProduced);
    }

    public static enum Processes {
        UF6("water", "rc hydrofluoric acid", "rc uranium hexafluoride", 250, 1000, 250, 125, 80, 400, "ingotUranium"),
        LiFBe("rc lithium", "rc hydrofluoric acid", "rc lifbe", 100, 500, 250, 1500, 120, 600, ReactorStacks.emeralddust);

        public final int intermediateTime;
        public final int ouputTime;
        public final Fluid inputFluid;
        public final Fluid intermediateFluid;
        public final Fluid outputFluid;
        public final int inputFluidConsumed;
        public final int outputFluidProduced;
        public final int intermediateFluidProduced;
        public final int intermediateFluidConsumed;
        private final HashSet<KeyedItemStack> inputItem = new HashSet();
        private static final HashMap<String, Processes> processMap;
        private static final HashMap<String, Processes> processOutputMap;
        public static final Processes[] list;

        private Processes(String f, String f1, String f2, int incons, int outprod, int prod, int cons, int t1, int t2, String in) {
            this(f, f1, f2, incons, outprod, prod, cons, t1, t2, new ArrayList<ItemStack>(OreDictionary.getOres((String)in)));
        }

        private Processes(String f, String f1, String f2, int incons, int outprod, int prod, int cons, int t1, int t2, ItemStack in) {
            this(f, f1, f2, incons, outprod, prod, cons, t1, t2, ReikaJavaLibrary.makeListFrom((Object)in));
        }

        private Processes(String f, String f1, String f2, int incons, int outprod, int prod, int cons, int t1, int t2, Collection<ItemStack> in) {
            ItemStack is;
            this.inputFluid = FluidRegistry.getFluid((String)f);
            this.intermediateFluid = FluidRegistry.getFluid((String)f1);
            this.outputFluid = FluidRegistry.getFluid((String)f2);
            this.intermediateTime = t1;
            this.ouputTime = t2;
            this.inputFluidConsumed = incons;
            this.outputFluidProduced = outprod;
            this.intermediateFluidProduced = prod;
            this.intermediateFluidConsumed = cons;
            if (f2.equals("rc uranium hexafluoride") && ModList.IC2.isLoaded() && (is = IC2Handler.IC2Stacks.PURECRUSHEDU.getItem()) != null) {
                in.add(is);
            }
            for (ItemStack is2 : in) {
                this.inputItem.add(new KeyedItemStack(is2).setSimpleHash(true));
            }
        }

        public boolean hasIntermediate() {
            return this.intermediateFluid != null && this.intermediateFluidProduced > 0;
        }

        public boolean isValidItem(ItemStack is) {
            return this.inputItem.contains(new KeyedItemStack(is).setSimpleHash(true));
        }

        public List<ItemStack> getInputItemList() {
            ArrayList<ItemStack> li = new ArrayList<ItemStack>();
            for (KeyedItemStack ks : this.inputItem) {
                li.add(ks.getItemStack());
            }
            return li;
        }

        static {
            processMap = new HashMap();
            processOutputMap = new HashMap();
            list = Processes.values();
            for (int i = 0; i < list.length; ++i) {
                Processes p = list[i];
                processMap.put(p.inputFluid.getName(), p);
                processOutputMap.put(p.outputFluid.getName(), p);
            }
        }
    }
}

