/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities;

import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.ReactorCraft.Auxiliary.SteamTile;
import Reika.ReactorCraft.Base.TileEntityTankedReactorMachine;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntitySteamLine;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.MachineRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntitySteamDiffuser
extends TileEntityTankedReactorMachine
implements SteamTile {
    public static final int RATIO = TileEntitySteamDiffuser.calculateConversionRatio();
    private int steam;

    private static int calculateConversionRatio() {
        double nuReact = 0.01272;
        double nuSATP = 1.696;
        double efficiency = 0.6;
        return (int)Math.ceil(nuSATP / nuReact * efficiency);
    }

    public ForgeDirection getFacing() {
        switch (this.func_145832_p()) {
            case 0: {
                return ForgeDirection.WEST;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public ReactorTiles getTile() {
        return ReactorTiles.DIFFUSER;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.getSteam(world, x, y, z);
        this.convertSteam();
    }

    private void convertSteam() {
        Fluid f;
        if (this.steam > 0 && (f = FluidRegistry.getFluid((String)"steam")) != null) {
            int amt = Math.min(1 + this.steam / 4, this.tank.getRemainingSpace() / RATIO);
            this.tank.addLiquid(amt * RATIO * 1000, f);
            this.steam -= amt;
        }
    }

    private void getSteam(World world, int x, int y, int z) {
        TileEntitySteamLine te;
        int ds;
        ForgeDirection dir = this.getFacing();
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        ReactorTiles rt = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
        if (rt == ReactorTiles.STEAMLINE && (ds = (te = (TileEntitySteamLine)world.func_147438_o(dx, dy, dz)).getSteam() - this.steam) > 0) {
            int rm = ds / 4 + 1;
            this.steam = (int)((float)this.steam + (float)rm * te.getWorkingFluid().efficiency);
            te.removeSteam(rm);
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.steam = NBT.func_74762_e("energy");
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("energy", this.steam);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.canDrain(from, resource.getFluid()) ? this.tank.drain(resource.amount, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.canDrain(from, null) ? this.tank.drain(maxDrain, doDrain) : null;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from == this.getFacing().getOpposite() && ReikaFluidHelper.isFluidDrainableFromTank((Fluid)fluid, (HybridTank)this.tank);
    }

    public boolean canConnectToPipe(MachineRegistry m) {
        return m.isStandardPipe();
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p) && side == this.getFacing().getOpposite();
    }

    @Override
    public int getCapacity() {
        return 2500000;
    }

    @Override
    public boolean canReceiveFrom(ForgeDirection from) {
        return false;
    }

    @Override
    public Fluid getInputFluid() {
        return null;
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == this.getFacing().getOpposite() ? TileEntityPiping.Flow.OUTPUT : TileEntityPiping.Flow.NONE;
    }

    @Override
    public int getSteam() {
        return this.steam;
    }
}

