/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.Image;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.drawable.DrawableBuilder;
import codechicken.nei.recipe.GuiOverlayButton;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeButton;
import codechicken.nei.recipe.RecipeHandlerRef;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.nei.NEECraftingPreviewHandler;
import com.github.vfyjxf.nee.utils.Ingredient;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;

public class NEETerminalOverlayButton
extends GuiOverlayButton {
    public NEETerminalOverlayButton(GuiContainer firstGui, RecipeHandlerRef handlerRef, int xPosition, int yPosition) {
        super(firstGui, handlerRef, xPosition, yPosition);
        if (NEEConfig.noShift) {
            this.setRequireShiftForOverlayRecipe(false);
        }
    }

    public NEETerminalOverlayButton(GuiOverlayButton button) {
        this(button.firstGui, button.handlerRef, button.field_146128_h, button.field_146129_i);
    }

    public void func_146118_a(int mousex, int mousey) {
        if (this.firstGui != null && !NEECraftingPreviewHandler.instance.handle(this.firstGui, this.handlerRef.handler, this.handlerRef.recipeIndex)) {
            super.func_146118_a(mousex, mousey);
        }
    }

    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        hotkeys = super.handleHotkeys(gui, mousex, mousey, hotkeys);
        if (this.ingredientsOverlay().stream().allMatch(state -> {
            NEEItemOverlayState overlayState;
            return state.isPresent() || state instanceof NEEItemOverlayState && NEETerminalOverlayButton.showCraftingHotkeys(overlayState = (NEEItemOverlayState)((Object)state));
        })) {
            if (NEECraftingPreviewHandler.instance.canCraftRecipeResult(gui, this.handlerRef.handler, this.handlerRef.recipeIndex)) {
                hotkeys.put(NEIClientConfig.getKeyName((String)"nee.preview", (int)0, (int)0), I18n.func_135052_a((String)"neenergistics.gui.tooltip.crafting.preview.result", (Object[])new Object[0]));
                hotkeys.put(NEIClientConfig.getKeyName((String)"nee.nopreview", (int)0, (int)0), I18n.func_135052_a((String)"neenergistics.gui.tooltip.crafting.nopreview.result", (Object[])new Object[0]));
            } else {
                hotkeys.put(NEIClientConfig.getKeyName((String)"nee.preview", (int)0, (int)0), I18n.func_135052_a((String)"neenergistics.gui.tooltip.crafting.preview", (Object[])new Object[0]));
                hotkeys.put(NEIClientConfig.getKeyName((String)"nee.nopreview", (int)0, (int)0), I18n.func_135052_a((String)"neenergistics.gui.tooltip.crafting.nopreview", (Object[])new Object[0]));
            }
        }
        return hotkeys;
    }

    private static boolean showCraftingHotkeys(NEEItemOverlayState button) {
        return button.getIngredient().isCraftable() || !button.getIngredient().requiresToCraft();
    }

    public static void updateRecipeButtons(GuiRecipe<?> guiRecipe, List<GuiRecipeButton> buttonList) {
        for (int i = 0; i < buttonList.size(); ++i) {
            GuiRecipeButton guiRecipeButton = buttonList.get(i);
            if (!(guiRecipeButton instanceof GuiOverlayButton)) continue;
            GuiOverlayButton btn = (GuiOverlayButton)guiRecipeButton;
            buttonList.set(i, (GuiRecipeButton)new NEETerminalOverlayButton(btn));
        }
    }

    public static class NEEItemOverlayState
    extends GuiOverlayButton.ItemOverlayState {
        private static final Image crossIcon = new DrawableBuilder("neenergistics:textures/gui/states.png", 16, 36, 8, 8).build();
        private static final Image checkIcon = new DrawableBuilder("neenergistics:textures/gui/states.png", 24, 36, 8, 8).build();
        protected Ingredient ingredient;
        protected boolean isCraftingTerm = true;

        public NEEItemOverlayState(Ingredient ingredient, boolean isCraftingTerm) {
            super(ingredient.getIngredient(), !ingredient.requiresToCraft());
            this.ingredient = ingredient;
            this.isCraftingTerm = isCraftingTerm;
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        public boolean isCraftingTerm() {
            return this.isCraftingTerm;
        }

        public void setIsCraftingTerm(boolean isCraftingTerm) {
            this.isCraftingTerm = isCraftingTerm;
        }

        public void draw(GuiOverlayButton.ItemOverlayFormat format) {
            boolean doCraftingHelp;
            boolean bl = doCraftingHelp = NEIClientConfig.isKeyHashDown((String)"nee.nopreview") || NEIClientConfig.isKeyHashDown((String)"nee.preview");
            if (this.ingredient.isCraftable() && (!this.isCraftingTerm || doCraftingHelp && this.ingredient.requiresToCraft())) {
                Image icon;
                Image image = icon = this.isPresent ? checkIcon : crossIcon;
                if (format == GuiOverlayButton.ItemOverlayFormat.BACKGROUND) {
                    GL11.glPushAttrib((int)1048575);
                    GL11.glDisable((int)2896);
                    GL11.glDisable((int)2929);
                    GuiDraw.drawRect((int)this.slot.relx, (int)this.slot.rely, (int)16, (int)16, (int)0x660000AA);
                    GL11.glPopAttrib();
                } else {
                    LayoutManager.drawIcon((int)(this.slot.relx + 16 - icon.width), (int)(this.slot.rely + 16 - icon.height), (Image)icon);
                }
            } else {
                super.draw(format);
            }
        }
    }
}

