/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM.Patchers.Fixes;

import Reika.DragonAPI.ASM.Patchers.Patcher;
import Reika.DragonAPI.Extras.ReplacementSmeltingHandler;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FurnaceRecipeRewrite
extends Patcher {
    private final HashMap<String, String> redirects = new HashMap();

    public FurnaceRecipeRewrite() {
        super("net.minecraft.item.crafting.FurnaceRecipes", "afa");
        this.redirects.put("getSmeltingResult", "getResult");
        this.redirects.put("func_151395_a", "getResult");
        this.redirects.put("getSmeltingList", "getList");
        this.redirects.put("func_77599_b", "getList");
        this.redirects.put("func_151398_b", "getSmeltingXPByOutput");
    }

    @Override
    protected void apply(ClassNode cn) {
        ArrayList c = new ArrayList(cn.methods);
        for (MethodNode m : c) {
            if (m.name.equals("<init>")) {
                AbstractInsnNode ain = ReikaASMHelper.getLastOpcode(m.instructions, 182);
                m.instructions.insert(ain, (AbstractInsnNode)new MethodInsnNode(184, "Reika/DragonAPI/Extras/ReplacementSmeltingHandler", "onSmeltingInit", "(Lnet/minecraft/item/crafting/FurnaceRecipes;)V", false));
                m.instructions.insert(ain, (AbstractInsnNode)new VarInsnNode(25, 0));
                continue;
            }
            if (m.name.equals("func_151394_a")) {
                String orig = m.name;
                m.name = orig + "_redirect";
                LabelNode L1 = new LabelNode();
                LabelNode L2 = new LabelNode();
                InsnList li = new InsnList();
                li.add((AbstractInsnNode)new VarInsnNode(25, 1));
                li.add((AbstractInsnNode)new VarInsnNode(25, 2));
                li.add((AbstractInsnNode)new VarInsnNode(23, 3));
                li.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/DragonAPI/Extras/ReplacementSmeltingHandler", "checkRecipe", "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;F)Z", false));
                li.add((AbstractInsnNode)new JumpInsnNode(153, L1));
                li.add((AbstractInsnNode)L2);
                li.add((AbstractInsnNode)new VarInsnNode(25, 0));
                li.add((AbstractInsnNode)new VarInsnNode(25, 1));
                li.add((AbstractInsnNode)new VarInsnNode(25, 2));
                li.add((AbstractInsnNode)new VarInsnNode(23, 3));
                li.add((AbstractInsnNode)new MethodInsnNode(182, cn.name, m.name, "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/item/ItemStack;F)V", false));
                li.add((AbstractInsnNode)L1);
                li.add((AbstractInsnNode)new FrameNode(3, 0, new Object[0], 0, new Object[0]));
                li.add((AbstractInsnNode)new InsnNode(177));
                ReikaASMHelper.addMethod(cn, li, orig, m.desc, m.access);
                continue;
            }
            String redirect = this.redirects.get(m.name);
            if (redirect == null) continue;
            String orig = m.name;
            m.name = orig + "_redirect";
            InsnList args = new InsnList();
            int i = 1;
            for (String s : ReikaASMHelper.parseMethodArguments(m)) {
                args.add((AbstractInsnNode)new VarInsnNode(ReikaASMHelper.PrimitiveType.getFromSig((String)s).loadCode, i));
                ++i;
            }
            LabelNode L1 = new LabelNode();
            LabelNode L2 = new LabelNode();
            InsnList li = new InsnList();
            li.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/DragonAPI/Extras/ReplacementSmeltingHandler", "isCompiled", "()Z", false));
            li.add((AbstractInsnNode)new JumpInsnNode(153, L1));
            li.add(ReikaASMHelper.copyInsnList(args, new LabelNode[0]));
            li.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/DragonAPI/Extras/ReplacementSmeltingHandler", redirect, m.desc, false));
            li.add((AbstractInsnNode)new JumpInsnNode(167, L2));
            li.add((AbstractInsnNode)L1);
            li.add((AbstractInsnNode)new FrameNode(3, 0, new Object[0], 0, new Object[0]));
            li.add((AbstractInsnNode)new VarInsnNode(25, 0));
            li.add(ReikaASMHelper.copyInsnList(args, new LabelNode[0]));
            li.add((AbstractInsnNode)new MethodInsnNode(182, cn.name, m.name, m.desc, false));
            li.add((AbstractInsnNode)L2);
            String frame = ReikaASMHelper.convertLPrefixToPlain(ReikaASMHelper.getMethodReturnType(m));
            if (frame.equals("F")) {
                frame = "float";
            }
            li.add((AbstractInsnNode)new FrameNode(4, 0, new Object[0], 1, new Object[]{frame}));
            li.add((AbstractInsnNode)new InsnNode(ReikaASMHelper.getOpcodeForMethodReturn(m)));
            ReikaASMHelper.addMethod(cn, li, orig, m.desc, m.access);
            ReikaASMHelper.log("Redirecting furnace smelting recipes method '" + orig + "' to DragonAPI replacement '" + redirect + "' (delegating to '" + m.name + "') with signature '" + m.desc + "'");
        }
    }

    @Override
    public boolean computeFrames() {
        return true;
    }

    public void addRecipe(ItemStack in, ItemStack out, float xp) {
        if (ReplacementSmeltingHandler.checkRecipe(in, out, xp)) {
            this.doAddRecipe(in, out, xp);
        }
    }

    public void doAddRecipe(ItemStack in, ItemStack out, float xp) {
    }
}

