/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM.Patchers;

import Reika.DragonAPI.Auxiliary.CoreModDetection;
import Reika.DragonAPI.Exception.ASMException;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import cpw.mods.fml.relauncher.Side;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public abstract class Patcher {
    public final String obfName;
    public final String deobfName;
    public static final boolean genClasses = ReikaJVMParser.isArgumentPresent("-DragonAPI_exportASM");
    private static final HashSet<Patcher> activePatches = new HashSet();

    public Patcher(String s) {
        this(s, s);
    }

    public Patcher(String deobf, String obf) {
        this.deobfName = deobf;
        this.obfName = obf;
        if (this.deobfName.length() < this.obfName.length() && !this.deobfName.contains(".")) {
            throw new MisuseException("Swapped obf and deobf names!");
        }
        if (Strings.isNullOrEmpty((String)obf) || Strings.isNullOrEmpty((String)deobf)) {
            throw new MisuseException("Empty class specification! If you want to disable the patcher, mark it deprecated!");
        }
    }

    public Patcher activate() {
        activePatches.add(this);
        return this;
    }

    public final byte[] apply(byte[] data) {
        Side s = ReikaASMHelper.getSide();
        if (!this.runsOnSide(s)) {
            ReikaASMHelper.log("Skipping " + this + " ASM handler; does not run on side " + s);
            return data;
        }
        for (int i = 0; i < CoreModDetection.list.length; ++i) {
            CoreModDetection c = CoreModDetection.list[i];
            if (!c.isInstalled() || this.runWithCoreMod(c)) continue;
            ReikaASMHelper.log("Skipping " + this + " ASM handler; not compatible with " + (Object)((Object)c));
            return data;
        }
        ClassNode cn = new ClassNode();
        ClassReader classReader = new ClassReader(data);
        classReader.accept((ClassVisitor)cn, 0);
        try {
            this.apply(cn);
        }
        catch (Exception e) {
            ReikaASMHelper.log("ASM handler " + this + " threw " + e + " during application; class bytecode is below");
            ReikaASMHelper.log("\n" + ReikaASMHelper.clearString(cn));
            Throwables.propagate((Throwable)e);
        }
        ReikaASMHelper.log("Successfully applied " + this + " ASM handler!");
        int flags = 1;
        if (this.computeFrames()) {
            flags |= 2;
        }
        ClassWriter writer = new ClassWriter(flags);
        cn.accept((ClassVisitor)writer);
        byte[] newdata = writer.toByteArray();
        if (genClasses) {
            try {
                ReikaASMHelper.writeClassFile(cn, "ASMOutput");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Arrays.equals(data, newdata)) {
            ReikaASMHelper.log("WARNING: ASM handler " + this + " made no changes to the class!");
        }
        return newdata;
    }

    protected final void log(String s) {
        ReikaASMHelper.log(s);
    }

    protected abstract void apply(ClassNode var1);

    public final boolean isEnabled() {
        String key = this.isDisabledByDefault() ? "enable" : "disable";
        String tag = "-DragonAPI_" + key + "_ASM_" + this.name();
        boolean arg = ReikaJVMParser.isArgumentPresent(tag);
        return this.isDisabledByDefault() ? arg : !arg;
    }

    public boolean isDisabledByDefault() {
        return false;
    }

    public final boolean isExceptionThrowing() {
        String tag = "-DragonAPI_silence_ASM_" + this.name();
        return !ReikaJVMParser.isArgumentPresent(tag);
    }

    public final String name() {
        return this.nameKey().toUpperCase(Locale.ENGLISH);
    }

    protected String nameKey() {
        return this.getClass().getSimpleName();
    }

    public final boolean patchesForgeCode() {
        return !this.isObfable() && (this.deobfName.startsWith("net.minecraftforge") || this.deobfName.startsWith("cpw.mods.fml"));
    }

    public final boolean patchesModCode() {
        return !this.isObfable() && !this.patchesForgeCode();
    }

    private final boolean isObfable() {
        return !this.deobfName.equals(this.obfName);
    }

    public boolean runWithCoreMod(CoreModDetection c) {
        return true;
    }

    public boolean runsOnSide(Side s) {
        return true;
    }

    public final String toString() {
        return this.name() + " [" + (this.isObfable() ? this.deobfName + "/" + this.obfName : this.deobfName) + "]";
    }

    public boolean computeFrames() {
        return false;
    }

    public static Collection<Patcher> getActivePatchers() {
        return Collections.unmodifiableCollection(activePatches);
    }

    private class ASMApplicationException
    extends RuntimeException {
        private ASMApplicationException(ASMException e) {
            super(e);
        }
    }
}

