/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ASM;

import Reika.DragonAPI.Exception.ASMException;
import Reika.DragonAPI.Libraries.Java.ReikaASMHelper;
import java.util.HashSet;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.classloading.FMLForgePlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class StructureLootHooks
implements IClassTransformer {
    private final HashSet<String> superClasses = new HashSet();

    public StructureLootHooks() {
        this.superClasses.add("net/minecraft/world/gen/structure/StructureComponent");
        this.superClasses.add("net/minecraft/world/gen/structure/ComponentScatteredFeaturePieces$Feature");
        this.superClasses.add("net/minecraft/world/gen/structure/StructureNetherBridgePieces$Piece");
        this.superClasses.add("net/minecraft/world/gen/structure/StructureStrongholdPieces$Stronghold");
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassNode cn = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)cn, 0);
        if (this.superClasses.contains(cn.name) || this.superClasses.contains(cn.superName)) {
            ReikaASMHelper.activeMod = "DragonAPI";
            try {
                ReikaASMHelper.activeMod = "DragonAPI";
                MethodNode m = ReikaASMHelper.getMethodByName(cn, "func_74879_a", "generateStructureChestContents", "(Lnet/minecraft/world/World;Lnet/minecraft/world/gen/structure/StructureBoundingBox;Ljava/util/Random;III[Lnet/minecraft/util/WeightedRandomChestContent;I)Z");
                MethodInsnNode look = ReikaASMHelper.getFirstMethodCallByName(cn, m, FMLForgePlugin.RUNTIME_DEOBF ? "func_76293_a" : "generateChestContents");
                StructureLootHooks.inject(cn, m, (AbstractInsnNode)look);
                ReikaASMHelper.log("Injected loot hooks into " + cn.name);
                ClassWriter writer = new ClassWriter(1);
                cn.accept((ClassVisitor)writer);
                cn.check(cn.version);
                ReikaASMHelper.activeMod = null;
                return writer.toByteArray();
            }
            catch (ASMException.NoSuchASMMethodException e) {
                ReikaASMHelper.log("Skipping loot hooks on " + cn.name + "; does not contain loot generation method");
                ReikaASMHelper.activeMod = null;
                return bytes;
            }
            catch (ASMException.NoSuchASMMethodInstructionException e) {
                ReikaASMHelper.log("Skipping loot hooks on " + cn.name + "; does not contain call to generate loot");
                ReikaASMHelper.activeMod = null;
                return bytes;
            }
            catch (Exception e) {
                ReikaASMHelper.log("Could not add loot hooks to " + cn.name + ": " + e.toString());
                e.printStackTrace();
                ReikaASMHelper.activeMod = null;
                return bytes;
            }
        }
        return bytes;
    }

    public static void inject(ClassNode cn, MethodNode m, AbstractInsnNode loc) {
        int var = ((VarInsnNode)ReikaASMHelper.getLastOpcodeBefore((InsnList)m.instructions, (int)m.instructions.indexOf((AbstractInsnNode)loc), (int)58)).var;
        InsnList li = new InsnList();
        li.add((AbstractInsnNode)new VarInsnNode(25, 0));
        li.add((AbstractInsnNode)new VarInsnNode(25, var));
        li.add((AbstractInsnNode)new MethodInsnNode(184, "Reika/DragonAPI/Instantiable/Event/ChestLootEvent", "fire", "(Ljava/lang/Object;Lnet/minecraft/inventory/IInventory;)V", false));
        m.instructions.insert(loc, li);
    }
}

