/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import com.google.common.base.Strings;
import java.util.ArrayList;
import net.minecraft.launchwrapper.Launch;

public enum CoreModDetection {
    OPTIFINE("optifine.OptiFineTweaker", "rendering and textures", ""),
    LITELOADER("com.mumfrey.liteloader.core.LiteLoader", "sounds and textures", "Try reloading resources (F3+T) to fix this."),
    FASTCRAFT(Launch.blackboard.get("fcVersion") != null, "render and block changes", ""),
    VIVE("com.mtbs3d.minecrift.api.IRoomscaleAdapter", "rendering and interface", ""),
    COLOREDLIGHTS("coloredlightscore.src.asm.ColoredLightsCoreLoadingPlugin", "rendering", ""),
    BUKKIT("org.bukkit.BanEntry", "low-level patches", "");

    private final Class refClass;
    private final boolean isLoaded;
    private final String warning;
    private final String message;
    public static final CoreModDetection[] list;

    private CoreModDetection(String s, String w, String m) {
        this(ReikaJavaLibrary.getClassNoException(s), w, m);
    }

    private CoreModDetection(Class c, String w, String m) {
        this(c, c != null, w, m);
    }

    private CoreModDetection(boolean flag, String w, String m) {
        this(null, flag, w, m);
    }

    private CoreModDetection(Class c, boolean flag, String w, String m) {
        this.refClass = c;
        this.isLoaded = flag;
        this.warning = w;
        this.message = m;
    }

    public boolean isInstalled() {
        return this.isLoaded;
    }

    public static String getStatus() {
        ArrayList<CoreModDetection> li = new ArrayList<CoreModDetection>();
        for (CoreModDetection cm : list) {
            if (!cm.isInstalled()) continue;
            li.add(cm);
        }
        return li.isEmpty() ? "None" : ((Object)li).toString();
    }

    static {
        list = CoreModDetection.values();
        for (int i = 0; i < CoreModDetection.values().length; ++i) {
            CoreModDetection c = CoreModDetection.values()[i];
            if (c.isInstalled()) {
                ReikaJavaLibrary.pConsole("DRAGONAPI: " + (Object)((Object)c) + " detected. Loading compatibility features.");
                ReikaJavaLibrary.pConsole("\t\tNote that some parts of the game, especially " + c.warning + ", may error out.");
                if (Strings.isNullOrEmpty((String)c.message)) continue;
                ReikaJavaLibrary.pConsole("\t\t" + c.message);
                continue;
            }
            ReikaJavaLibrary.pConsole("DRAGONAPI: " + (Object)((Object)c) + " not detected.");
        }
    }
}

