/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.Trackers.KeyWatcher;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Auxiliary.Trackers.RemoteAssetLoader;
import Reika.DragonAPI.Auxiliary.Trackers.SpecialDayTracker;
import Reika.DragonAPI.Auxiliary.Trackers.TickScheduler;
import Reika.DragonAPI.Auxiliary.Trackers.VersionTransitionTracker;
import Reika.DragonAPI.Command.ClearItemsCommand;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Exception.WTFException;
import Reika.DragonAPI.Extras.ChangePacketRenderer;
import Reika.DragonAPI.Extras.WorldAccessHooks;
import Reika.DragonAPI.IO.DirectResourceManager;
import Reika.DragonAPI.Instantiable.Event.AddRecipeEvent;
import Reika.DragonAPI.Instantiable.Event.Client.ChatEvent;
import Reika.DragonAPI.Instantiable.Event.Client.ClientLoginEvent;
import Reika.DragonAPI.Instantiable.Event.Client.EntityRenderingLoopEvent;
import Reika.DragonAPI.Instantiable.Event.Client.GameFinishedLoadingEvent;
import Reika.DragonAPI.Instantiable.Event.Client.HotbarKeyEvent;
import Reika.DragonAPI.Instantiable.Event.Client.RenderBlockAtPosEvent;
import Reika.DragonAPI.Instantiable.Event.Client.SettingsEvent;
import Reika.DragonAPI.Instantiable.Event.Client.SinglePlayerLogoutEvent;
import Reika.DragonAPI.Instantiable.Event.Client.SkyColorEvent;
import Reika.DragonAPI.Instantiable.Event.Client.SoundAttenuationDistanceEvent;
import Reika.DragonAPI.Instantiable.Event.Client.WinterColorsEvent;
import Reika.DragonAPI.Instantiable.Event.FireChanceEvent;
import Reika.DragonAPI.Instantiable.Event.ItemUpdateEvent;
import Reika.DragonAPI.Instantiable.Event.MobTargetingEvent;
import Reika.DragonAPI.Instantiable.Event.ProfileEvent;
import Reika.DragonAPI.Instantiable.Event.XPUpdateEvent;
import Reika.DragonAPI.Instantiable.IO.EnumSound;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.Interpolation;
import Reika.DragonAPI.Interfaces.Block.Submergeable;
import Reika.DragonAPI.Interfaces.Entity.DestroyOnUnload;
import Reika.DragonAPI.Interfaces.Registry.CustomDistanceSound;
import Reika.DragonAPI.Interfaces.TileEntity.PlayerBreakHook;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEnchantmentHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaFluidHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.ReikaRecipeHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.World.ReikaChunkHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ItemCustomFocus;
import Reika.DragonAPI.ModInteract.DeepInteract.NEIIntercept;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderWorldEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;
import paulscode.sound.SoundSystemConfig;
import thaumcraft.api.wands.ItemFocusBasic;

public class DragonAPIEventWatcher
implements ProfileEvent.ProfileEventWatcher,
RenderBlockAtPosEvent.BlockRenderWatcher {
    public static final DragonAPIEventWatcher instance = new DragonAPIEventWatcher();
    private long IDMsgCooldown = 0L;
    private final Interpolation biomeHumidityFlammability = new Interpolation(false);
    private final HashSet<String> oreDictLogSpamReductionStrings = new HashSet();
    private Item lastOredictedItem;

    private DragonAPIEventWatcher() {
        ProfileEvent.registerHandler("debug", this);
        RenderBlockAtPosEvent.addListener(this);
        this.biomeHumidityFlammability.addPoint(0.0, 3.0);
        this.biomeHumidityFlammability.addPoint(0.1, 2.0);
        this.biomeHumidityFlammability.addPoint(0.25, 1.5);
        this.biomeHumidityFlammability.addPoint(0.4, 1.1);
        this.biomeHumidityFlammability.addPoint(0.5, 1.0);
        this.biomeHumidityFlammability.addPoint(0.8, 0.9);
        this.biomeHumidityFlammability.addPoint(0.9, 0.75);
        this.biomeHumidityFlammability.addPoint(1.0, 0.5);
    }

    @Override
    public void onCall(String tag) {
        if (tag.equals("debug")) {
            this.showF3Extras();
        }
    }

    @SubscribeEvent
    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public void handleFocusLeftClick(PlayerInteractEvent evt) {
        ItemFocusBasic focus;
        ItemStack hold;
        if (evt.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && (hold = evt.entityPlayer.func_71045_bC()) != null && hold.func_77973_b() == ThaumItemHelper.ItemEntry.WAND.getItem().func_77973_b() && (focus = ReikaThaumHelper.getWandFocus(hold)) instanceof ItemCustomFocus && ((ItemCustomFocus)focus).onLeftClick(evt.world, evt.x, evt.y, evt.z, evt.entityPlayer, hold, ForgeDirection.VALID_DIRECTIONS[evt.face])) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void clearScheduledEvents(SinglePlayerLogoutEvent evt) {
        this.clearCaches();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void clearScheduledEvents(FMLNetworkEvent.ClientDisconnectionFromServerEvent evt) {
        this.clearCaches();
    }

    public void clearCaches() {
        ReikaWorldHelper.clearWorldKeyCache();
        TickScheduler.instance.clear();
        if (ModList.MYSTCRAFT.isLoaded()) {
            ReikaMystcraftHelper.clearCache();
        }
    }

    @SubscribeEvent
    public void addWorldHooks(WorldEvent.Load evt) {
        evt.world.func_72954_a((IWorldAccess)new WorldAccessHooks(evt.world));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void soundEnumDistance(SoundAttenuationDistanceEvent evt) {
        if (evt.sound instanceof EnumSound) {
            float dist;
            EnumSound es = (EnumSound)evt.sound;
            if (es.sound instanceof CustomDistanceSound && (dist = ((CustomDistanceSound)es.sound).getAudibleDistance()) > 0.0f) {
                evt.distance = dist;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onBlockTriedRender(Block block, int x, int y, int z, WorldRenderer wr, RenderBlocks rb, int pass) {
        if (block instanceof Submergeable) {
            Submergeable s = (Submergeable)block;
            int meta = rb.field_147845_a.func_72805_g(x, y, z);
            if (s.isSubmergeable(rb.field_147845_a, x, y, z) && s.renderLiquid(meta) && pass == 1) {
                this.renderWaterInBlock(rb.field_147845_a, x, y, z, block, meta, Tessellator.field_78398_a);
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderWaterInBlock(IBlockAccess world, int x, int y, int z, Block block, int meta, Tessellator v5) {
        Block above = world.func_147439_a(x, y + 1, z);
        if (above != Blocks.field_150355_j && above != Blocks.field_150358_i && !ReikaWorldHelper.hasAdjacentWater(world, x, y + 1, z, false, false)) {
            boolean flag = ReikaWorldHelper.hasAdjacentWater(world, x, y, z, false, false);
            if (!flag) {
                for (int i = 2; i < 6 && !flag; ++i) {
                    ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                    int dx = x + dir.offsetX;
                    int dy = y + dir.offsetY;
                    int dz = z + dir.offsetZ;
                    flag = flag || ReikaWorldHelper.hasAdjacentWater(world, dx, dy, dz, false, true);
                }
            }
            if (flag) {
                IIcon ico = Blocks.field_150355_j.func_149673_e(world, x, y, z, 1);
                float u = ico.func_94209_e();
                float v = ico.func_94206_g();
                float du = ico.func_94212_f();
                float dv = ico.func_94210_h();
                RenderBlocks.getInstance().field_147845_a = world;
                double d2 = RenderBlocks.getInstance().func_147729_a(x, y, z, Material.field_151586_h);
                double d3 = world.func_147439_a(x, y, z + 1).func_149688_o() == Material.field_151586_h ? (double)RenderBlocks.getInstance().func_147729_a(x, y, z + 1, Material.field_151586_h) : 0.8875;
                double d4 = world.func_147439_a(x + 1, y, z + 1).func_149688_o() == Material.field_151586_h ? (double)RenderBlocks.getInstance().func_147729_a(x + 1, y, z + 1, Material.field_151586_h) : 0.8875;
                double d5 = world.func_147439_a(x + 1, y, z).func_149688_o() == Material.field_151586_h ? (double)RenderBlocks.getInstance().func_147729_a(x + 1, y, z, Material.field_151586_h) : 0.8875;
                v5.func_78378_d(Blocks.field_150355_j.func_149720_d(world, x, y, z));
                v5.func_78374_a((double)x, (double)y + d3, (double)(z + 1), (double)u, (double)dv);
                v5.func_78374_a((double)(x + 1), (double)y + d4, (double)(z + 1), (double)du, (double)dv);
                v5.func_78374_a((double)(x + 1), (double)y + d5, (double)z, (double)du, (double)v);
                v5.func_78374_a((double)x, (double)y + d2, (double)z, (double)u, (double)v);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void monitorNewWorld(WorldEvent.CreateSpawnPosition ev) {
        DragonAPICore.log("Registering creation of new world " + ev.world + " in " + ev.world.func_72860_G().func_75765_b());
        ReikaWorldHelper.onWorldCreation(ev.world);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void tagDeathDrops(PlayerDropsEvent ev) {
        for (EntityItem ei : ev.drops) {
            ei.getEntityData().func_74778_a("PLAYER_DEATH_DROP", ev.entityPlayer.func_110124_au().toString());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void doCorrectBiomeFoliage(PlayerInteractEvent ev) {
        ItemStack is;
        if (ev.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && DragonOptions.GRASSMEAL.getState() && ReikaItemHelper.matchStacks(is = ev.entityPlayer.func_71045_bC(), ReikaItemHelper.bonemeal) && !ev.world.field_72995_K) {
            BiomeGenBase biome;
            WorldGenerator grass;
            Block b = ev.world.func_147439_a(ev.x, ev.y, ev.z);
            int meta = ev.world.func_72805_g(ev.x, ev.y, ev.z);
            if (b == Blocks.field_150349_c && (grass = (biome = ev.world.func_72807_a(ev.x, ev.z)).func_76730_b(ev.world.field_73012_v)) != null && grass.func_76484_a(ev.world, ev.world.field_73012_v, ev.x, ev.y, ev.z) && !ev.entityPlayer.field_71075_bZ.field_75098_d) {
                --ev.entityPlayer.func_71045_bC().field_77994_a;
            }
        }
    }

    @SubscribeEvent
    public void checkModChanges(WorldEvent.Load evt) {
        VersionTransitionTracker.instance.onWorldLoad(evt.world);
    }

    @SideOnly(value=Side.CLIENT)
    private void showF3Extras() {
        long amt = ReikaTextureHelper.binder.getTotalBytesLoaded();
        String pre = ReikaEngLibrary.getSIPrefix(amt);
        double base = ReikaMathLibrary.getThousandBase(amt);
        String sg = String.format("%.3f %sbytes in texture data", base, pre);
        Minecraft mc = Minecraft.func_71410_x();
        int len = FMLCommonHandler.instance().getBrandings(false).size();
        mc.field_71456_v.func_73731_b(mc.field_71466_p, sg, mc.field_71443_c / ReikaRenderHelper.getGUIScale() - 10 - mc.field_71466_p.func_78256_a(sg), 73 + (len - 4) * (2 + mc.field_71466_p.field_78288_b), 0xFFFFFF);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void xmasFog(EntityViewRenderEvent.FogColors evt) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        float f = SpecialDayTracker.instance.getXmasWeatherStrength((World)world);
        if (f > 0.0f) {
            int c0 = ReikaColorAPI.RGBtoHex((int)(evt.red * 255.0f), (int)(evt.green * 255.0f), (int)(evt.blue * 255.0f));
            int c1 = WinterColorsEvent.getFogColor();
            int c = ReikaColorAPI.mixColors(c1, c0, f *= world.getSunBrightnessBody(ReikaRenderHelper.getPartialTickTime()));
            evt.red = (float)ReikaColorAPI.getRed(c) / 255.0f;
            evt.green = (float)ReikaColorAPI.getGreen(c) / 255.0f;
            evt.blue = (float)ReikaColorAPI.getBlue(c) / 255.0f;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void xmasSky(SkyColorEvent evt) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        float f = SpecialDayTracker.instance.getXmasWeatherStrength((World)world);
        if (f > 0.0f) {
            evt.color = ReikaColorAPI.mixColors(WinterColorsEvent.getSkyColor(), evt.color, f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void forceFramebuffer(SettingsEvent.Save evt) {
        evt.settings.field_151448_g = true;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void forceFramebuffer(SettingsEvent.Load evt) {
        evt.settings.field_151448_g = true;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void collectAll(PlayerInteractEvent evt) {
        TileEntity te;
        KeyWatcher.Key k;
        if (!evt.world.field_72995_K && evt.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && (k = DragonOptions.getCollectKey()) != null && KeyWatcher.instance.isKeyDown(evt.entityPlayer, k) && (te = evt.world.func_147438_o(evt.x, evt.y, evt.z)) instanceof IInventory) {
            boolean flag2 = false;
            ReikaChatHelper.clearChat((EntityPlayerMP)evt.entityPlayer);
            IInventory ii = (IInventory)te;
            for (int i = 0; i < 6; ++i) {
                HashMap<Integer, ItemStack> map = ReikaInventoryHelper.getLocatedTransferrables(ForgeDirection.VALID_DIRECTIONS[i], ii);
                for (int slot : map.keySet()) {
                    boolean flag = true;
                    ItemStack is = map.get(slot);
                    if (evt.entityPlayer.func_70093_af()) {
                        ReikaPlayerAPI.addOrDropItem(is, evt.entityPlayer);
                    } else {
                        flag = ReikaInventoryHelper.addToIInv(is, (IInventory)evt.entityPlayer.field_71071_by);
                    }
                    if (!flag) continue;
                    ii.func_70299_a(slot, null);
                    String s = "Collected " + is.field_77994_a + " " + is.func_82833_r();
                    ReikaPacketHelper.sendStringPacket("DragonAPIData", APIPacketHandler.PacketIDs.STRINGPARTICLE.ordinal(), s, te);
                    flag2 = true;
                }
            }
            if (flag2) {
                ReikaSoundHelper.playSoundAtEntity(evt.world, (Entity)evt.entityPlayer, "random.click", 1.0f, 1.5f);
            }
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void modifyFireSpread(FireChanceEvent evt) {
        if (DragonOptions.BIOMEFIRE.getState()) {
            BiomeGenBase b = evt.getBiome();
            float humid = b.field_76751_G;
            evt.spreadChance = (int)((double)evt.spreadChance * this.biomeHumidityFlammability.getValue(humid));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderUpdateHalos(EntityRenderingLoopEvent evt) {
        if (ChangePacketRenderer.isActive && evt.renderPass == 1) {
            ChangePacketRenderer.instance.render();
        }
    }

    @SubscribeEvent
    public void unloadDestroyableEntities(WorldEvent.Unload evt) {
        for (Entity e : evt.world.field_72996_f) {
            if (!(e instanceof DestroyOnUnload)) continue;
            ((DestroyOnUnload)e).destroy();
        }
    }

    @SubscribeEvent
    public void unloadChunkEntities(ChunkEvent.Unload evt) {
        ReikaChunkHelper.clearUnloadableEntities(evt.getChunk());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fixRespirationFourPlusFog(EntityViewRenderEvent.FogColors evt) {
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        ItemStack helm = ep.func_82169_q(3);
        if (helm != null && ReikaEnchantmentHelper.getEnchantmentLevel(Enchantment.field_77340_h, helm) > 3) {
            if (ep.func_70644_a(Potion.field_76440_q)) {
                evt.blue = 0.0f;
                evt.green = 0.0f;
                evt.red = 0.0f;
            } else if (ep.func_70055_a(Material.field_151586_h)) {
                evt.blue = 1.0f;
                evt.red = 0.6f;
                evt.green = 0.8f;
            } else if (ep.func_70055_a(Material.field_151587_i)) {
                evt.blue = 0.2f;
                evt.red = 1.0f;
                evt.green = 0.6f;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fixRespirationFourPlusFog(EntityViewRenderEvent.FogDensity evt) {
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        ItemStack helm = ep.func_82169_q(3);
        if (helm != null && ReikaEnchantmentHelper.getEnchantmentLevel(Enchantment.field_77340_h, helm) > 3 && (ep.func_70055_a(Material.field_151586_h) || ep.func_70055_a(Material.field_151587_i))) {
            GL11.glFogi((int)2917, (int)2048);
            evt.density = Math.min(evt.density, ep.func_70055_a(Material.field_151587_i) ? 0.1f : 0.0025f);
            if (ep.func_70644_a(Potion.field_76440_q)) {
                evt.density = 0.9f;
            }
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void protectNewPlayers(MobTargetingEvent.Pre evt) {
        if (evt.player.field_70173_aa < 200 && DragonOptions.PROTECTNEW.getState()) {
            evt.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void stillAllowPetTargeting(MobTargetingEvent.Pre evt) {
        if (ReikaEntityHelper.tameMobTargeting) {
            evt.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void trackBrokenBlocks(BlockEvent.BreakEvent evt) {
        TileEntity te = evt.world.func_147438_o(evt.x, evt.y, evt.z);
        if (te instanceof PlayerBreakHook && !((PlayerBreakHook)te).breakByPlayer(evt.getPlayer())) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void catchNullOreDict(OreDictionary.OreRegisterEvent evt) {
        Item i;
        if (evt.Ore == null || evt.Ore.func_77973_b() == null) {
            throw new WTFException("Someone registered null to the OreDictionary under the name '" + evt.Name + "'!", true);
        }
        if (evt.Name == null || evt.Name.isEmpty()) {
            throw new WTFException("Someone registered " + evt.Ore + " under a null or empty OreDict name!", true);
        }
        if (!this.oreDictLogSpamReductionStrings.contains(evt.Name)) {
            DragonAPICore.log("Logged OreDict registration of " + evt.Ore + " as '" + evt.Name + "'.");
            this.oreDictLogSpamReductionStrings.add(evt.Name);
        }
        if ((i = evt.Ore.func_77973_b()) != this.lastOredictedItem) {
            this.oreDictLogSpamReductionStrings.clear();
            this.lastOredictedItem = i;
        }
    }

    @SubscribeEvent
    public void mapFluidContainers(FluidContainerRegistry.FluidContainerRegisterEvent evt) {
        ReikaFluidHelper.initEarlyRegistrations();
        Fluid f = evt.data.fluid.getFluid();
        ItemStack fill = evt.data.filledContainer;
        ItemStack empty = evt.data.emptyContainer;
        StringBuilder sb = new StringBuilder();
        sb.append("Logged FluidContainer registration of ");
        sb.append(f.getName());
        sb.append(" with filled '");
        sb.append(fill != null ? fill.func_82833_r() : "[null]");
        sb.append("' and empty '");
        sb.append(empty != null ? empty.func_82833_r() : "[null]");
        sb.append("'.");
        DragonAPICore.log(sb.toString());
        ReikaFluidHelper.mapContainerToFluid(f, empty, fill);
    }

    @SubscribeEvent
    public void onClose(WorldEvent.Unload evt) {
    }

    @SubscribeEvent
    public void onLoad(WorldEvent.Load evt) {
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void increaseChannels(SoundSetupEvent evt) {
        if (DragonOptions.SOUNDCHANNELS.getState()) {
            SoundSystemConfig.setNumberNormalChannels((int)256);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerLogin(ClientLoginEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_71370_a(mc.field_71443_c, mc.field_71440_d);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGameLoaded(GameFinishedLoadingEvent evt) throws InterruptedException {
        this.checkRemoteAssetDownload();
        Minecraft mc = Minecraft.func_71410_x();
        if (!ReikaObfuscationHelper.isDeObfEnvironment()) {
            DirectResourceManager.getInstance().initToSoundRegistry();
        }
        if (ModList.NEI.isLoaded()) {
            NEIIntercept.instance.register();
        }
        DragonAPIInit.proxy.registerSidedHandlersGameLoaded();
        ReflectiveFailureTracker.instance.print();
        mc.func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation("note.harp"), 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
        Thread.sleep(100L);
        float f = (float)ReikaMusicHelper.MusicKey.Cs5.getRatio(ReikaMusicHelper.MusicKey.Fs4);
        mc.func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation("note.harp"), 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
        mc.func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation("note.harp"), 1.0f, f, 0.0f, 0.0f, 0.0f));
    }

    private void checkRemoteAssetDownload() throws InterruptedException {
        long time = 0L;
        long d = 100L;
        while (!RemoteAssetLoader.instance.isDownloadComplete()) {
            if (time % 5000L == 0L) {
                String p = String.format("%.2f", Float.valueOf(100.0f * RemoteAssetLoader.instance.getDownloadProgress()));
                String s = "Remote asset downloads not yet complete (current = " + p + "%). Pausing game load. Total delay: " + time + " ms.";
                DragonAPICore.log(s);
            }
            Thread.sleep(d);
            time += d;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void stopHotbarSwap(HotbarKeyEvent evt) {
        if (DragonOptions.NOHOTBARSWAP.getState()) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void disableAlphaTest(RenderWorldEvent.Pre evt) {
    }

    @SubscribeEvent
    public void sendInteractToClient(PlayerInteractEvent evt) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !ReikaPlayerAPI.isFake(evt.entityPlayer)) {
            ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.PLAYERINTERACT.ordinal(), (PacketTarget)new PacketTarget.PlayerTarget((EntityPlayerMP)evt.entityPlayer), evt.x, evt.y, evt.z, evt.face, evt.action.ordinal());
        }
    }

    @SubscribeEvent
    public void clearItems(ItemUpdateEvent evt) {
        if (ClearItemsCommand.clearItem(evt.entityItem)) {
            evt.entityItem.func_70106_y();
        }
    }

    @SubscribeEvent
    public void tagDroppedItems(ItemTossEvent evt) {
        if (evt.player != null) {
            ReikaItemHelper.setDropper(evt.entityItem, evt.player);
        }
    }

    @SubscribeEvent
    public void tagDroppedItems(EntityJoinWorldEvent evt) {
        if (evt.entity instanceof EntityItem && evt.world.field_72995_K) {
            ReikaPacketHelper.sendDataPacket("DragonAPIData", APIPacketHandler.PacketIDs.ITEMDROPPERREQUEST.ordinal(), PacketTarget.server, evt.entity.func_145782_y());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void confirmNumericIDs(ChatEvent.ChatEventPost evt) {
        if (System.currentTimeMillis() - this.IDMsgCooldown >= 30000L && evt.chatMessage.startsWith("Warning: Using numeric IDs will not be supported in the future")) {
            String item1 = EnumChatFormatting.GOLD + "/give item.forestry.apiculture.bee.template.root3";
            String item2 = EnumChatFormatting.GOLD + "/give item.gregtech.machine.primary.transformer.hv.ruby";
            String c = EnumChatFormatting.LIGHT_PURPLE.toString();
            ReikaChatHelper.writeString(c + "Numeric IDs will remain functional as long as I am here,");
            ReikaChatHelper.writeString(c + "because not everyone wants to type");
            ReikaChatHelper.writeString(c + "'" + item1 + c + "'");
            ReikaChatHelper.writeString(c + "or");
            ReikaChatHelper.writeString(c + "'" + item2 + c + "'.");
            ReikaChatHelper.writeString(c + "-DragonAPI");
            this.IDMsgCooldown = System.currentTimeMillis();
        }
    }

    @SubscribeEvent
    public void verifyCraftingRecipe(AddRecipeEvent evt) {
        if (!AddRecipeEvent.isVanillaPass) {
            try {
                if (!ReikaRecipeHelper.verifyRecipe(evt.recipe)) {
                    String msg = "Class=" + evt.recipe.getClass();
                    if (evt.recipe.func_77571_b() != null && evt.recipe.func_77571_b().func_77973_b() != null) {
                        msg = msg + ", Output=" + evt.recipe.func_77571_b();
                    } else if (evt.recipe.func_77571_b() != null) {
                        msg = msg + ", Output is a null-item ItemStack";
                    }
                    DragonAPICore.log("Invalid recipe, such as with nulled inputs, found. Removing to prevent crashes. " + msg + ".");
                    evt.setCanceled(true);
                }
            }
            catch (Exception e) {
                DragonAPICore.logError("Could not parse crafting recipe");
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void collateXP(XPUpdateEvent evt) {
        AxisAlignedBB box;
        List li;
        if (DragonOptions.XPMERGE.getState() && !evt.xp.field_70128_L && !evt.xp.field_70170_p.field_72995_K && evt.xp.field_70531_b % 16 == 0 && (li = evt.xp.field_70170_p.func_72872_a(EntityXPOrb.class, box = ReikaAABBHelper.getEntityCenteredAABB((Entity)evt.xp, 1.0))).size() > 1) {
            EntityXPOrb entityXPOrb = ReikaEntityHelper.mergeXPOrbs(evt.xp.field_70170_p, li);
        }
    }

    @Override
    public int watcherSortIndex() {
        return Integer.MAX_VALUE;
    }
}

