/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Auxiliary.PopupWriter;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Extras.ModVersion;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Collections.OneWayCollections;
import Reika.DragonAPI.Instantiable.Event.Client.ClientLoginEvent;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;

public final class CommandableUpdateChecker {
    public static final CommandableUpdateChecker instance = new CommandableUpdateChecker();
    public static final String reikaURL = "https://reikasminecraft.overminddl1.com/versions";
    private final HashMap<DragonAPIMod, ModVersion> latestVersions = new OneWayCollections.OneWayMap<DragonAPIMod, ModVersion>();
    private final Collection<UpdateChecker> checkers = new OneWayCollections.OneWayList<UpdateChecker>();
    private final Collection<DragonAPIMod> oldMods = new OneWayCollections.OneWayList<DragonAPIMod>();
    private final HashMap<DragonAPIMod, String> noURLMods = new OneWayCollections.OneWayMap<DragonAPIMod, String>();
    private final HashMap<String, DragonAPIMod> modNames = new OneWayCollections.OneWayMap<String, DragonAPIMod>();
    private final HashMap<DragonAPIMod, String> modNamesReverse = new OneWayCollections.OneWayMap<DragonAPIMod, String>();
    private final HashMap<DragonAPIMod, Boolean> overrides = new OneWayCollections.OneWayMap<DragonAPIMod, Boolean>();
    private final Collection<DragonAPIMod> dispatchedOldMods = new ArrayList<DragonAPIMod>();
    private final HashMap<DragonAPIMod, String> erroredMods = new HashMap();
    private final HashMap<DragonAPIMod, UpdateHash> hashes = new HashMap();

    private CommandableUpdateChecker() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void checkAll() {
        Runnable r = () -> {
            for (UpdateChecker c : this.checkers) {
                ModVersion latest = c.fetchLatestVersion();
                if (latest == null) {
                    c.mod.getModLogger().logError("Could not access online version reference. Please notify " + c.mod.getModAuthorName());
                    return;
                }
                c.mod.getModLogger().log("Found latest mod version: " + latest + " compared to current " + c.mod.getModVersion());
                this.latestVersions.put(c.mod, latest);
            }
            this.getOverrides();
            for (UpdateChecker c : this.checkers) {
                DragonAPIMod mod = c.mod;
                if (!this.shouldCheck(mod)) continue;
                ModVersion version = c.version;
                ModVersion latest = this.latestVersions.get(mod);
                if (latest instanceof ModVersion.ErroredVersion) {
                    this.markUpdate(mod, version, latest);
                    ReikaJavaLibrary.pConsole("-----------------------" + mod.getTechnicalName() + "-----------------------");
                    ReikaJavaLibrary.pConsole("Could not connect to version server. Please check your internet settings,");
                    ReikaJavaLibrary.pConsole("and if the server is unavailable please contact " + mod.getModAuthorName() + ".");
                    ReikaJavaLibrary.pConsole(((ModVersion.ErroredVersion)latest).errorMessage);
                    ReikaJavaLibrary.pConsole("------------------------------------------------------------------------");
                    continue;
                }
                if (version.compareTo(latest) >= 0) continue;
                this.markUpdate(mod, version, latest);
                ReikaJavaLibrary.pConsole("-----------------------" + mod.getTechnicalName() + "-----------------------");
                ReikaJavaLibrary.pConsole("This version of the mod (" + version + ") is out of date.");
                ReikaJavaLibrary.pConsole("This version is likely to contain bugs, crashes, and/or exploits.");
                ReikaJavaLibrary.pConsole("No technical support whatsoever will be provided for this version.");
                ReikaJavaLibrary.pConsole("Update to " + latest + " as soon as possible; there is no good reason not to.");
                ReikaJavaLibrary.pConsole("------------------------------------------------------------------------");
                ReikaJavaLibrary.pConsole("");
            }
        };
        Thread t = new Thread(r, "DragonAPI Update Checks");
        t.start();
    }

    private void markUpdate(DragonAPIMod mod, ModVersion version, ModVersion latest) {
        if (latest instanceof ModVersion.ErroredVersion) {
            String s = ((ModVersion.ErroredVersion)latest).errorMessage;
            int idx = s.indexOf(58);
            if (idx > 0) {
                s = s.substring(idx + 1).trim();
            }
            this.noURLMods.put(mod, s);
        } else {
            this.oldMods.add(mod);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("modDisplayName", mod.getDisplayName());
            nbt.func_74778_a("oldVersion", "v" + version.toString());
            nbt.func_74778_a("newVersion", "v" + latest.toString());
            nbt.func_74778_a("updateUrl", mod.getDocumentationSite().toString());
            nbt.func_74757_a("isDirectLink", false);
            nbt.func_74778_a("changeLog", mod.getDocumentationSite().toString());
            FMLInterModComms.sendRuntimeMessage((Object)mod.getModContainer().getModId(), (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)nbt);
        }
    }

    public void registerMod(DragonAPIMod mod) {
        ModVersion version = mod.getModVersion();
        if (version == ModVersion.source) {
            mod.getModLogger().log("Mod is in source code form. Not checking version.");
            return;
        }
        if (mod.getUpdateCheckURL() == null) {
            return;
        }
        String url = mod.getUpdateCheckURL() + "_" + "1.7.10".replaceAll("\\.", "-") + ".txt";
        URL file = this.getURL(url);
        if (file == null) {
            mod.getModLogger().logError("Could not create URL to update checker. Version will not be checked.");
            return;
        }
        UpdateChecker c = new UpdateChecker(mod, version, file);
        this.checkers.add(c);
        String label = ReikaStringParser.stripSpaces(mod.getDisplayName().toLowerCase(Locale.ENGLISH));
        this.modNames.put(label, mod);
        this.modNamesReverse.put(mod, label);
    }

    private URL getURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean shouldCheck(DragonAPIMod mod) {
        return this.overrides.containsKey(mod) ? this.overrides.get(mod) : true;
    }

    private void getOverrides() {
        File f = this.getFile();
        if (f.exists()) {
            boolean deleteFile = false;
            List<String> li = ReikaFileReader.getFileAsLines(f, true, Charsets.UTF_8);
            for (int i = 0; i < li.size(); ++i) {
                String line = li.get(i);
                String[] parts = line.split(":");
                DragonAPIMod mod = this.modNames.get(parts[0]);
                boolean b = Boolean.parseBoolean(parts[1]);
                ModVersion version = ModVersion.getFromString(parts[2]);
                if (version instanceof ModVersion.ErroredVersion) {
                    deleteFile = true;
                    continue;
                }
                if (!version.equals(this.latestVersions.get(mod))) continue;
                this.overrides.put(mod, b);
            }
            if (deleteFile) {
                f.delete();
            }
        }
    }

    private void setChecker(DragonAPIMod mod, boolean enable) {
        File f = this.getFile();
        String name = ReikaStringParser.stripSpaces(mod.getDisplayName().toLowerCase(Locale.ENGLISH));
        ModVersion latest = this.latestVersions.get(mod);
        if (f.exists()) {
            List<String> li = ReikaFileReader.getFileAsLines(f, true, Charsets.UTF_8);
            Iterator<String> it = li.iterator();
            while (it.hasNext()) {
                String line = it.next();
                if (!line.startsWith(name)) continue;
                it.remove();
            }
            li.add(name + ":" + enable + ":" + latest);
            try (PrintWriter p = new PrintWriter(f);){
                for (int i = 0; i < li.size(); ++i) {
                    p.append(li.get(i) + "\n");
                }
            }
            catch (IOException iOException) {}
        } else {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try (PrintWriter p = new PrintWriter(f);){
                p.append(name + ":" + enable + ":" + latest);
                p.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File getFile() {
        File parent0 = new File(DragonAPICore.getMinecraftDirectory(), "saves");
        File parent = new File(parent0, "DragonAPI");
        if (!parent.exists()) {
            parent.mkdirs();
        }
        return new File(parent, "ucheck.dat");
    }

    public void notifyPlayer(EntityPlayer ep) {
        if (!this.oldMods.isEmpty() || !this.noURLMods.isEmpty()) {
            this.sendMessages(ep);
        }
        if (ep instanceof EntityPlayerMP) {
            PacketTarget.PlayerTarget pt = new PacketTarget.PlayerTarget((EntityPlayerMP)ep);
            for (DragonAPIMod dragonAPIMod : this.oldMods) {
                if (!this.beAggressive(dragonAPIMod, (EntityPlayerMP)ep)) continue;
                ReikaPacketHelper.sendStringPacket("DragonAPIData", APIPacketHandler.PacketIDs.OLDMODS.ordinal(), this.modNamesReverse.get(dragonAPIMod), pt);
            }
            for (Map.Entry entry : this.noURLMods.entrySet()) {
                ReikaPacketHelper.sendStringPacket("DragonAPIData", APIPacketHandler.PacketIDs.OLDMODS.ordinal(), "URL_" + this.modNamesReverse.get(entry.getKey()) + "::" + (String)entry.getValue(), pt);
            }
        }
    }

    private boolean beAggressive(DragonAPIMod mod, EntityPlayerMP ep) {
        if (DragonOptions.OPONLYUPDATE.getState()) {
            return DragonAPICore.isSinglePlayer() || ReikaPlayerAPI.isAdmin(ep);
        }
        return true;
    }

    private boolean isPackMaker(DragonAPIMod mod, EntityPlayerMP ep) {
        UpdateHash test = this.genHash(mod, (EntityPlayer)ep);
        UpdateHash get = this.getOrCreateHash(mod, (EntityPlayer)ep);
        return get.equals(test);
    }

    private UpdateHash getOrCreateHash(DragonAPIMod mod, EntityPlayer ep) {
        UpdateHash uh = this.hashes.get(mod);
        if (uh == null) {
            uh = this.readHash(mod);
            if (uh == null) {
                uh = this.genHash(mod, ep);
                this.writeHash(mod, uh);
            }
            this.hashes.put(mod, uh);
        }
        return uh;
    }

    private UpdateHash readHash(DragonAPIMod mod) {
        File f = this.getHashFile();
        List<String> data = ReikaFileReader.getFileAsLines(f, true, Charsets.UTF_8);
        for (String s : data) {
            String tag;
            if (!s.startsWith(tag = mod.getDisplayName() + "=")) continue;
            return UpdateHash.decode(s.substring(tag.length()));
        }
        return null;
    }

    private void writeHash(DragonAPIMod mod, UpdateHash uh) {
        File f = this.getHashFile();
        List<String> data = ReikaFileReader.getFileAsLines(f, true, Charsets.UTF_8);
        String tag = mod.getDisplayName() + "=";
        data.add(tag + uh.toString());
        try (BufferedReader r = new BufferedReader(new FileReader(f));
             FileOutputStream os = new FileOutputStream(f);){
            String sep = System.getProperty("line.separator");
            String line = r.readLine();
            StringBuilder out = new StringBuilder();
            for (String l : data) {
                out.append(l + sep);
            }
            os.write(out.toString().getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getHashFile() {
        File parent0 = new File(DragonAPICore.getMinecraftDirectory(), "config");
        File parent = new File(parent0, "Reika");
        if (!parent.exists()) {
            parent.mkdirs();
        }
        File f = new File(parent, "versions.dat");
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return f;
    }

    private UpdateHash genHash(DragonAPIMod mod, EntityPlayer ep) {
        return new UpdateHash(ep.func_110124_au(), ReikaFileReader.getRealPath(mod.getModContainer().getSource()), System.currentTimeMillis());
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientLogin(ClientLoginEvent evt) {
        this.genHashes(evt.player);
    }

    private void genHashes(EntityPlayer ep) {
        for (DragonAPIMod mod : this.latestVersions.keySet()) {
            this.getOrCreateHash(mod, ep);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onClientReceiveOldModID(String s) {
        if (s.startsWith("URL_")) {
            s = s.substring(4);
            String[] parts = s.split("::");
            DragonAPIMod mod = this.modNames.get(parts[0]);
            this.erroredMods.put(mod, parts[1]);
        } else {
            DragonAPIMod mod = this.modNames.get(s);
            if (!this.dispatchedOldMods.contains(mod)) {
                this.dispatchedOldMods.add(mod);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientReceiveOldModsNote(ClientLoginEvent evt) {
        if (evt.newLogin) {
            StringBuilder sb;
            ArrayList<String> li = new ArrayList<String>();
            for (DragonAPIMod dragonAPIMod : this.dispatchedOldMods) {
                sb = new StringBuilder();
                sb.append(dragonAPIMod.getDisplayName());
                sb.append(" ");
                sb.append(dragonAPIMod.getModVersion());
                sb.append(" is out of date. Update to ");
                sb.append(this.latestVersions.get(dragonAPIMod).toString());
                sb.append(" as soon as possible.");
                li.add(sb.toString());
            }
            for (Map.Entry entry : this.erroredMods.entrySet()) {
                sb = new StringBuilder();
                DragonAPIMod mod = (DragonAPIMod)entry.getKey();
                sb.append(mod.getDisplayName());
                String err = (String)entry.getValue();
                if (Strings.isNullOrEmpty((String)err)) {
                    err = "The version server may be inaccessible";
                }
                sb.append(" could not verify its version; " + err + ". Check your internet settings, and please notify ");
                sb.append(mod.getModAuthorName());
                sb.append(" if the server is not accessible.");
                li.add(sb.toString());
            }
            for (String string : li) {
                PopupWriter.instance.addMessage(string);
            }
        }
    }

    private void sendMessages(EntityPlayer ep) {
        String sg = EnumChatFormatting.YELLOW.toString() + "DragonAPI Notification:";
        ReikaChatHelper.sendChatToPlayer(ep, sg);
        for (DragonAPIMod mod : this.oldMods) {
            String s = this.getChatMessage(mod);
            ReikaChatHelper.sendChatToPlayer(ep, s);
        }
        String g = EnumChatFormatting.YELLOW.toString();
        String sg2 = g + "To disable this notifcation for any mod, type \"/" + "checker" + " disable [modname]\".";
        ReikaChatHelper.sendChatToPlayer(ep, sg2);
        sg2 = g + "Changes take effect upon server or client restart.";
        ReikaChatHelper.sendChatToPlayer(ep, sg2);
    }

    private String getChatMessage(DragonAPIMod mod) {
        ModVersion latest = this.latestVersions.get(mod);
        String g = EnumChatFormatting.LIGHT_PURPLE.toString();
        String r = EnumChatFormatting.RESET.toString();
        return g + mod.getDisplayName() + r + " is out of date, likely has errors, and is no longer supported. Update to " + latest + ".";
    }

    private static class VersionNotLoadableException
    extends RuntimeException {
        public VersionNotLoadableException(String s) {
            super(s);
        }
    }

    private static class UpdateHash {
        private final long timestamp;
        private final String filepath;
        private final UUID player;
        private static final char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '~', '`', '+', '-', '=', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '[', ']', '{', '}', ';', ':', '<', '>', ',', '.'};

        private UpdateHash(UUID id, String file, long time) {
            this.player = id;
            this.filepath = file;
            this.timestamp = time;
        }

        public boolean equals(Object o) {
            if (o instanceof UpdateHash) {
                UpdateHash uh = (UpdateHash)o;
                return uh.player == this.player && uh.filepath.equals(this.player);
            }
            return false;
        }

        public String toString() {
            String time = String.valueOf(this.timestamp);
            String id = this.player.toString();
            StringBuffer sb = new StringBuffer();
            for (int idx = 0; idx < time.length() || idx < id.length() || idx < this.filepath.length(); ++idx) {
                long c1 = idx >= time.length() ? 42L : (long)time.charAt(idx);
                long c2 = idx >= id.length() ? 42L : (long)id.charAt(idx);
                long c3 = idx >= this.filepath.length() ? 42L : (long)this.filepath.charAt(idx);
                long sum = c1 | c2 << 16 | c3 << 32;
                sb.append(UpdateHash.getStringForInt(sum) + ":");
            }
            return sb.toString();
        }

        public static UpdateHash decode(String s) {
            StringBuilder path = new StringBuilder();
            StringBuilder id = new StringBuilder();
            StringBuilder time = new StringBuilder();
            String[] parts = s.split(":");
            for (int i = 0; i < parts.length; ++i) {
                String p = parts[i];
                long dat = UpdateHash.getIntForString(p);
                char c1 = (char)(dat & 0xFFFFL);
                char c2 = (char)(dat >> 16 & 0xFFFFL);
                char c3 = (char)(dat >> 32 & 0xFFFFL);
                if (c1 != '*') {
                    time.append(c1);
                }
                if (c2 != '*') {
                    id.append(c2);
                }
                if (c3 == '*') continue;
                path.append(c3);
            }
            return new UpdateHash(UUID.fromString(id.toString()), path.toString(), Long.parseLong(time.toString()));
        }

        private static String getStringForInt(long l) {
            return Long.toString(l, 36);
        }

        private static long getIntForString(String s) {
            return Long.parseLong(s, 36);
        }
    }

    private static class UpdateChecker
    implements ReikaFileReader.ConnectionErrorHandler,
    ReikaFileReader.DataFetcher {
        private final ModVersion version;
        private final URL checkURL;
        private final DragonAPIMod mod;
        private Date modified;

        private UpdateChecker(DragonAPIMod mod, ModVersion version, URL url) {
            this.mod = mod;
            this.version = version;
            this.checkURL = url;
        }

        private ModVersion fetchLatestVersion() {
            try {
                List<String> lines = ReikaFileReader.getFileAsLines(this.checkURL, 10000, false, this, this);
                if (lines == null || lines.isEmpty()) {
                    throw new VersionNotLoadableException("File was empty or null");
                }
                String name = ReikaStringParser.stripSpaces(this.mod.getDisplayName().toLowerCase(Locale.ENGLISH));
                for (String line : lines) {
                    if (!line.toLowerCase().startsWith(name)) continue;
                    String[] parts = line.split(":");
                    ModVersion version = ModVersion.getFromString(parts[1]);
                    return version;
                }
            }
            catch (VersionNotLoadableException e) {
                this.logError(e);
                return new ModVersion.ErroredVersion(e);
            }
            catch (Exception e) {
                this.logError(e);
            }
            return null;
        }

        private void logError(Exception e) {
            if (e instanceof IOException) {
                this.mod.getModLogger().logError("IO Error accessing online file:");
                this.mod.getModLogger().log(e.getClass().getCanonicalName() + ": " + e.getLocalizedMessage());
                this.mod.getModLogger().log(e.getStackTrace()[0].toString());
            } else {
                this.mod.getModLogger().logError("Error accessing online file:");
                e.printStackTrace();
            }
        }

        @Override
        public void onServerRedirected() {
            throw new VersionNotLoadableException("Version server not found!");
        }

        @Override
        public void onNoInternet() {
            this.mod.getModLogger().logError("Error accessing online file: Is your internet disconnected?");
        }

        @Override
        public void onServerNotFound() {
            throw new VersionNotLoadableException("Version server not found!");
        }

        @Override
        public void onCertificateFailed() {
            throw new VersionNotLoadableException("Version server could not be contacted: HTTPS certificate issues");
        }

        @Override
        public void onTimedOut() {
            this.mod.getModLogger().logError("Error accessing online file: Timed Out");
        }

        @Override
        public void fetchData(URLConnection c) throws Exception {
            String lastModified = c.getHeaderField("Last-Modified");
            this.modified = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss Z", Locale.ENGLISH).parse(lastModified);
        }
    }

    public static class CheckerDisableCommand
    extends DragonCommandBase {
        public static final String tag = "checker";

        @Override
        public String getCommandString() {
            return tag;
        }

        @Override
        protected boolean isAdminOnly() {
            return false;
        }

        public void func_71515_b(ICommandSender ics, String[] args) {
            EntityPlayerMP ep = CheckerDisableCommand.func_71521_c((ICommandSender)ics);
            if (args.length == 2) {
                String action = args[0];
                String name = args[1].toLowerCase(Locale.ENGLISH);
                DragonAPIMod mod = (DragonAPIMod)instance.modNames.get(name);
                if (mod != null) {
                    if (action.equals("disable")) {
                        instance.setChecker(mod, false);
                        String sg = EnumChatFormatting.BLUE.toString() + "Update checker for " + mod.getDisplayName() + " disabled.";
                        ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, sg);
                    } else if (action.equals("enable")) {
                        instance.setChecker(mod, true);
                        String sg = EnumChatFormatting.BLUE.toString() + "Update checker for " + mod.getDisplayName() + " enabled.";
                        ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, sg);
                    } else {
                        String sg = EnumChatFormatting.RED.toString() + "Invalid argument '" + action + "'.";
                        ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, sg);
                    }
                } else {
                    String sg = EnumChatFormatting.RED.toString() + "Mod '" + name + "' not found.";
                    ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, sg);
                }
            } else {
                String sg = EnumChatFormatting.RED.toString() + "Invalid arguments.";
                ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, sg);
            }
        }
    }
}

