/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Auxiliary.Trackers.DonatorController;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Maps.CountMap;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.util.EnumChatFormatting;

public final class PatreonController {
    public static final PatreonController instance = new PatreonController();
    public static final String reikaURL = "https://reikasminecraft.overminddl1.com/Donator/patreon_";
    private final HashMap<String, Patrons> data = new HashMap();

    private PatreonController() {
    }

    public void registerMod(String dev, String root) {
        String url = root + ReikaStringParser.stripSpaces(dev) + ".txt";
        URL file = this.getURL(url);
        if (file == null) {
            DragonAPICore.logError("Could not create URL to patreon file. Donators will not be loaded.");
            return;
        }
        DonatorFile f = new DonatorFile(dev);
        List<String> lines = ReikaFileReader.getFileAsLines(file, 10000, false, f);
        if (lines != null) {
            DragonAPICore.log("Loading " + lines.size() + " patrons for " + dev);
            this.addPatrons(dev, lines);
        }
    }

    private void addPatrons(String dev, List<String> lines) {
        for (String s : lines) {
            s = ReikaStringParser.stripSpaces(s);
            try {
                this.tryLoadingPatron(dev, s);
            }
            catch (Exception e) {
                DragonAPICore.logError("Invalid patreon line: " + s + " for " + dev + ": " + e.toString());
            }
        }
    }

    private void tryLoadingPatron(String dev, String s) {
        String[] parts = s.split(":");
        parts[parts.length - 1] = ReikaStringParser.clipStringBefore(parts[parts.length - 1], "//");
        if (parts.length == 3) {
            this.addPatron(dev, parts[0], parts[1], Integer.parseInt(parts[2]));
        } else if (parts.length == 2) {
            this.addPatron(dev, parts[0], Integer.parseInt(parts[1]));
        } else {
            throw new IllegalArgumentException("Too few arguments!");
        }
    }

    private URL getURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addPatron(String dev, String name, int amt) {
        this.addPatron(dev, name, null, amt);
    }

    private void addPatron(String dev, String name, String ingame, int amt) {
        Patrons p = this.getOrCreate(dev);
        p.addPatron(name, ingame != null ? UUID.fromString(ingame) : null, amt);
        DragonAPICore.log("Adding patron to " + dev + ": " + name + " / " + ingame + " @ $" + amt);
    }

    private Patrons getOrCreate(String dev) {
        Patrons p = this.data.get(dev);
        if (p == null) {
            p = new Patrons();
            this.data.put(dev, p);
        }
        return p;
    }

    public Collection<DonatorController.Donator> getModPatrons(String dev) {
        Patrons p = this.data.get(dev);
        return p != null ? Collections.unmodifiableCollection(p.data.keySet()) : new ArrayList();
    }

    public int getAmount(String dev, String name, UUID id) {
        return this.data.get(dev).getAmount(name, id);
    }

    public Collection<DonatorController.Donator> getPatronsOver(String dev, int amount) {
        return this.data.get(dev).getPatronsOver(amount);
    }

    public boolean isPatronAtLeast(String dev, String name, UUID id, int amount) {
        return this.data.get(dev).isPatronAtLeast(name, id, amount);
    }

    public int getTotal(String dev) {
        return this.data.get(dev).getTotal();
    }

    public String toString() {
        return this.data.toString();
    }

    public String getDisplayList() {
        StringBuilder sb = new StringBuilder();
        for (String dev : this.data.keySet()) {
            Patrons li = this.data.get(dev);
            sb.append(EnumChatFormatting.BLUE.toString());
            sb.append("Patreon for ");
            sb.append(dev);
            sb.append(":\n");
            sb.append(li.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static class Patrons {
        private final CountMap<DonatorController.Donator> data = new CountMap();
        private int total;

        private Patrons() {
        }

        private void addPatron(String name, UUID id, int amt) {
            DonatorController.Donator d = new DonatorController.Donator(name, id);
            if (this.data.containsKey(d)) {
                throw new MisuseException("You cannot have two copies of the same patron!");
            }
            this.data.increment(d, amt);
            this.total += amt;
        }

        public int getTotal() {
            return this.total;
        }

        private int getAmount(String name, UUID id) {
            DonatorController.Donator d = new DonatorController.Donator(name, id);
            return this.data.get(d);
        }

        private Collection<DonatorController.Donator> getPatronsOver(int amount) {
            ArrayList<DonatorController.Donator> li = new ArrayList<DonatorController.Donator>();
            for (DonatorController.Donator d : this.data.keySet()) {
                int f = this.data.get(d);
                if (f < amount) continue;
                li.add(d);
            }
            return li;
        }

        private boolean isPatronAtLeast(String name, UUID id, int amount) {
            return this.getAmount(name, id) >= amount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (DonatorController.Donator d : this.data.keySet()) {
                int amt = this.data.get(d);
                sb.append(String.format("  %s%s%s: %s%d%s\n", this.getDisplayColor(amt).toString(), this.getFormatting(amt), d.toString(), "$", amt, "/mo"));
            }
            return sb.toString();
        }

        public String getFormatting(int amt) {
            return "";
        }

        public EnumChatFormatting getDisplayColor(int amt) {
            if (amt >= 30) {
                return EnumChatFormatting.GOLD;
            }
            if (amt >= 20) {
                return EnumChatFormatting.LIGHT_PURPLE;
            }
            if (amt >= 10) {
                return EnumChatFormatting.GREEN;
            }
            return EnumChatFormatting.WHITE;
        }
    }

    private static class DonatorFile
    implements ReikaFileReader.ConnectionErrorHandler {
        private final String dev;

        private DonatorFile(String dev) {
            this.dev = dev;
        }

        @Override
        public void onServerRedirected() {
            DragonAPICore.logError("Donator server not found!");
        }

        @Override
        public void onNoInternet() {
            DragonAPICore.logError("Error accessing online file: Is your internet disconnected?");
        }

        @Override
        public void onServerNotFound() {
            DragonAPICore.logError("Donator server not found!");
        }

        @Override
        public void onTimedOut() {
            DragonAPICore.logError("Error accessing online file: Timed Out");
        }

        @Override
        public void onCertificateFailed() {
            DragonAPICore.logError("Error accessing online file: Your HTTP certificate is invalid!");
        }
    }
}

