/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary.Trackers;

import Reika.DragonAPI.Auxiliary.PopupWriter;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Event.Client.ClientLoginEvent;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaDateHelper;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.codec.Charsets;

public class RemoteAssetLoader {
    public static final RemoteAssetLoader instance = new RemoteAssetLoader();
    private final ArrayList<RemoteAsset> downloadingAssets = new ArrayList();
    private AssetDownloader downloader;
    private Thread downloadThread;
    private final ArrayList<BigWarning> bigWarnings = new ArrayList();

    private RemoteAssetLoader() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void registerAssets(RemoteAssetRepository rar) {
        rar.load();
        for (RemoteAsset a : rar.getAssets()) {
            if (!a.requiresDownload) continue;
            this.downloadingAssets.add(a);
        }
    }

    public void checkAndStartDownloads() {
        if (!this.downloadingAssets.isEmpty()) {
            DragonAPICore.log("Some remote assets need to be redownloaded:");
            this.downloader = new AssetDownloader();
            for (RemoteAsset a : this.downloadingAssets) {
                a.log("Remote Asset '" + a.getDisplayName() + "' for " + a.mod.getDisplayName() + " is either missing or out of date. Redownloading...");
                AssetDownloader assetDownloader = this.downloader;
                assetDownloader.totalSize = assetDownloader.totalSize + ((RemoteAsset)a).data.size;
            }
            DragonAPICore.log("Projected total download size: " + this.downloader.totalSize + " bytes in " + this.downloadingAssets.size() + " files.");
            this.downloadThread = new Thread((Runnable)this.downloader, "Remote Asset Download");
            this.downloadThread.start();
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new RemoteAssetsDownloadCompleteEvent(this.downloadingAssets, 0L));
        }
    }

    public float getDownloadProgress() {
        return this.downloader != null ? Math.min(1.0f, this.downloader.getTotalCompletion()) : 1.0f;
    }

    public float getCurrentFileProgress() {
        return this.downloader != null ? Math.min(1.0f, this.downloader.getCurrentFileCompletion()) : 1.0f;
    }

    public boolean isDownloadComplete() {
        return this.downloadThread == null || !this.downloadThread.isAlive() || this.downloader == null || this.downloader.isComplete;
    }

    @SubscribeEvent
    public void onClientReceiveWarning(ClientLoginEvent evt) {
        for (BigWarning w : this.bigWarnings) {
            String sg = w.message + " the file server for remote asset repository '" + w.repository.getDisplayName() + "' may be inaccessible. Check your internet settings, and please notify " + w.repository.mod.getModAuthorName() + " if the server is not accessible.";
            PopupWriter.instance.addMessage(sg);
        }
    }

    public static class DownloadDisplayWindow
    extends JOptionPane {
        private DownloadDisplayWindow() {
        }
    }

    public static class RemoteAssetsDownloadCompleteEvent
    extends Event {
        public final Collection<RemoteAsset> downloadQueue;
        public final long totalSize;

        private RemoteAssetsDownloadCompleteEvent(ArrayList<RemoteAsset> li, long size) {
            this.downloadQueue = Collections.unmodifiableCollection(li);
            this.totalSize = size;
        }
    }

    private static class BigWarning {
        private final String message;
        private final RemoteAssetRepository repository;

        private BigWarning(String msg, RemoteAssetRepository rar) {
            this.message = msg;
            this.repository = rar;
        }
    }

    public static abstract class RemoteAsset {
        private final DragonAPIMod mod;
        private final RemoteAssetRepository parent;
        private String filename;
        private String extension;
        private boolean requiresDownload;
        private AssetData data;
        private boolean downloaded;

        protected RemoteAsset(DragonAPIMod mod, RemoteAssetRepository rar) {
            this.mod = mod;
            this.parent = rar;
        }

        public abstract String setFilename(String var1);

        public abstract String setExtension(String var1);

        public abstract String getDisplayName();

        public final File getLocalPath() {
            return new File(this.parent.getLocalStorageFolder(), this.filename + "." + this.extension);
        }

        public final String toString() {
            return this.getDisplayName();
        }

        protected final void log(String s) {
            DragonAPICore.log(s);
        }

        protected abstract AssetData constructData(String var1);

        public final boolean downloadedSuccessfully() {
            return this.downloaded;
        }

        public final boolean available() {
            return !this.requiresDownload || this.downloadedSuccessfully();
        }
    }

    public static abstract class RemoteAssetRepository
    implements ReikaFileReader.ConnectionErrorHandler {
        private boolean nonAccessible;
        private final Collection<RemoteAsset> assets = new ArrayList<RemoteAsset>();
        private final DragonAPIMod mod;

        protected RemoteAssetRepository(DragonAPIMod mod) {
            this.mod = mod;
        }

        private final void load() {
            URL url = null;
            try {
                url = URI.create(this.getRepositoryURL()).toURL();
            }
            catch (MalformedURLException e) {
                this.logError("Asset Repository URL invalid", true);
                e.printStackTrace();
                return;
            }
            List<String> li = ReikaFileReader.getFileAsLines(url, 10000, true, this, null);
            if (li == null) {
                if (!this.nonAccessible) {
                    this.logError("Could not load asset repository", true);
                }
                return;
            }
            for (String s : li) {
                RemoteAsset a = this.parseAsset(s);
                if (a == null) continue;
                this.assets.add(a);
                a.filename = a.setFilename(s);
                a.extension = a.setExtension(s);
                a.data = a.constructData(s);
                a.requiresDownload = !a.data.match();
            }
            this.writeList();
            DragonAPICore.log(this.assets.size() + " remote assets for " + this.mod.getDisplayName() + " found at " + this.getDisplayName() + ": " + this.assets);
        }

        private void writeList() {
            try {
                File f = new File(this.getLocalStorageFolder(), "file_list.dat");
                f.mkdirs();
                f.delete();
                f.createNewFile();
                ArrayList<String> li = new ArrayList<String>();
                li.add("File list for remote asset repository '" + this.getDisplayName() + "'");
                li.add("Downloaded from " + this.getRepositoryURL() + " to " + this.getLocalStorageFolder());
                int n = ((String)li.get(li.size() - 1)).length();
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < n; ++i) {
                    sb.append("=");
                }
                li.add(sb.toString());
                for (RemoteAsset a : this.assets) {
                    li.add(a.getDisplayName() + " -> " + a.getLocalPath() + " {Size=" + ((RemoteAsset)a).data.size + " B,  Hash=" + ((RemoteAsset)a).data.hash + "}");
                }
                ReikaFileReader.writeLinesToFile(f, li, true, Charsets.UTF_8);
                DragonAPICore.log("Writing file list for remote asset repository '" + this.getDisplayName() + "' to disk.");
            }
            catch (IOException e) {
                DragonAPICore.logError("Remote asset repository '" + this.getDisplayName() + "' could not save its file list to disk.");
                e.printStackTrace();
            }
        }

        protected abstract RemoteAsset parseAsset(String var1);

        protected final Collection<RemoteAsset> getAssets() {
            return Collections.unmodifiableCollection(this.assets);
        }

        public final Collection<String> getAvailableResources() {
            File file = new File(this.getLocalStorageFolder(), "file_list.dat");
            ArrayList<String> ret = new ArrayList<String>();
            if (!file.exists()) {
                return ret;
            }
            List<String> li = ReikaFileReader.getFileAsLines(file, true, Charsets.UTF_8);
            for (String s : li) {
                String p;
                File f;
                int idx = s.indexOf(62);
                int idx2 = s.indexOf(123);
                if (idx < 0 || idx2 < idx || !(f = new File(p = s.substring(idx + 2, idx2 - 1))).exists()) continue;
                ret.add(p);
            }
            return ret;
        }

        public abstract String getRepositoryURL();

        public abstract File getLocalStorageFolder();

        @Override
        public final void onServerRedirected() {
            this.logError("Asset Server access redirected!?", true);
        }

        @Override
        public final void onNoInternet() {
            this.logError("Is your internet disconnected?", false);
        }

        @Override
        public final void onServerNotFound() {
            this.logError("Asset Server not found!", true);
        }

        @Override
        public final void onCertificateFailed() {
            this.logError("HTTP Certificate Invalid!", true);
        }

        @Override
        public final void onTimedOut() {
            this.logError("Timed Out", false);
        }

        private final void logError(String msg, boolean bigWarn) {
            this.nonAccessible = true;
            DragonAPICore.logError("Error accessing online asset data file: " + msg);
            if (bigWarn) {
                instance.bigWarnings.add(new BigWarning("Downloading the remote assets failed: " + msg, this));
            }
        }

        public abstract String getDisplayName();

        public final String toString() {
            return this.getDisplayName() + ": " + this.assets.size() + "x" + this.assets;
        }
    }

    public static class AssetData {
        protected final RemoteAsset asset;
        protected final String name;
        protected final String path;
        protected final long size;
        protected final String hash;

        public AssetData(RemoteAsset a, String p, String n, String h, long s) {
            this.asset = a;
            this.name = n;
            this.path = p;
            this.size = s;
            this.hash = h;
        }

        private String getLocalHash() {
            File f = this.asset.getLocalPath();
            return f.exists() ? ReikaFileReader.getHash(f, ReikaFileReader.HashType.MD5) : "";
        }

        protected boolean match() {
            return this.getLocalHash().equalsIgnoreCase(this.hash);
        }

        public String getDisplayName() {
            return ReikaStringParser.capFirstChar(this.name);
        }
    }

    private static class AssetDownloader
    implements Runnable,
    ReikaFileReader.WriteCallback {
        private long totalSize = 0L;
        private long downloaded = 0L;
        private RemoteAsset activeAsset;
        private long currentDownload;
        private boolean isComplete = false;

        private AssetDownloader() {
        }

        @Override
        public void run() {
            long time = System.currentTimeMillis();
            DragonAPICore.log("Remote asset download thread starting...");
            Iterator iterator = instance.downloadingAssets.iterator();
            while (iterator.hasNext()) {
                RemoteAsset a;
                this.activeAsset = a = (RemoteAsset)iterator.next();
                this.currentDownload = 0L;
                this.tryDownload(a.data, 5);
            }
            long duration = System.currentTimeMillis() - time;
            DragonAPICore.log("All asset downloads complete. Elapsed time: " + ReikaDateHelper.millisToHMSms(duration));
            this.isComplete = true;
            MinecraftForge.EVENT_BUS.post((Event)new RemoteAssetsDownloadCompleteEvent(instance.downloadingAssets, this.totalSize));
        }

        public float getTotalCompletion() {
            return (float)this.downloaded / (float)this.totalSize;
        }

        public float getCurrentFileCompletion() {
            return (float)this.currentDownload / (float)((RemoteAsset)this.activeAsset).data.size;
        }

        private void tryDownload(AssetData dat, int max) {
            for (int i = 0; i < max; ++i) {
                try {
                    this.download(dat);
                }
                catch (ReikaFileReader.FileReadException e) {
                    boolean end = i == max - 1;
                    String text = end ? "Skipping file." : "Retrying...";
                    DragonAPICore.logError("Could not read remote asset '" + dat.getDisplayName() + "'. " + text);
                    e.printStackTrace();
                    if (!end) continue;
                    dat.asset.parent.logError(e.getLocalizedMessage(), true);
                }
                catch (ReikaFileReader.FileWriteException e) {
                    DragonAPICore.logError("Could not save asset '" + dat.getDisplayName() + "'. Skipping file.");
                    e.printStackTrace();
                }
                catch (IOException e) {
                    DragonAPICore.logError("Could not download remote asset '" + dat.getDisplayName() + "'. Skipping file.");
                    e.printStackTrace();
                }
                break;
            }
        }

        private void download(AssetData dat) throws IOException {
            File f = dat.asset.getLocalPath();
            if (!ReikaFileReader.isFileWithin(f, DragonAPICore.getMinecraftDirectory())) {
                StringBuilder sb = new StringBuilder();
                sb.append("Remote Asset " + dat.asset.getDisplayName() + " attempted to download to " + f.getCanonicalPath() + "!");
                sb.append(" This is not in the MC directory and very likely either malicious or poorly implemented, or the remote server has been compromised!");
                String s = sb.toString();
                dat.asset.parent.logError(s, true);
                return;
            }
            f.getParentFile().mkdirs();
            f.delete();
            f.createNewFile();
            URLConnection c = new URL(dat.path).openConnection();
            try (InputStream in = c.getInputStream();
                 FileOutputStream out = new FileOutputStream(f);){
                long time = System.currentTimeMillis();
                ReikaFileReader.copyFile(in, out, 4096, this);
                long duration = System.currentTimeMillis() - time;
                String s = "Download of '" + dat.getDisplayName() + "' to '" + dat.asset.getLocalPath() + "' complete. Elapsed time: " + ReikaDateHelper.millisToHMSms(duration);
                DragonAPICore.log(s);
                DragonAPICore.log("Remote asset downloads now " + String.format("%.2f", Float.valueOf(Math.min(100.0f, this.getTotalCompletion() * 100.0f))) + "% complete.");
                dat.asset.downloaded = true;
            }
        }

        @Override
        public void onWrite(byte[] data) {
            this.downloaded += (long)data.length;
            this.currentDownload += (long)data.length;
        }
    }
}

