/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Auxiliary;

import Reika.DragonAPI.Auxiliary.Trackers.WorldgenProfiler;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Event.ChunkGenerationEvent;
import Reika.DragonAPI.Instantiable.Event.ChunkPopulationEvent;
import Reika.DragonAPI.Instantiable.Event.ChunkRequestEvent;
import Reika.DragonAPI.Instantiable.Event.Client.SinglePlayerLogoutEvent;
import Reika.DragonAPI.Instantiable.Event.SetBlockEvent;
import Reika.DragonAPI.ModInteract.DeepInteract.PlanetDimensionHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.MinecraftForge;

public class WorldGenInterceptionRegistry
implements ChunkRequestEvent.ChunkRequestWatcher {
    public static final WorldGenInterceptionRegistry instance = new WorldGenInterceptionRegistry();
    public static boolean skipLighting = false;
    private int runningChunkDecoration = 0;
    private final HashMap<Coordinate, BlockSetData> data = new HashMap();
    private final ArrayList<BlockSetWatcher> watchers = new ArrayList();
    private final ArrayList<IWGWatcher> IWGwatchers = new ArrayList();
    private final ArrayList<DecorationWatcher> decorationWatchers = new ArrayList();
    private final ArrayList<InterceptionException> exceptions = new ArrayList();
    private boolean dispatchingChanges = false;
    private final LinkedList<IWorldGenerator> currentlyRunningGenerators = new LinkedList();
    private final LinkedList<Integer> currentlyRunningChunkX = new LinkedList();
    private final LinkedList<Integer> currentlyRunningChunkZ = new LinkedList();

    private WorldGenInterceptionRegistry() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ChunkRequestEvent.addListener(this);
    }

    public void addWatcher(BlockSetWatcher w) {
        this.watchers.add(w);
    }

    public void addIWGWatcher(IWGWatcher w) {
        this.IWGwatchers.add(w);
    }

    public void addDecorationWatcher(DecorationWatcher w) {
        this.decorationWatchers.add(w);
    }

    public void addException(InterceptionException e) {
        this.exceptions.add(e);
    }

    @Override
    public int watcherSortIndex() {
        return 0;
    }

    @Override
    public void onChunkRequested(WorldServer w, ChunkProviderServer p, int cx2, int cz2) {
        if (WorldgenProfiler.profilingEnabled()) {
            boolean gen;
            boolean bl = gen = !ChunkRequestEvent.chunkIsLoaded() && !ChunkRequestEvent.chunkExistsOnDisk();
            if (gen) {
                WorldgenProfiler.startChunk(cx2, cz2);
            }
            if (!this.currentlyRunningGenerators.isEmpty()) {
                long time = System.nanoTime();
                IWorldGenerator spiller = this.currentlyRunningGenerators.getLast();
                int cx = this.currentlyRunningChunkX.getLast();
                int cz = this.currentlyRunningChunkZ.getLast();
                if (cx != cx2 || cz != cz2) {
                    WorldgenProfiler.onChunkSpills(spiller, cx, cz, cx2, cz2, time, gen);
                }
            }
        }
    }

    @SubscribeEvent
    public void prePopulation(ChunkGenerationEvent evt) {
        if (!this.watchers.isEmpty()) {
            ++this.runningChunkDecoration;
        }
    }

    @SubscribeEvent
    public void onSetBlock(SetBlockEvent.Pre evt) {
        if (this.watchers.isEmpty()) {
            return;
        }
        if (this.runningChunkDecoration <= 0) {
            return;
        }
        if (this.dispatchingChanges) {
            return;
        }
        if (PlanetDimensionHandler.isGalacticWorld(evt.world)) {
            return;
        }
        for (InterceptionException e : this.exceptions) {
            if (!e.doesExceptionApply(evt.world, evt.xCoord, evt.yCoord, evt.zCoord, evt.newBlock, evt.newMeta)) continue;
            return;
        }
        Coordinate c = new Coordinate(evt.xCoord, evt.yCoord, evt.zCoord);
        this.data.put(c, new BlockSetData(c, evt.currentBlock, evt.currentMeta, evt.newBlock, evt.newMeta));
    }

    public void postPopulation(World world, int cx, int cz) {
        this.dispatchingChanges = true;
        if (!this.data.isEmpty()) {
            Map<Coordinate, BlockSetData> map = Collections.unmodifiableMap(new HashMap<Coordinate, BlockSetData>(this.data));
            for (BlockSetWatcher w : this.watchers) {
                w.onChunkGeneration(world, map);
            }
        }
        this.dispatchingChanges = false;
        this.data.clear();
        --this.runningChunkDecoration;
        if (this.runningChunkDecoration < 0) {
            this.runningChunkDecoration = 0;
        }
        if (WorldgenProfiler.profilingEnabled()) {
            WorldgenProfiler.finishChunk(System.nanoTime(), cx, cz);
        }
    }

    @SubscribeEvent
    public void onSSPLogout(SinglePlayerLogoutEvent evt) {
        this.data.clear();
        this.runningChunkDecoration = 0;
        this.dispatchingChanges = false;
    }

    public static void interceptChunkPopulation(int cx, int cz, World world, IChunkProvider generator, IChunkProvider loader) {
        ChunkPopulationEvent evt = new ChunkPopulationEvent(world, cx, cz, generator, loader);
        if (!MinecraftForge.EVENT_BUS.post((Event)evt)) {
            GameRegistry.generateWorld((int)cx, (int)cz, (World)world, (IChunkProvider)generator, (IChunkProvider)loader);
        }
        instance.postPopulation(world, cx, cz);
    }

    public static void interceptIWG(IWorldGenerator gen, Random random, int cx, int cz, World world, IChunkProvider generator, IChunkProvider loader) {
        for (IWGWatcher w : WorldGenInterceptionRegistry.instance.IWGwatchers) {
            if (w.canIWGRun(gen, random, cx, cz, world, generator, loader)) continue;
            return;
        }
        if (WorldgenProfiler.profilingEnabled()) {
            WorldGenInterceptionRegistry.instance.currentlyRunningChunkX.add(cx);
            WorldGenInterceptionRegistry.instance.currentlyRunningChunkZ.add(cz);
            WorldGenInterceptionRegistry.instance.currentlyRunningGenerators.add(gen);
        }
        int id = 0;
        if (WorldgenProfiler.profilingEnabled()) {
            id = world.field_73011_w.field_76574_g;
            WorldgenProfiler.startGenerator(id, gen, cx, cz);
        }
        gen.generate(random, cx, cz, world, generator, loader);
        if (WorldgenProfiler.profilingEnabled()) {
            WorldgenProfiler.onRunGenerator(id, gen, cx, cz);
            WorldGenInterceptionRegistry.instance.currentlyRunningGenerators.removeLast();
            WorldGenInterceptionRegistry.instance.currentlyRunningChunkX.removeLast();
            WorldGenInterceptionRegistry.instance.currentlyRunningChunkZ.removeLast();
        }
    }

    public static void runBiomeDecorator(BiomeGenBase b, World world, Random rand, int x, int z) {
        for (DecorationWatcher w : WorldGenInterceptionRegistry.instance.decorationWatchers) {
            if (w.canDecorate(b, world, rand, x, z)) continue;
            return;
        }
        b.func_76728_a(world, rand, x, z);
    }

    public final class BlockSetData {
        public final Coordinate location;
        public final Block oldBlock;
        public final int oldMetadata;
        public final Block newBlock;
        public final int newMetadata;

        private BlockSetData(Coordinate c, Block old, int oldmeta, Block b, int meta) {
            this.location = c;
            this.oldBlock = old;
            this.oldMetadata = oldmeta;
            this.newBlock = b;
            this.newMetadata = meta;
        }

        public TileEntity getTileEntity(World world) {
            return this.location.getTileEntity((IBlockAccess)world);
        }

        public void revert(World world) {
            this.location.setBlock(world, this.oldBlock, this.oldMetadata, 2);
        }
    }

    public static interface DecorationWatcher {
        public boolean canDecorate(BiomeGenBase var1, World var2, Random var3, int var4, int var5);
    }

    public static interface IWGWatcher {
        public boolean canIWGRun(IWorldGenerator var1, Random var2, int var3, int var4, World var5, IChunkProvider var6, IChunkProvider var7);
    }

    public static interface InterceptionException {
        public boolean doesExceptionApply(World var1, int var2, int var3, int var4, Block var5, int var6);
    }

    public static interface BlockSetWatcher {
        public void onChunkGeneration(World var1, Map<Coordinate, BlockSetData> var2);
    }
}

