/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Base;

import Reika.ChromatiCraft.API.Interfaces.CustomCopyBehavior;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.RotaryCraft.API.Interfaces.Transducerable;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockMultiBlock<R>
extends Block
implements Transducerable,
CustomCopyBehavior {
    private final IIcon[] icons = new IIcon[this.getNumberTextures()];
    protected static final ForgeDirection[] dirs = ForgeDirection.values();

    public BlockMultiBlock(Material par2Material) {
        super(par2Material);
    }

    public abstract int getNumberTextures();

    public abstract R checkForFullMultiBlock(World var1, int var2, int var3, int var4, ForgeDirection var5, FilledBlockArray.BlockMatchFailCallback var6);

    public final void func_149695_a(World world, int x, int y, int z, Block idn) {
    }

    public final float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        float ret = super.func_149712_f(world, x, y, z);
        if (meta >= 8) {
            ret *= 4.0f;
        }
        return ret;
    }

    public final boolean func_149700_E() {
        return false;
    }

    public abstract void breakMultiBlock(World var1, int var2, int var3, int var4);

    public final void func_149689_a(World world, int x, int y, int z, EntityLivingBase e, ItemStack is) {
        R ret;
        if (!world.field_72995_K && this.canTriggerMultiBlockCheck(world, x, y, z, world.func_72805_g(x, y, z)) && e instanceof EntityPlayer && this.evaluate(ret = this.checkForFullMultiBlock(world, x, y, z, ReikaEntityHelper.getDirectionFromEntityLook(e, false), null))) {
            this.onCreateFullMultiBlock(world, x, y, z, ret);
        }
    }

    protected boolean evaluate(R ret) {
        return ret != null && (!(ret instanceof Boolean) || (Boolean)ret != false);
    }

    public final void func_149749_a(World world, int x, int y, int z, Block oldid, int oldmeta) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IInventory) {
            ReikaItemHelper.dropInventory(world, x, y, z);
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = dirs[i];
            int dx = x + dir.offsetX;
            int dy = y + dir.offsetY;
            int dz = z + dir.offsetZ;
            if (world.field_72995_K) continue;
            this.breakMultiBlock(world, dx, dy, dz);
        }
        super.func_149749_a(world, x, y, z, oldid, oldmeta);
    }

    protected abstract void onCreateFullMultiBlock(World var1, int var2, int var3, int var4, R var5);

    public abstract int getNumberVariants();

    public final IIcon func_149691_a(int s, int meta) {
        return this.icons[this.getItemTextureIndex(meta, s)];
    }

    public final void func_149651_a(IIconRegister ico) {
        for (int i = 0; i < this.getNumberTextures(); ++i) {
            this.icons[i] = ico.func_94245_a(this.getFullIconPath(i));
        }
    }

    public final void func_149666_a(Item it, CreativeTabs tab, List li) {
        for (int i = 0; i < this.getNumberVariants(); ++i) {
            li.add(new ItemStack(it, 1, i));
        }
    }

    protected abstract String getFullIconPath(int var1);

    public final IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int index = this.getTextureIndex(world, x, y, z, side, world.func_72805_g(x, y, z));
        index = Math.max(0, Math.min(this.getNumberTextures() - 1, index));
        return this.icons[index];
    }

    public abstract int getTextureIndex(IBlockAccess var1, int var2, int var3, int var4, int var5, int var6);

    public final int func_149692_a(int meta) {
        return meta & 7;
    }

    public abstract int getItemTextureIndex(int var1, int var2);

    public final ItemStack getPickBlock(MovingObjectPosition mov, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) & 7;
        return new ItemStack((Block)this, 1, meta);
    }

    public abstract boolean canTriggerMultiBlockCheck(World var1, int var2, int var3, int var4, int var5);

    protected abstract TileEntity getTileEntityForPosition(World var1, int var2, int var3, int var4);

    @Override
    public final boolean allowCopy(int meta) {
        return true;
    }

    @Override
    public final Block getBlock(int meta) {
        return this;
    }

    @Override
    public final int getMeta(int meta) {
        return meta % 8;
    }
}

