/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Base;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.ASM.InterfaceInjector;
import Reika.DragonAPI.Base.BlockTEBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Exception.MisuseException;
import Reika.DragonAPI.IO.CompoundSyncPacket;
import Reika.DragonAPI.Instantiable.BlockUpdateCallback;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.TimerMap;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.IO.SyncPacket;
import Reika.DragonAPI.Instantiable.RedstoneTracker;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.DataSync;
import Reika.DragonAPI.Interfaces.TileEntity.PartialInventory;
import Reika.DragonAPI.Interfaces.TileEntity.PartialTank;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaReflectionHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Lua.LuaMethod;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import li.cil.oc.api.Network;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Message;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.SidedEnvironment;
import li.cil.oc.api.network.Visibility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

@InterfaceInjector.Injectable(value={"dan200.computercraft.api.peripheral.IPeripheral", "li.cil.oc.api.network.Environment", "li.cil.oc.api.network.ManagedPeripheral"})
public abstract class TileEntityBase
extends TileEntity
implements CompoundSyncPacket.CompoundSyncPacketHandler {
    protected static final Random rand = new Random();
    private int pseudometa;
    protected boolean shutDown;
    protected String placer;
    protected UUID placerUUID;
    protected boolean fakePlaced;
    private int ticksExisted;
    private FakePlayer fakePlayer;
    private final StepTimer updateTimer;
    private final StepTimer fullSyncTimer;
    private boolean forceSync = true;
    private final TimerMap<TimerMap.TimerCallback> callbacks = new TimerMap();
    private long tileAge = 0L;
    private boolean lastRedstone;
    private boolean redstoneInput;
    private final TileEntity[] adjTEMap = new TileEntity[6];
    protected final ForgeDirection[] dirs = ForgeDirection.values();
    private final RedstoneTracker comparatorTracker = new RedstoneTracker();
    private final SyncPacket syncTag = new SyncPacket();
    private long lastTickCall = -1L;
    private boolean isNaturalTick = true;
    private boolean unharvestable = false;
    private boolean unmineable = false;
    private final HashMap<Integer, LuaMethod> luaMethods = new HashMap();
    private final HashMap<String, LuaMethod> methodNames = new HashMap();
    private final Object node = this.createNode();

    public abstract Block getTileEntityBlockID();

    public abstract void updateEntity(World var1, int var2, int var3, int var4, int var5);

    protected abstract void animateWithTick(World var1, int var2, int var3, int var4);

    public abstract int getRedstoneOverride();

    public TileEntityBase() {
        this.updateTimer = new StepTimer(this.getBlockUpdateDelay());
        this.updateTimer.randomizeTick(rand);
        this.fullSyncTimer = new StepTimer(1200);
        this.fullSyncTimer.randomizeTick(rand);
    }

    public final int getComparatorOverride() {
        return this.comparatorTracker.getValue();
    }

    public final boolean hasRedstoneSignal() {
        return this.redstoneInput;
    }

    public final void onBlockUpdate() {
        this.lastRedstone = this.redstoneInput;
        this.redstoneInput = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.redstoneInput && !this.lastRedstone) {
            this.onPositiveRedstoneEdge();
        }
        if (this.redstoneInput != this.lastRedstone) {
            ReikaPacketHelper.sendDataPacketWithRadius("DragonAPIData", APIPacketHandler.PacketIDs.REDSTONECHANGE.ordinal(), this, 32, this.redstoneInput ? 1 : 0, this.lastRedstone ? 1 : 0);
            this.syncAllData(false);
        }
        this.onAdjacentBlockUpdate();
    }

    protected void onAdjacentBlockUpdate() {
    }

    @SideOnly(value=Side.CLIENT)
    public final void onRedstoneChangedClientside(boolean redstone, boolean last) {
        if (redstone && !last) {
            this.onPositiveRedstoneEdge();
        }
    }

    protected void onPositiveRedstoneEdge() {
    }

    public boolean allowTickAcceleration() {
        return true;
    }

    public final int getTicksExisted() {
        return this.ticksExisted;
    }

    public final long getTileEntityAge() {
        return this.tileAge;
    }

    public int getPacketDelay() {
        return DragonOptions.SLOWSYNC.getState() ? 20 : 5;
    }

    public void animateItem() {
        if (this.field_145850_b == null) {
            this.animateWithTick(null, 0, 0, 0);
        }
    }

    public final boolean isPlacer(EntityPlayer ep) {
        if (this.placer == null || this.placerUUID == null || this.placer.isEmpty()) {
            return false;
        }
        return ep.func_70005_c_().equals(this.placer) && ep.func_110124_au().equals(this.placerUUID);
    }

    public final Block getTEBlock() {
        Block id = this.getTileEntityBlockID();
        if (id == Blocks.field_150350_a) {
            DragonAPICore.logError("TileEntity " + this + " tried to register ID 0!");
        }
        if (id == null) {
            DragonAPICore.logError(id + " is an invalid block ID for " + this + "!");
            return null;
        }
        return id;
    }

    public static final boolean isStandard8mReach(EntityPlayer ep, TileEntity te) {
        double dist = ReikaMathLibrary.py3d((double)te.field_145851_c + 0.5 - ep.field_70165_t, (double)te.field_145848_d + 0.5 - ep.field_70163_u, (double)te.field_145849_e + 0.5 - ep.field_70161_v);
        return dist <= 8.0;
    }

    public boolean isPlayerAccessible(EntityPlayer var1) {
        double dist = ReikaMathLibrary.py3d((double)this.field_145851_c + 0.5 - var1.field_70165_t, (double)this.field_145848_d + 0.5 - var1.field_70163_u, (double)this.field_145849_e + 0.5 - var1.field_70161_v);
        return dist <= 8.0 && this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    protected void writeSyncTag(NBTTagCompound NBT) {
        NBT.func_74768_a("meta", this.pseudometa);
        NBT.func_74757_a("lastredstone", this.lastRedstone);
        NBT.func_74757_a("thisredstone", this.redstoneInput);
    }

    protected void readSyncTag(NBTTagCompound NBT) {
        this.pseudometa = NBT.func_74762_e("meta");
        if (this.pseudometa > 15) {
            this.pseudometa = 15;
        }
        this.lastRedstone = NBT.func_74767_n("lastredstone");
        this.redstoneInput = NBT.func_74767_n("thisredstone");
    }

    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        this.writeSyncTag(NBT);
        if (this.placer != null && !this.placer.isEmpty()) {
            NBT.func_74778_a("place", this.placer);
        }
        if (this.placerUUID != null) {
            NBT.func_74778_a("placeUUID", this.placerUUID.toString());
        }
        if (ModList.OPENCOMPUTERS.isLoaded()) {
            this.saveOCNodes(NBT);
        }
        NBT.func_74757_a("no_drops", this.unharvestable);
        NBT.func_74757_a("no_mine", this.unmineable);
        NBT.func_74772_a("age_ticks", this.tileAge);
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    private void saveOCNodes(NBTTagCompound NBT) {
        if (this instanceof SidedEnvironment) {
            for (int i = 0; i < 6; ++i) {
                Node n = ((SidedEnvironment)this).sidedNode(this.dirs[i]);
                if (n == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                n.save(tag);
                NBT.func_74782_a("sided_node_" + i, (NBTBase)tag);
            }
        } else if (this.node != null) {
            ((Node)this.node).save(NBT);
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    private void loadOCNodes(NBTTagCompound NBT) {
        if (this instanceof SidedEnvironment) {
            for (int i = 0; i < 6; ++i) {
                Node n = ((SidedEnvironment)this).sidedNode(this.dirs[i]);
                if (n == null) continue;
                NBTTagCompound tag = NBT.func_74775_l("sided_node_" + i);
                n.load(tag);
            }
        } else if (this.node != null) {
            ((Node)this.node).load(NBT);
        }
    }

    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        this.readSyncTag(NBT);
        this.placer = NBT.func_74779_i("place");
        if (NBT.func_74764_b("placeUUID")) {
            this.placerUUID = UUID.fromString(NBT.func_74779_i("placeUUID"));
        }
        if (ModList.OPENCOMPUTERS.isLoaded()) {
            this.loadOCNodes(NBT);
        }
        this.unharvestable = NBT.func_74767_n("no_drops");
        this.unmineable = NBT.func_74767_n("no_mine");
        this.tileAge = NBT.func_74763_f("age_ticks");
    }

    public final boolean isUnMineable() {
        return this.unmineable;
    }

    public final boolean isUnHarvestable() {
        return this.unharvestable;
    }

    public final void setUnmineable(boolean nomine) {
        this.unmineable = nomine;
    }

    private void sendPacketToAllAround(S35PacketUpdateTileEntity p, int r) {
        if (!this.field_145850_b.field_72995_K) {
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB(this.field_145851_c, this.field_145848_d, this.field_145849_e).func_72314_b((double)r, (double)r, (double)r);
            List<EntityPlayerMP> li = ReikaPlayerAPI.getPlayersWithin(this.field_145850_b, box);
            for (EntityPlayerMP entityplayermp : li) {
                entityplayermp.field_71135_a.func_147359_a((Packet)p);
            }
        }
    }

    private void sendPacketToAll(S35PacketUpdateTileEntity p) {
        if (!this.field_145850_b.field_72995_K) {
            List<EntityPlayerMP> li = ReikaPlayerAPI.getPlayersWithin(this.field_145850_b, INFINITE_EXTENT_AABB);
            for (EntityPlayerMP entityplayermp : li) {
                entityplayermp.field_71135_a.func_147359_a((Packet)p);
            }
        }
    }

    public final void syncAllData(boolean fullNBT) {
        if (this.field_145850_b.field_72995_K) {
            ReikaPacketHelper.sendDataPacketWithRadius("DragonAPIData", APIPacketHandler.PacketIDs.TILESYNC.ordinal(), this, 512, fullNBT ? 1 : 0);
        } else {
            this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
            NBTTagCompound var1 = new NBTTagCompound();
            if (fullNBT) {
                this.func_145841_b(var1);
            }
            this.writeSyncTag(var1);
            if (fullNBT) {
                var1.func_74757_a("fullData", true);
            }
            S35PacketUpdateTileEntity p = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, var1);
            int r = this.getUpdatePacketRadius();
            if (r < 0 || r == Integer.MAX_VALUE) {
                this.sendPacketToAllAround(p, r);
            } else {
                this.sendPacketToAllAround(p, r);
            }
            this.onDataSync(fullNBT);
        }
        if (this.field_145850_b.func_72904_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.func_70296_d();
        }
    }

    private void syncTankData() {
        Collection<Field> c = ReikaReflectionHelper.getFields(this.getClass(), new ReikaReflectionHelper.TypeSelector(HybridTank.class));
    }

    protected void onDataSync(boolean fullNBT) {
    }

    public final Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeSyncTag(nbt);
        this.func_145841_b(nbt);
        nbt.func_74757_a("fullData", true);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, nbt);
    }

    private boolean shouldFullSync() {
        return this.forceSync;
    }

    public void forceFullSync() {
        this.forceSync = true;
    }

    @Override
    public final void handleCompoundSyncPacket(CompoundSyncPacket p) {
        if (!p.hasNoData()) {
            NBTTagCompound NBT = new NBTTagCompound();
            this.writeSyncTag(NBT);
            p.readForSync(this, NBT);
            this.readSyncTag(NBT);
        }
    }

    public final void onDataPacket(NetworkManager netManager, S35PacketUpdateTileEntity packet) {
        if (packet instanceof DataSync) {
            DataSync p = (DataSync)packet;
            if (!p.hasNoData()) {
                NBTTagCompound NBT = new NBTTagCompound();
                this.writeSyncTag(NBT);
                p.readForSync(this, NBT);
                this.readSyncTag(NBT);
            }
        } else {
            this.readSyncTag(packet.field_148860_e);
            if (packet.field_148860_e.func_74767_n("fullData")) {
                this.func_145839_a(packet.field_148860_e);
            }
        }
    }

    public final void setPlacer(EntityPlayer ep) {
        this.placer = ep.func_70005_c_();
        this.fakePlaced = ReikaPlayerAPI.isFake(ep);
        if (ep.func_146103_bH().getId() != null) {
            this.placerUUID = ep.func_146103_bH().getId();
        }
        this.onSetPlacer(ep);
    }

    protected void onSetPlacer(EntityPlayer ep) {
    }

    public final String getPlacerName() {
        return this.placer;
    }

    public final UUID getPlacerID() {
        return this.placerUUID;
    }

    public final EntityPlayer getPlacer() {
        if (this.placer == null || this.placer.isEmpty()) {
            return null;
        }
        EntityPlayer ep = this.field_145850_b.func_72924_a(this.placer);
        return ep != null ? ep : this.getFakePlacer();
    }

    public final EntityPlayerMP getServerPlacer() {
        if (this.field_145850_b.field_72995_K) {
            throw new MisuseException("Cannot get the serverside player on the client!");
        }
        EntityPlayer ep = this.getPlacer();
        if (ep instanceof EntityPlayerMP) {
            return (EntityPlayerMP)ep;
        }
        if (!ReikaPlayerAPI.isFake(ep)) {
            throw new MisuseException("Cannot get the serverside player on the client!");
        }
        return null;
    }

    public final EntityPlayer getFakePlacer() {
        if (this.placer == null || this.placer.isEmpty()) {
            return null;
        }
        if (this.field_145850_b.field_72995_K) {
            return null;
        }
        if (this.fakePlayer == null) {
            this.fakePlayer = ReikaPlayerAPI.getFakePlayerByNameAndUUID((WorldServer)this.field_145850_b, this.placer, this.placerUUID);
        }
        return this.fakePlayer;
    }

    public boolean isIDTEMatch() {
        World world = this.field_145850_b;
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        Block b = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (b == Blocks.field_150350_a) {
            return false;
        }
        if (!b.hasTileEntity(meta)) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return false;
        }
        if (!(te instanceof TileEntityBase)) {
            return false;
        }
        TileEntityBase tb = (TileEntityBase)te;
        return b == tb.getTileEntityBlockID();
    }

    public final int getPseudoMeta() {
        return this.pseudometa;
    }

    public final int func_145832_p() {
        return this.getPseudoMeta();
    }

    public final void setBlockMetadata(int meta) {
        this.pseudometa = meta;
    }

    public final boolean isInWorld() {
        return this.field_145850_b != null;
    }

    public final Block func_145838_q() {
        if (this.field_145854_h != null) {
            return this.field_145854_h;
        }
        if (!this.isInWorld()) {
            this.field_145854_h = this.getTileEntityBlockID();
            return this.field_145854_h;
        }
        this.field_145854_h = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.field_145854_h;
    }

    public final int getRealBlockMetadata() {
        if (this.field_145847_g != -1) {
            return this.field_145847_g;
        }
        if (!this.isInWorld()) {
            return 0;
        }
        this.field_145847_g = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.field_145847_g;
    }

    public final void func_145845_h() {
        long time = this.field_145850_b.func_82737_E();
        boolean bl = this.isNaturalTick = time != this.lastTickCall;
        if (!this.isNaturalTick && !this.allowTickAcceleration()) {
            return;
        }
        this.lastTickCall = time;
        if (this.shouldRunUpdateCode()) {
            try {
                if (this.isNaturalTick) {
                    this.updateTileEntity();
                }
                this.updateEntity(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p());
            }
            catch (IndexOutOfBoundsException e) {
                this.writeError(e);
            }
            catch (ArithmeticException e) {
                this.writeError(e);
            }
            catch (NullPointerException e) {
                this.writeError(e);
            }
            catch (ClassCastException e) {
                this.writeError(e);
            }
            catch (IllegalArgumentException e) {
                this.writeError(e);
            }
        }
        if (this.isNaturalTick) {
            if (this.getTicksExisted() < 20 && this.getTicksExisted() % 4 == 0) {
                this.syncAllData(true);
            }
            this.fullSyncTimer.update();
            if (this.fullSyncTimer.checkCap()) {
                this.forceFullSync();
            }
            if (this.shouldSendSyncPackets() && (this.shouldSendSyncPacket() || this.shouldFullSync())) {
                this.sendSyncPacket();
            }
            this.callbacks.tick();
            ++this.ticksExisted;
            ++this.tileAge;
        }
    }

    protected boolean isTickingNaturally() {
        return this.isNaturalTick;
    }

    public final void triggerBlockUpdate() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public final void scheduleBlockUpdate(int ticks) {
        this.scheduleCallback(new BlockUpdateCallback(this), ticks);
    }

    public final void scheduleCallback(TimerMap.TimerCallback c, int delay) {
        this.callbacks.put(c, delay);
    }

    private boolean shouldSendSyncPacket() {
        return this.field_145850_b != null && this.field_145850_b.func_82737_E() % (long)this.getPacketDelay() == 0L;
    }

    private void sendSyncPacket() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeSyncTag(nbt);
        this.syncTag.setData(this, this.shouldFullSync(), nbt);
        if (!this.syncTag.isEmpty()) {
            int r = this.shouldFullSync() ? 128 : this.getUpdatePacketRadius();
            int dim = this.field_145850_b.field_73011_w.field_76574_g;
            this.sendPacketToAllAround(this.syncTag, r);
        }
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        this.onSync();
        this.forceSync = false;
    }

    protected void onSync() {
    }

    public int getUpdatePacketRadius() {
        return 32;
    }

    protected boolean shouldRunUpdateCode() {
        return true;
    }

    protected final boolean shouldSendSyncPackets() {
        return !this.field_145850_b.field_72995_K;
    }

    public void writeError(Throwable e) {
        if (DragonOptions.CHATERRORS.getState()) {
            ReikaChatHelper.write(this + " [" + FMLCommonHandler.instance().getEffectiveSide() + "] is throwing " + e.getClass() + " on update: " + e.getMessage());
            ReikaChatHelper.write(Arrays.toString(e.getStackTrace()));
            ReikaChatHelper.write("");
        }
        DragonAPICore.logError(this + " [" + FMLCommonHandler.instance().getEffectiveSide() + "] is throwing " + e.getClass() + " on update: " + e.getMessage());
        e.printStackTrace();
        DragonAPICore.log("");
    }

    private final void updateTileEntity() {
        this.animateWithTick(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.getTicksExisted() == 0) {
            for (int i = 0; i < 6; ++i) {
                this.updateCache(this.dirs[i]);
            }
            if (ModList.OPENCOMPUTERS.isLoaded()) {
                this.initOCNodes();
            }
            this.onFirstTick(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.redstoneInput = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (!this.field_145850_b.field_72995_K && this.getTicksExisted() % 8 == 0) {
            this.comparatorTracker.update(this);
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    private void initOCNodes() {
        if (this instanceof SidedEnvironment) {
            boolean flag = true;
            for (int i = 0; i < 6; ++i) {
                Node n = ((SidedEnvironment)this).sidedNode(this.dirs[i]);
                flag |= n != null && n.network() != null;
            }
            Network.joinOrCreateNetwork((TileEntity)this);
        } else if (this.node != null && ((Node)this.node).network() == null) {
            Network.joinOrCreateNetwork((TileEntity)this);
        }
    }

    protected void onFirstTick(World world, int x, int y, int z) {
    }

    public Random getRandom() {
        return rand;
    }

    public final boolean isSameTile(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass() == this.getClass()) {
            TileEntity te = (TileEntity)o;
            if (te.field_145850_b == null && this.field_145850_b != null || this.field_145850_b == null && te.field_145850_b != null) {
                return false;
            }
            return te.field_145850_b.field_73011_w.field_76574_g == this.field_145850_b.field_73011_w.field_76574_g && this.matchCoords(te) && te.func_145837_r() == this.func_145837_r();
        }
        return false;
    }

    public final boolean equals(Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private boolean matchCoords(TileEntity te) {
        return te.field_145851_c == this.field_145851_c && te.field_145848_d == this.field_145848_d && te.field_145849_e == this.field_145849_e;
    }

    public String toString() {
        String base = "Tile Entity " + this.getTEName();
        return base + (this.isInWorld() ? " @ DIM" + this.field_145850_b.field_73011_w.field_76574_g + ": " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e : " (item)");
    }

    protected abstract String getTEName();

    public final int getBlockUpdateDelay() {
        return 20;
    }

    public abstract boolean shouldRenderInPass(int var1);

    public Side getSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    protected final void delete() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return ReikaAABBHelper.getBlockAABB(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public final TileEntity getAdjacentTileEntity(ForgeDirection dir) {
        if (this.cachesTEs()) {
            return this.getCachedTE(dir);
        }
        int dx = this.field_145851_c + dir.offsetX;
        int dy = this.field_145848_d + dir.offsetY;
        int dz = this.field_145849_e + dir.offsetZ;
        if (!ReikaWorldHelper.tileExistsAt(this.field_145850_b, dx, dy, dz)) {
            return null;
        }
        return this.field_145850_b.func_147438_o(dx, dy, dz);
    }

    public final WorldLocation getAdjacentLocation(ForgeDirection dir) {
        return new WorldLocation(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
    }

    public final boolean isChunkLoaded() {
        return this.field_145850_b.func_72904_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public final boolean isChunkLoadedOnSide(ForgeDirection dir) {
        return this.field_145850_b.func_72904_c(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
    }

    public final TileEntity getTileEntity(int x, int y, int z) {
        if (!ReikaWorldHelper.tileExistsAt(this.field_145850_b, x, y, z)) {
            return null;
        }
        return this.field_145850_b.func_147438_o(x, y, z);
    }

    public final boolean isDirectlyAdjacent(int x, int y, int z) {
        return Math.abs(x - this.field_145851_c) + Math.abs(y - this.field_145848_d) + Math.abs(z - this.field_145849_e) == 1;
    }

    private boolean cachesTEs() {
        return this.func_145838_q() instanceof BlockTEBase;
    }

    private TileEntity getCachedTE(ForgeDirection dir) {
        return dir != null ? this.adjTEMap[dir.ordinal()] : null;
    }

    public final void updateCache(ForgeDirection dir) {
        TileEntity te;
        this.adjTEMap[dir.ordinal()] = te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
        this.onPlacedNextToThis(te, dir);
    }

    protected void onPlacedNextToThis(TileEntity te, ForgeDirection dir) {
    }

    public final int getObjectID() {
        return System.identityHashCode(this);
    }

    public double func_145833_n() {
        switch (ReikaRenderHelper.getRenderDistance()) {
            case FAR: {
                return 6144.0;
            }
            case NORMAL: {
                return 3364.0;
            }
            case SHORT: {
                return 1024.0;
            }
            case TINY: {
                return 256.0;
            }
        }
        return 4096.0;
    }

    public String[] getMethodNames() {
        ArrayList<LuaMethod> li = new ArrayList<LuaMethod>();
        Collection<LuaMethod> all = LuaMethod.getMethods();
        for (LuaMethod l : all) {
            if (!l.isValidFor(this)) continue;
            li.add(l);
        }
        String[] s = new String[li.size()];
        for (int i = 0; i < s.length; ++i) {
            LuaMethod l = (LuaMethod)li.get(i);
            s[i] = l.displayName;
            this.luaMethods.put(i, l);
            this.methodNames.put(l.displayName, l);
        }
        return s;
    }

    @DependentMethodStripper.ModDependent(value={ModList.COMPUTERCRAFT})
    public boolean equals(IPeripheral other) {
        return other == this;
    }

    @DependentMethodStripper.ModDependent(value={ModList.COMPUTERCRAFT})
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        return this.luaMethods.containsKey(method) ? LuaMethod.invokeCC(this.luaMethods.get(method), this, arguments) : null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.COMPUTERCRAFT})
    public void attach(IComputerAccess computer) {
    }

    @DependentMethodStripper.ModDependent(value={ModList.COMPUTERCRAFT})
    public void detach(IComputerAccess computer) {
    }

    public String getType() {
        return this.getClass().getSimpleName().substring("TileEntity".length());
    }

    public final String getName() {
        return this.getTEName();
    }

    public String getComponentName() {
        return this.getType();
    }

    public String[] methods() {
        return this.getMethodNames();
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        Object[] objs = new Object[args.count()];
        for (int i = 0; i < objs.length; ++i) {
            objs[i] = args.checkAny(i);
            if (!(objs[i] instanceof byte[])) continue;
            objs[i] = new String((byte[])objs[i]);
        }
        return this.methodNames.containsKey(method) ? LuaMethod.invokeOC(this.methodNames.get(method), this, objs) : null;
    }

    public final void onChunkUnload() {
        super.onChunkUnload();
        for (int i = 0; i < 6; ++i) {
            this.adjTEMap[i] = null;
        }
        if (ModList.OPENCOMPUTERS.isLoaded()) {
            this.unloadOCNodes();
        }
        this.onInvalidateOrUnload(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
    }

    public final void func_145843_s() {
        super.func_145843_s();
        for (int i = 0; i < 6; ++i) {
            this.adjTEMap[i] = null;
        }
        if (ModList.OPENCOMPUTERS.isLoaded()) {
            this.unloadOCNodes();
        }
        this.onInvalidateOrUnload(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    private void unloadOCNodes() {
        if (this.node != null) {
            ((Node)this.node).remove();
        }
        if (this instanceof SidedEnvironment) {
            for (int i = 0; i < 6; ++i) {
                Node n = ((SidedEnvironment)this).sidedNode(this.dirs[i]);
                if (n == null) continue;
                n.remove();
            }
        }
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
    }

    private Object createNode() {
        if (!ModList.OPENCOMPUTERS.isLoaded()) {
            return null;
        }
        if (DragonOptions.DIRECTOC.getState()) {
            return Network.newNode((Environment)((Environment)this), (Visibility)Visibility.Network).withComponent(this.getType(), this.getOCNetworkVisibility()).create();
        }
        return Network.newNode((Environment)((Environment)this), (Visibility)Visibility.None).create();
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    public Visibility getOCNetworkVisibility() {
        return Visibility.Network;
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    public final Node node() {
        return (Node)this.node;
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    public void onConnect(Node node) {
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    public void onDisconnect(Node node) {
    }

    @DependentMethodStripper.ModDependent(value={ModList.OPENCOMPUTERS})
    public void onMessage(Message message) {
    }

    public final boolean hasAnInventory() {
        return this instanceof PartialInventory ? ((PartialInventory)((Object)this)).hasInventory() : this instanceof IInventory;
    }

    public final boolean hasATank() {
        return this instanceof PartialTank ? ((PartialTank)((Object)this)).hasTank() : this instanceof IFluidHandler;
    }

    public final int getAmbientTemperature() {
        return ReikaWorldHelper.getAmbientTemperatureAt(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

