/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Base;

import Reika.DragonAPI.Auxiliary.Trackers.ModLockController;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.IO.ReikaImageLoader;
import Reika.DragonAPI.Instantiable.Rendering.StructureRenderer;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityRenderBase
extends TileEntitySpecialRenderer {
    protected final ForgeDirection[] dirs = ForgeDirection.values();
    private final HashMap<String, String> textureOverrides = new HashMap();

    public final boolean isValidMachineRenderPass(TileEntityBase te) {
        if (!te.isInWorld() || StructureRenderer.isRenderingTiles()) {
            return true;
        }
        if (!ModLockController.instance.verify(this.getOwnerMod())) {
            return false;
        }
        int pass = MinecraftForgeClient.getRenderPass();
        return pass == 0;
    }

    protected abstract boolean doRenderModel(TileEntityBase var1);

    public abstract String getTextureFolder();

    public final int bindTextureByName(String tex) {
        String over = this.textureOverrides.get(tex);
        if (over != null) {
            return ReikaTextureHelper.bindTexture(this.getModClass(), over);
        }
        if (this.loadXmasTextures()) {
            String xmas = tex.replace(".png", "").replace("_xmas", "") + "_xmas.png";
            BufferedImage ret = ReikaImageLoader.readImage(this.getModClass(), xmas, null);
            String bind = ret != null && ret != ReikaImageLoader.getMissingTex() ? xmas : tex;
            this.textureOverrides.put(tex, bind);
            return this.bindTextureByName(bind);
        }
        return ReikaTextureHelper.bindTexture(this.getModClass(), tex);
    }

    protected boolean loadXmasTextures() {
        return false;
    }

    public final int bindImageByName(String img) {
        return ReikaTextureHelper.bindTexture(this.getModClass(), this.getTextureFolder() + img);
    }

    protected abstract DragonAPIMod getOwnerMod();

    protected abstract Class getModClass();

    protected final FontRenderer getFontRenderer() {
        return this.func_147498_b() != null ? this.func_147498_b() : Minecraft.func_71410_x().field_71466_p;
    }

    public abstract void func_147500_a(TileEntity var1, double var2, double var4, double var6, float var8);
}

