/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.RelayInventory;
import Reika.DragonAPI.Instantiable.Worldgen.LootController;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.gen.structure.StructureNetherBridgePieces;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.util.ForgeDirection;

public class GenLootCommand
extends DragonCommandBase {
    public void func_71515_b(ICommandSender ics, String[] args) {
        EntityPlayerMP ep = GenLootCommand.func_71521_c((ICommandSender)ics);
        if (args.length > 0) {
            Object inv = this.getInventory((EntityPlayer)ep);
            if (inv != null) {
                if (args.length == 3 && args[1].equalsIgnoreCase("preset")) {
                    if (inv instanceof IInventory) {
                        try {
                            Presets p = Presets.valueOf(args[2].toUpperCase(Locale.ENGLISH));
                            p.generate(DragonAPICore.rand, (IInventory)inv);
                        }
                        catch (IllegalArgumentException e) {
                            GenLootCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Preset '" + args[2] + "' does not exist. Options: " + Arrays.toString((Object[])Presets.values()));
                        }
                    } else {
                        GenLootCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Presets only work with inventory targets.");
                    }
                } else {
                    WeightedRandomChestContent[] types = ChestGenHooks.getItems((String)args[0], (Random)ep.func_70681_au());
                    if (types.length == 0) {
                        GenLootCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Loot table " + args[0] + " is empty.");
                    } else {
                        int count = ChestGenHooks.getCount((String)args[0], (Random)ep.func_70681_au());
                        int tries = args.length > 1 && ReikaJavaLibrary.isValidInteger(args[1]) ? Integer.parseInt(args[1]) : 1;
                        for (int i = 0; i < tries; ++i) {
                            this.addItems(ics, (EntityPlayer)ep, inv, args[0], types, count);
                        }
                    }
                }
            } else {
                GenLootCommand.sendChatToSender(ics, EnumChatFormatting.RED + "No selected inventory.");
            }
        } else {
            try {
                Field f = ChestGenHooks.class.getDeclaredField("chestInfo");
                f.setAccessible(true);
                HashMap map = (HashMap)f.get(null);
                GenLootCommand.sendChatToSender(ics, EnumChatFormatting.RED + "You must specify a loot table.");
                GenLootCommand.sendChatToSender(ics, "Valid types: " + map.keySet());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Object getInventory(EntityPlayer ep) {
        MovingObjectPosition mov = ReikaPlayerAPI.getLookedAtBlock(ep, 5.0, false);
        if (mov != null) {
            TileEntity te = ep.field_70170_p.func_147438_o(mov.field_72311_b, mov.field_72312_c, mov.field_72309_d);
            if (InterfaceCache.GRIDHOST.instanceOf(te)) {
                return te;
            }
            if (te instanceof IInventory) {
                return te;
            }
        }
        return ReikaPlayerAPI.getLookedAtEntity(ep, 5.0, 0.25);
    }

    private void addItems(ICommandSender ics, EntityPlayer ep, Object inv, String type, WeightedRandomChestContent[] types, int count) {
        if (InterfaceCache.GRIDHOST.instanceOf(inv)) {
            this.handleAE(ep, ep.func_70681_au(), types, (IGridHost)inv, count);
            GenLootCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "Generated loot type " + type + " in ME System @ " + new Coordinate((TileEntity)inv));
        } else if (inv instanceof EntityMinecartChest) {
            WeightedRandomChestContent.func_76293_a((Random)ep.func_70681_au(), (WeightedRandomChestContent[])types, (IInventory)((EntityMinecartChest)inv), (int)count);
            GenLootCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "Generated loot type " + type + " in minecart @ " + new Coordinate((Entity)inv));
        } else if (inv instanceof IInventory) {
            WeightedRandomChestContent.func_76293_a((Random)ep.func_70681_au(), (WeightedRandomChestContent[])types, (IInventory)((IInventory)inv), (int)count);
            GenLootCommand.sendChatToSender(ics, EnumChatFormatting.GREEN + "Generated loot type " + type + " in chest @ " + new Coordinate((TileEntity)inv));
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    private void handleAE(EntityPlayer ep, Random rand, WeightedRandomChestContent[] types, IGridHost te, int count) {
        RelayInventory relay = new RelayInventory(300);
        WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])types, (IInventory)relay, (int)count);
        IGridNode node = null;
        for (int i = 0; i < 6 && node == null; ++i) {
            node = te.getGridNode(ForgeDirection.VALID_DIRECTIONS[i]);
        }
        if (node == null) {
            return;
        }
        MESystemReader me = new MESystemReader(node, ep);
        for (ItemStack is : relay.getItems()) {
            me.addItem(is, false);
        }
    }

    @Override
    public String getCommandString() {
        return "genloot";
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }

    public static enum Presets {
        DUNGEON(LootController.Location.DUNGEON.tag),
        MINESHAFT(LootController.Location.MINESHAFT.tag),
        VILLAGE(LootController.Location.VILLAGE.tag),
        JUNGLE(LootController.Location.JUNGLE_PUZZLE.tag),
        PYRAMID(LootController.Location.PYRAMID.tag),
        NETHER(null);

        private final ChestGenHooks location;

        private Presets(String s) {
            this.location = s != null ? ChestGenHooks.getInfo((String)s) : null;
        }

        public void generate(Random rand, IInventory inv) {
            int count;
            WeightedRandomChestContent[] items;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                inv.func_70299_a(i, null);
            }
            if (this == NETHER) {
                items = StructureNetherBridgePieces.Piece.field_111019_a;
                count = 2 + rand.nextInt(4);
            } else {
                items = this.location.getItems(rand);
                count = this.location.getCount(rand);
            }
            WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])items, (IInventory)inv, (int)count);
        }
    }
}

