/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.oredict.OreDictionary;

public class OreDumpCommand
extends DragonCommandBase {
    public void func_71515_b(ICommandSender ics, String[] args) {
        if (args.length != 2) {
            OreDumpCommand.sendChatToSender(ics, EnumChatFormatting.RED + "Invalid arguments. Use /" + this.getCommandString() + " <tag> <side>.");
            return;
        }
        String type = args[0];
        Side side = null;
        try {
            side = Side.valueOf((String)args[1].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(EnumChatFormatting.RED + "Invalid side. Use one of the following: ");
            for (int i = 0; i < Side.values().length; ++i) {
                sb.append("'");
                sb.append(Side.values()[i].name().toLowerCase(Locale.ENGLISH));
                sb.append("'");
                if (i >= Side.values().length - 1) continue;
                sb.append(", ");
            }
            sb.append(".");
            OreDumpCommand.sendChatToSender(ics, sb.toString());
            return;
        }
        OreDumpCommand.sendChatToSender(ics, "Found Items for tag '" + type + "':");
        this.perform(side, ics, type);
    }

    @Override
    public String getCommandString() {
        return "dumpore";
    }

    @Override
    protected boolean isAdminOnly() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void dumpClientside(String id) {
        ReikaChatHelper.writeString("[CLIENT]");
        for (ItemStack is : OreDumpCommand.getData(id)) {
            ReikaChatHelper.writeString(OreDumpCommand.fullID(is));
        }
    }

    private void perform(Side side, ICommandSender ics, String type) {
        switch (side) {
            case CLIENT: {
                this.sendPacket(OreDumpCommand.func_71521_c((ICommandSender)ics), type);
                break;
            }
            case SERVER: {
                for (ItemStack is : OreDumpCommand.getData(type)) {
                    OreDumpCommand.sendChatToSender(ics, OreDumpCommand.fullID(is));
                }
                break;
            }
        }
    }

    private void sendPacket(EntityPlayerMP ep, String tag) {
        ReikaPacketHelper.sendStringPacket("DragonAPIData", APIPacketHandler.PacketIDs.OREDUMP.ordinal(), tag, new PacketTarget.PlayerTarget(ep));
    }

    private static List<ItemStack> getData(String id) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>(OreDictionary.getOres((String)id));
        ReikaItemHelper.sortItems(li);
        return li;
    }

    private static final String fullID(ItemStack is) {
        if (is == null) {
            return "[null]";
        }
        if (is.func_77973_b() == null) {
            return "[null-item stack]";
        }
        String n = Item.field_150901_e.func_148750_c((Object)is.func_77973_b());
        n = n.substring(n.indexOf(58) + 1);
        String p1 = n + "@" + is.func_77960_j();
        String p2 = "nbt={" + is.field_77990_d + "};";
        String p3 = "mod=[" + ReikaItemHelper.getRegistrantMod(is) + "]";
        return p1 + "; " + p2 + " " + p3;
    }
}

