/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Command;

import Reika.DragonAPI.Command.DragonCommandBase;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import java.util.ArrayList;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.IEntitySelector;
import net.minecraft.command.server.CommandBlockLogic;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class SelectiveKillCommand
extends DragonCommandBase {
    @Override
    public String getCommandString() {
        return "selectivekill";
    }

    public void func_71515_b(ICommandSender ics, String[] args) {
        World world = null;
        if (ics instanceof CommandBlockLogic) {
            world = ((CommandBlockLogic)ics).func_130014_f_();
        } else {
            EntityPlayerMP ep = SelectiveKillCommand.func_71521_c((ICommandSender)ics);
            world = ep.field_70170_p;
        }
        if (args.length == 2) {
            String c = args[0];
            int percentage = ReikaJavaLibrary.safeIntParse(args[1]);
            if (percentage == 0) {
                String sg = EnumChatFormatting.RED + "Invalid percentage.";
                SelectiveKillCommand.sendChatToSender(ics, sg);
                return;
            }
            int amt = this.killEntities(world, c, percentage);
            String sg = percentage < 0 ? EnumChatFormatting.GREEN + "Killed all but " + amt + " of " + c + "." : EnumChatFormatting.GREEN + "Killed " + amt + " of " + c + ".";
            SelectiveKillCommand.sendChatToSender(ics, sg);
        } else {
            String sg = EnumChatFormatting.RED + "You must specify an entity class and a kill percentage!";
            String sg2 = "'EntityAnimal', 'EntityMob', 'EntityCreature', and 'EntityLiving' are accepted parent classes.";
            SelectiveKillCommand.sendChatToSender(ics, sg);
            SelectiveKillCommand.sendChatToSender(ics, sg2);
        }
    }

    private int killEntities(World world, String name, int percentage) {
        ArrayList<Entity> li = new ArrayList<Entity>(world.field_72996_f);
        IEntitySelector sel = this.getFilter(name);
        li.removeIf(e -> !sel.func_82704_a(e));
        if (li.isEmpty()) {
            return 0;
        }
        int killed = 0;
        if (percentage < 0) {
            for (int i = 0; i < percentage && !li.isEmpty(); ++i) {
                li.remove(world.field_73012_v.nextInt(li.size()));
            }
            percentage = 100;
        }
        for (Entity e2 : li) {
            if (!ReikaRandomHelper.doWithChance(percentage)) continue;
            e2.func_70106_y();
            ++killed;
        }
        return killed;
    }

    private IEntitySelector getFilter(String name) {
        switch (name) {
            case "Tamed": {
                return e -> ReikaEntityHelper.isTamed(e);
            }
            case "EntityMob": {
                return e -> e instanceof EntityMob && !ReikaEntityHelper.isTamed(e);
            }
            case "EntityAnimal": {
                return e -> e instanceof EntityAnimal && !ReikaEntityHelper.isTamed(e);
            }
            case "EntityCreature": {
                return e -> e instanceof EntityCreature && !ReikaEntityHelper.isTamed(e);
            }
            case "EntityLiving": {
                return e -> e instanceof EntityLiving && !ReikaEntityHelper.isTamed(e);
            }
            case "Entity": {
                return e -> !(e instanceof EntityPlayer);
            }
        }
        return e -> e.getClass().getSimpleName().equals(name);
    }

    @Override
    protected boolean isAdminOnly() {
        return true;
    }
}

