/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Extras;

import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.IO.Shaders.ShaderHook;
import Reika.DragonAPI.IO.Shaders.ShaderProgram;
import Reika.DragonAPI.IO.Shaders.ShaderRegistry;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public class ReikaShader
implements ShaderHook,
TickRegistry.TickHandler {
    public static final ReikaShader instance = new ReikaShader();
    private ShaderProgram stencilShader;
    private ShaderProgram effectShader;
    private ReikaRenderHelper.ScratchFramebuffer stencil;
    private final ArrayList<ShaderPoint> points = new ArrayList();
    private boolean rendering;
    private float intensity;

    private ReikaShader() {
    }

    public void register() {
        this.stencilShader = ShaderRegistry.createShader(DragonAPIInit.instance, "reika_stencil", DragonAPICore.class, "Resources/", ShaderRegistry.ShaderDomain.ENTITY).setEnabled(false);
        this.effectShader = ShaderRegistry.createShader(DragonAPIInit.instance, "reika_effect", DragonAPICore.class, "Resources/", ShaderRegistry.ShaderDomain.GLOBALNOGUI).setEnabled(false);
        TickRegistry.instance.registerTickHandler(this);
        this.stencil = new ReikaRenderHelper.ScratchFramebuffer(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d, true);
        this.stencil.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.effectShader.setHook(this);
        this.stencilShader.setHook(this);
    }

    public void updatePosition(EntityPlayer ep) {
        ShaderPoint p;
        if (this.rendering) {
            return;
        }
        if (ep == Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        boolean flag = true;
        long time = ep.field_70170_p.func_82737_E();
        Iterator<ShaderPoint> it = this.points.iterator();
        while (it.hasNext()) {
            p = it.next();
            if (p.position.equals(ep.field_70165_t, ep.field_70163_u, ep.field_70161_v)) {
                p.refresh(time);
                flag = false;
            }
            if (!p.tick(time)) continue;
            it.remove();
        }
        if (flag) {
            p = new ShaderPoint(ep, this.points.isEmpty() ? null : this.points.get(0));
            this.points.add(0, p);
        }
    }

    public void prepareRender(EntityPlayer ep) {
        Minecraft mc = Minecraft.func_71410_x();
        if (ep == mc.field_71439_g) {
            return;
        }
        if (this.points.isEmpty()) {
            return;
        }
        GL11.glPushMatrix();
        double dist = ep.func_70068_e((Entity)mc.field_71439_g);
        if (mc.field_71474_y.field_74320_O > 0) {
            dist += ReikaRenderHelper.thirdPersonDistance;
        }
        float ptick = ReikaRenderHelper.getPartialTickTime();
        double px = ep.field_70142_S + (ep.field_70165_t - ep.field_70142_S) * (double)ptick;
        double py = ep.field_70137_T + (ep.field_70163_u - ep.field_70137_T) * (double)ptick;
        double pz = ep.field_70136_U + (ep.field_70161_v - ep.field_70136_U) * (double)ptick;
        GL11.glTranslated((double)(RenderManager.field_78725_b - ep.field_70165_t), (double)(RenderManager.field_78726_c - ep.field_70163_u), (double)(RenderManager.field_78723_d - ep.field_70161_v));
        GL11.glTranslated((double)0.0, (double)-0.8, (double)0.0);
        GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
        this.rendering = true;
        boolean flag = false;
        for (ShaderPoint pt : this.points) {
            float f = pt.getIntensity();
            if (!(f > 0.0f)) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("distance", dist);
            map.put("age", Float.valueOf((float)pt.age / 30.0f));
            DecimalPosition p = pt.position;
            map.put("dx", p.xCoord - px);
            map.put("dy", p.yCoord - py);
            map.put("dz", p.zCoord - pz);
            this.stencilShader.addFocus((Entity)ep);
            this.stencilShader.modifyLastCompoundFocus(f, map);
            flag = true;
        }
        this.stencilShader.setEnabled(flag);
        this.effectShader.setEnabled(flag);
        this.intensity = flag && this.points.get(0).speed > 0.08 ? Math.min(1.0f, this.intensity * 1.02f + 0.005f) : Math.max(0.0f, this.intensity * 0.99f - 0.02f);
        this.effectShader.setIntensity(this.intensity);
        this.rendering = false;
        GL11.glPopMatrix();
    }

    public void render(Minecraft mc) {
        this.stencil.clear();
        this.stencil.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.stencil.func_147613_a(mc.field_71443_c, mc.field_71440_d);
        ReikaRenderHelper.renderFrameBufferToItself(this.stencil, mc.field_71443_c, mc.field_71440_d, this.stencilShader);
        ReikaRenderHelper.setRenderTarget(mc.func_147110_a());
        if (this.stencilShader.isEnabled()) {
            // empty if block
        }
        this.stencilShader.clearFoci();
        this.stencilShader.setEnabled(false);
    }

    public Framebuffer getStencil() {
        return this.stencil;
    }

    @Override
    public void onPreRender(ShaderProgram s) {
        if (s == this.effectShader) {
            int base = GL11.glGetInteger((int)34016);
            int offset = 2;
            GL13.glActiveTexture((int)(base + offset));
            s.setField("stencilTex", offset);
            s.setField("stencilVal", Float.valueOf(offset));
            GL11.glBindTexture((int)3553, (int)this.stencil.field_147617_g);
            GL13.glActiveTexture((int)base);
            GL11.glBindTexture((int)3553, (int)Minecraft.func_71410_x().func_147110_a().field_147617_g);
        }
    }

    @Override
    public void onPostRender(ShaderProgram s) {
        if (s == this.effectShader) {
            s.setEnabled(false);
        }
    }

    @Override
    public void updateEnabled(ShaderProgram s) {
    }

    @Override
    public void tick(TickRegistry.TickType type, Object ... tickData) {
        EntityPlayer ep = (EntityPlayer)tickData[0];
        if (ep.field_70170_p.field_72995_K && ReikaPlayerAPI.isReika(ep)) {
            this.updatePosition(ep);
        }
    }

    @Override
    public EnumSet<TickRegistry.TickType> getType() {
        return EnumSet.of(TickRegistry.TickType.PLAYER);
    }

    @Override
    public boolean canFire(TickEvent.Phase p) {
        return p == TickEvent.Phase.END;
    }

    @Override
    public String getLabel() {
        return "reikashader";
    }

    private static class ShaderPoint {
        private static final int LIFESPAN = 30;
        private final DecimalPosition position;
        private final double speed;
        private long creation;
        private int age;

        private ShaderPoint(EntityPlayer ep, ShaderPoint last) {
            this.position = new DecimalPosition((Entity)ep);
            this.creation = ep.field_70170_p.func_82737_E();
            double vx = ep.field_70159_w;
            double vy = ep.field_70181_x + 0.0784000015258789;
            double vz = ep.field_70179_y;
            double v = ReikaMathLibrary.py3d(vx, vy, vz);
            if (last != null) {
                v += last.position.getDistanceTo(this.position);
            }
            this.speed = v;
        }

        public void refresh(long world) {
            this.age = 0;
            this.creation = world;
        }

        public boolean tick(long world) {
            ++this.age;
            long val = Math.max((long)this.age, world - this.creation);
            return val >= 30L;
        }

        private float getAgeFactor() {
            return 1.0f - (float)this.age / 30.0f;
        }

        public float getIntensity() {
            return Math.min(1.0f, (float)Math.pow((double)this.getAgeFactor() * this.speed * 5.0, 1.5));
        }
    }
}

