/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO;

import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonOptions;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.DataSync;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class CompoundSyncPacket
extends Packet
implements DataSync {
    private static final String ERROR_TAG = "erroredPacket";
    public static final CompoundSyncPacket instance = new CompoundSyncPacket();
    private final HashMap<WorldLocation, HashMap<String, NBTBase>> data = new HashMap();
    private final HashMap<WorldLocation, HashMap<String, NBTBase>> oldData = new HashMap();
    private final HashMap<WorldLocation, HashMap<String, NBTBase>> changes = new HashMap();
    private boolean dispatch;
    private boolean receive;

    private CompoundSyncPacket() {
    }

    @Override
    public void setData(TileEntity te, boolean force, NBTTagCompound NBT) {
        if (this.dispatch) {
            if (DragonOptions.LOGSYNCCME.getState()) {
                DragonAPICore.log("The compound sync packet for " + te + " would have just CME'd, as the");
                DragonAPICore.log("Server-Thread data-writing code has overlapped with the Network-Thread byte[] dispatch.");
                DragonAPICore.log("Seeing this message frequently could indicate a serious issue.\n");
            }
            return;
        }
        WorldLocation loc = new WorldLocation(te);
        this.createMaps(loc);
        this.changes.remove(loc);
        Set c = NBT.func_150296_c();
        for (String name : c) {
            if (name == null) {
                DragonAPICore.log("An NBT tag with a null key is being sent to the compound sync packet from " + te);
                continue;
            }
            NBTBase tag = NBT.func_74781_a(name);
            this.addData(loc, name, tag, force);
        }
    }

    private void createMaps(WorldLocation loc) {
        if (this.data.get(loc) == null) {
            this.data.put(loc, new HashMap());
        }
        if (this.oldData.get(loc) == null) {
            this.oldData.put(loc, new HashMap());
        }
    }

    private void addData(WorldLocation loc, String key, NBTBase value, boolean force) {
        NBTBase prev = this.data.get(loc).get(key);
        this.oldData.get(loc).put(key, prev);
        this.data.get(loc).put(key, value);
        if (force || !this.match(prev, value)) {
            this.addChange(loc, key, value);
        }
    }

    private void addChange(WorldLocation loc, String key, NBTBase value) {
        HashMap<String, Object> map = this.changes.get(loc);
        if (map == null) {
            map = new HashMap();
            this.changes.put(loc, map);
        }
        map.put(key, value);
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public boolean isEmpty(WorldLocation loc) {
        return this.changes.get(loc).isEmpty();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readForSync(TileEntity te, NBTTagCompound NBT) {
        if (this.dispatch) {
            if (DragonOptions.LOGSYNCCME.getState()) {
                DragonAPICore.log("The compound sync packet for " + te + " would have just CME'd, as the");
                DragonAPICore.log("Client-Thread data-reading code has overlapped with the Network-Thread byte[] reading.");
                DragonAPICore.log("Seeing this message frequently could indicate a serious issue.\n");
            }
            return;
        }
        WorldLocation loc = new WorldLocation(te);
        this.createMaps(loc);
        for (String key : this.data.get(loc).keySet()) {
            NBT.func_74782_a(key, this.data.get(loc).get(key));
        }
    }

    public String toString() {
        return this.changes.isEmpty() ? "[Empty]" : this.changes.toString();
    }

    private boolean match(NBTBase old, NBTBase cur) {
        if (old == cur) {
            return true;
        }
        if (old == null || cur == null) {
            return false;
        }
        return cur.equals((Object)old);
    }

    public void func_148840_b(PacketBuffer out) throws IOException {
        this.dispatch = true;
        out.writeInt(this.changes.size());
        for (WorldLocation worldLocation : this.changes.keySet()) {
            out.writeInt(worldLocation.dimensionID);
            out.writeInt(worldLocation.xCoord);
            out.writeShort(worldLocation.yCoord);
            out.writeInt(worldLocation.zCoord);
        }
        NBTTagCompound toSend = new NBTTagCompound();
        for (WorldLocation loc : this.changes.keySet()) {
            HashMap<String, NBTBase> map = this.changes.get(loc);
            try {
                NBTTagCompound local = new NBTTagCompound();
                this.saveChanges(map, local);
                toSend.func_74782_a(loc.toSerialString(), (NBTBase)local);
            }
            catch (Exception e) {
                toSend.func_74757_a(ERROR_TAG, true);
                e.printStackTrace();
            }
        }
        try {
            out.func_150786_a(toSend);
        }
        catch (Exception exception) {
            DragonAPICore.logError("Error writing Compound Sync Tag!");
            out.clear();
            exception.printStackTrace();
        }
        DragonAPICore.log("Wrote " + this.changes.size() + " locations, data=" + toSend);
        this.dispatch = false;
    }

    private void saveChanges(HashMap<String, NBTBase> changes, NBTTagCompound loc) {
        for (String key : changes.keySet()) {
            NBTBase val = changes.get(key);
            loc.func_74782_a(key, val);
        }
    }

    public void func_148837_a(PacketBuffer in) throws IOException {
        this.receive = true;
        try {
            WorldLocation loc;
            int num = in.readInt();
            for (int i = 0; i < num; ++i) {
                int dim = in.readInt();
                int x = in.readInt();
                short y = in.readShort();
                int z = in.readInt();
                loc = new WorldLocation(dim, x, (int)y, z);
                this.createMaps(loc);
            }
            NBTTagCompound received = in.func_150793_b();
            if (!received.func_74767_n(ERROR_TAG)) {
                Set c = received.func_150296_c();
                for (String name : c) {
                    NBTTagCompound local = received.func_74775_l(name);
                    loc = WorldLocation.fromSerialString(name);
                    this.populateFromStream(loc, local);
                }
            }
        }
        catch (Exception e) {
            DragonAPICore.logError("Error reading Compound Sync Tag!");
            e.printStackTrace();
            this.data.clear();
        }
        this.receive = false;
    }

    private void populateFromStream(WorldLocation loc, NBTTagCompound local) {
        Set c = local.func_150296_c();
        for (String name : c) {
            NBTBase tag = local.func_74781_a(name);
            this.data.get(loc).put(name, tag);
        }
        DragonAPICore.log("Reading " + this.data.get(loc) + " from " + local + " @ " + loc.getTileEntity());
    }

    @Override
    public boolean hasNoData() {
        return this.data.isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_148833_a(INetHandler inh) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        for (WorldLocation loc : this.data.keySet()) {
            TileEntity te;
            if (loc.dimensionID != world.field_73011_w.field_76574_g || !world.func_72899_e(loc.xCoord, loc.yCoord, loc.zCoord) || !((te = loc.getTileEntity((IBlockAccess)world)) instanceof CompoundSyncPacketHandler)) continue;
            ((CompoundSyncPacketHandler)te).handleCompoundSyncPacket(this);
        }
    }

    public static class CompoundSyncPacketTracker
    implements TickRegistry.TickHandler {
        public static final CompoundSyncPacketTracker instance = new CompoundSyncPacketTracker();
        private int tickcount;
        private static final int MAXTICK = DragonOptions.SLOWSYNC.getState() ? 20 : 4;

        private CompoundSyncPacketTracker() {
        }

        @Override
        public void tick(TickRegistry.TickType type, Object ... tickData) {
            ++this.tickcount;
            if (this.tickcount >= MAXTICK) {
                if (!instance.isEmpty()) {
                    this.dispatchPacket((World)tickData[0]);
                }
                this.tickcount = 0;
            }
        }

        private void dispatchPacket(World world) {
            for (EntityPlayerMP ep : world.field_73010_i) {
                ep.field_71135_a.func_147359_a((Packet)instance);
            }
        }

        @Override
        public EnumSet<TickRegistry.TickType> getType() {
            return EnumSet.of(TickRegistry.TickType.WORLD);
        }

        @Override
        public boolean canFire(TickEvent.Phase p) {
            return p == TickEvent.Phase.END;
        }

        @Override
        public String getLabel() {
            return "Compound Sync Packet";
        }
    }

    public static interface CompoundSyncPacketHandler {
        public void handleCompoundSyncPacket(CompoundSyncPacket var1);
    }
}

