/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.IO.DirectResource;
import Reika.DragonAPI.Instantiable.IO.DynamicDirectResource;
import Reika.DragonAPI.Instantiable.IO.RemoteSourcedAsset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundPoolEntry;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class DirectResourceManager
implements IResourceManager,
IResourceManagerReloadListener {
    private final HashMap<String, SoundEventAccessorComposite> accessors = new HashMap();
    private final HashMap<String, RemoteSourcedAsset> dynamicAssets = new HashMap();
    private final HashSet<String> streamedPaths = new HashSet();
    private static final DirectResourceManager instance = new DirectResourceManager();
    private static final String TAG = "custom_path";

    private DirectResourceManager() {
    }

    public static DirectResourceManager getInstance() {
        return instance;
    }

    public static ResourceLocation getResource(String path) {
        return new ResourceLocation(TAG, path);
    }

    public IResource func_110536_a(ResourceLocation loc) throws IOException {
        DirectResource ret;
        String dom = loc.func_110624_b();
        String path = loc.func_110623_a();
        RemoteSourcedAsset rem = this.dynamicAssets.get(path);
        DirectResource directResource = ret = rem != null ? new DynamicDirectResource(rem) : new DirectResource(path);
        if (this.streamedPaths.contains(ret.path)) {
            ret.cacheData = false;
        }
        return ret;
    }

    public void registerDynamicAsset(String path, RemoteSourcedAsset a) {
        this.dynamicAssets.put(path, a);
    }

    public void registerCustomPath(String path, SoundCategory cat, boolean streaming) {
        ResourceLocation rl = new ResourceLocation(TAG, path);
        SoundPoolEntry spe = new SoundPoolEntry(rl, 1.0, 1.0, streaming);
        SoundEventAccessor pos = new SoundEventAccessor(spe, 1);
        SoundEventAccessorComposite cmp = new SoundEventAccessorComposite(rl, 1.0, 1.0, cat);
        cmp.func_148727_a((ISoundEventAccessor)pos);
        this.accessors.put(path, cmp);
        if (streaming) {
            this.streamedPaths.add(path);
        }
    }

    public void initToSoundRegistry() {
        SoundHandler sh = Minecraft.func_71410_x().func_147118_V();
        if (sh == null) {
            DragonAPICore.logError("Attempted to initialize sound entries before the sound handler was created!");
            return;
        }
        SoundRegistry srg = sh.field_147697_e;
        if (srg == null) {
            DragonAPICore.logError("Attempted to initialize sound entries before the sound registry was created!");
            return;
        }
        for (String path : this.accessors.keySet()) {
            srg.func_148762_a(this.accessors.get(path));
        }
    }

    public Set<String> func_135055_a() {
        return ImmutableSet.of((Object)TAG);
    }

    public List<IResource> func_135056_b(ResourceLocation resource) throws IOException {
        return ImmutableList.of((Object)this.func_110536_a(resource));
    }

    public void func_110549_a(IResourceManager rm) {
        ((SimpleReloadableResourceManager)rm).field_110548_a.put(TAG, this);
        this.initToSoundRegistry();
    }
}

