/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Java.ReikaJVMParser;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import javax.net.ssl.SSLException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ReikaFileReader
extends DragonAPICore {
    private static long internetLastUnavailable = -1L;

    public static int getFileLength(File f) {
        int len;
        try (LineNumberReader lnr = new LineNumberReader(new FileReader(f));){
            lnr.skip(Long.MAX_VALUE);
            len = lnr.getLineNumber() + 1 + 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not load file data due to " + e.getCause() + " and " + e.getClass() + " !");
        }
        return len;
    }

    public static BufferedReader getReader(URL url, int timeout, ConnectionErrorHandler ch, DataFetcher f) {
        if (!ReikaFileReader.isInternetAccessible(timeout)) {
            if (ch != null) {
                ch.onNoInternet();
            }
            return null;
        }
        try {
            URLConnection c = url.openConnection();
            c.setConnectTimeout(timeout);
            if (f != null) {
                try {
                    f.fetchData(c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return new BufferedReader(new InputStreamReader(c.getInputStream()));
        }
        catch (UnknownHostException e) {
            if (ch != null) {
                ch.onServerNotFound();
            }
        }
        catch (ConnectException e) {
            if (ch != null) {
                ch.onServerRedirected();
            }
        }
        catch (SocketTimeoutException e) {
            if (ch != null) {
                ch.onTimedOut();
            }
        }
        catch (SSLException e) {
            if (ch != null) {
                ch.onCertificateFailed();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static boolean isInternetAccessible(int timeout) {
        if (ReikaObfuscationHelper.isDeObfEnvironment() && ReikaJVMParser.isArgumentPresent("-DragonAPI_NoInternet")) {
            DragonAPICore.log("Internet is marked inaccessible.");
            return false;
        }
        int dt = 60000 * (ReikaObfuscationHelper.isDeObfEnvironment() ? 5 : 1);
        if (internetLastUnavailable + (long)dt >= System.currentTimeMillis()) {
            return false;
        }
        String[] attempts = new String[]{"http://www.google.com", "http://en.wikipedia.org/wiki/Main_Page", "http://github.com/", "http://msdn.microsoft.com/en-us/default.aspx", "https://aws.amazon.com/", "ns1.telstra.net"};
        for (int i = 0; i < attempts.length; ++i) {
            try {
                URLConnection c = new URL(attempts[i]).openConnection();
                c.setConnectTimeout(timeout);
                ((HttpURLConnection)c).getResponseCode();
                return true;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        internetLastUnavailable = System.currentTimeMillis();
        return false;
    }

    public static ArrayList<File> getAllFilesInFolder(File f, String ... ext) {
        ArrayList<File> li = new ArrayList<File>();
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File in = files[i];
                if (in.isDirectory()) {
                    li.addAll(ReikaFileReader.getAllFilesInFolder(in, ext));
                    continue;
                }
                if (ext == null) {
                    li.add(in);
                    continue;
                }
                for (int k = 0; k < ext.length; ++k) {
                    if (!in.getName().endsWith(ext[k])) continue;
                    li.add(in);
                }
            }
        }
        return li;
    }

    public static ArrayList<File> getAllFilesInFolder(File f) {
        return ReikaFileReader.getAllFilesInFolder(f, null);
    }

    public static List<String> getFileAsLines(String path, boolean printStackTrace, Charset set) {
        return ReikaFileReader.getFileAsLines(new File(path), printStackTrace, set);
    }

    public static List<String> getFileAsLines(URL url, int timeout, boolean printStackTrace, ConnectionErrorHandler ch) {
        return ReikaFileReader.getFileAsLines(url, timeout, printStackTrace, ch, null);
    }

    public static List<String> getFileAsLines(URL url, int timeout, boolean printStackTrace, ConnectionErrorHandler ch, DataFetcher f) {
        BufferedReader r = ReikaFileReader.getReader(url, timeout, ch, f);
        return r != null ? ReikaFileReader.getFileAsLines(r, printStackTrace) : null;
    }

    public static List<String> getFileAsLines(InputStream f, boolean printStackTrace, Charset set) {
        try {
            return IOUtils.readLines((InputStream)f, (Charset)set);
        }
        catch (IOException e) {
            if (printStackTrace) {
                e.printStackTrace();
            }
            return new ArrayList<String>();
        }
    }

    @Deprecated
    public static List<String> getFileAsLines(InputStream f, boolean printStackTrace) {
        return ReikaFileReader.getFileAsLines(f, printStackTrace, Charsets.UTF_8);
    }

    @Deprecated
    public static List<String> getFileAsLines(File f, boolean printStackTrace) {
        return ReikaFileReader.getFileAsLines(f, printStackTrace, Charsets.UTF_8);
    }

    public static List<String> getFileAsLines(File f, boolean printStackTrace, Charset set) {
        try {
            return com.google.common.io.Files.readLines((File)f, (Charset)set);
        }
        catch (IOException e) {
            if (printStackTrace) {
                e.printStackTrace();
            }
            return new ArrayList<String>();
        }
    }

    public static List<String> getFileAsLines(Reader r, boolean printStackTrace) {
        try {
            return IOUtils.readLines((Reader)r);
        }
        catch (IOException e) {
            if (printStackTrace) {
                e.printStackTrace();
            }
            return new ArrayList<String>();
        }
    }

    public static boolean writeLinesToFile(String s, List<String> li, boolean printStackTrace, Charset set) {
        return ReikaFileReader.writeLinesToFile(new File(s), li, printStackTrace, set);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeLinesToFile(File f, List<String> li, boolean printStackTrace, Charset set) {
        try (BufferedOutputStream fs = new BufferedOutputStream(new FileOutputStream(f));){
            IOUtils.writeLines(li, (String)System.getProperty("line.separator"), (OutputStream)fs, (Charset)set);
            fs.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            if (!printStackTrace) return false;
            e.printStackTrace();
            return false;
        }
    }

    public static void writeDataToFile(File f, List<Byte> li, boolean printStackTrace) {
        block30: {
            block29: {
                try {
                    f.delete();
                    f.getParentFile().mkdirs();
                    f.createNewFile();
                }
                catch (IOException e) {
                    if (!printStackTrace) break block29;
                    e.printStackTrace();
                }
            }
            try (FileOutputStream fos = new FileOutputStream(f);
                 BufferedWriter p = new BufferedWriter(new OutputStreamWriter(fos));){
                for (byte b : li) {
                    p.write(b);
                }
                p.flush();
                p.close();
            }
            catch (IOException e) {
                if (!printStackTrace) break block30;
                e.printStackTrace();
            }
        }
    }

    public static InputStream convertLinesToStream(List<String> li, boolean printStackTrace, Charset set) {
        ByteArrayOutputStream bos;
        block15: {
            String sep = System.getProperty("line.separator");
            bos = new ByteArrayOutputStream();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)bos, set));){
                for (String s : li) {
                    writer.write(s + sep);
                }
                writer.close();
            }
            catch (IOException e) {
                if (!printStackTrace) break block15;
                e.printStackTrace();
            }
        }
        byte[] bytes = bos.toByteArray();
        return new ByteArrayInputStream(bytes);
    }

    public static String getHash(String path, HashType type) {
        return ReikaFileReader.getHash(new File(path), type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHash(File file, HashType type) {
        try (FileInputStream in = new FileInputStream(file);){
            String string = ReikaFileReader.getHash(in, type);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String getHash(InputStream is, HashType type) {
        StringBuffer sb = new StringBuffer();
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance(type.tag);
            do {
                if ((numRead = is.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            is.close();
            byte[] hash = complete.digest();
            for (int i = 0; i < hash.length; ++i) {
                sb.append(Integer.toString((hash[i] & 0xFF) + 256, 16).substring(1).toUpperCase());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            sb.append("IO ERROR: ");
            sb.append(e.toString());
        }
        return sb.toString();
    }

    public static InputStream getFileInsideJar(File f, String name) {
        try {
            return ReikaFileReader.getFileInsideJar(new JarFile(f), name);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream getFileInsideJar(JarFile jar, String name) {
        try {
            return jar.getInputStream(jar.getEntry(name));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean deleteFolderWithContents(File f) {
        return ReikaFileReader.deleteFolderWithContents(f, 10);
    }

    public static boolean deleteFolderWithContents(File f, int tries) {
        Throwable e = null;
        for (int i = 0; i < tries; ++i) {
            try {
                FileUtils.forceDelete((File)f);
                return true;
            }
            catch (Exception ex) {
                e = ex;
                continue;
            }
        }
        if (e != null) {
            e.printStackTrace();
        }
        return false;
    }

    public static void copyFile(File in, File out, int size) throws FileReadException, FileWriteException, FileNotFoundException {
        ReikaFileReader.copyFile(new FileInputStream(in), new FileOutputStream(out), size, null);
    }

    public static void copyFile(InputStream in, OutputStream out, int size) throws FileReadException, FileWriteException {
        ReikaFileReader.copyFile(in, out, size, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(InputStream in, OutputStream out, int chunkSize, WriteCallback call) throws FileReadException, FileWriteException {
        try {
            byte[] bytes = new byte[chunkSize];
            int count = 0;
            while (count != -1) {
                if (count > 0) {
                    try {
                        out.write(bytes, 0, count);
                        if (call != null) {
                            call.onWrite(bytes);
                        }
                    }
                    catch (IOException e) {
                        throw new FileWriteException(e);
                    }
                }
                try {
                    count = in.read(bytes, 0, bytes.length);
                }
                catch (IOException e) {
                    throw new FileReadException(e);
                    return;
                }
            }
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
            return;
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File createFileFromStream(InputStream in) throws IOException {
        File tempFile = File.createTempFile("temp_" + String.valueOf(in.hashCode()), null);
        tempFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(tempFile);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        return tempFile;
    }

    public static void writeUncompressedNBT(NBTTagCompound tag, File f) throws IOException {
        ReikaFileReader.writeUncompressedNBT(tag, new FileOutputStream(f));
    }

    public static void writeUncompressedNBT(NBTTagCompound tag, OutputStream out) throws IOException {
        CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)new DataOutputStream(out));
    }

    public static NBTTagCompound readUncompressedNBT(File f) throws IOException {
        return ReikaFileReader.readUncompressedNBT(new FileInputStream(f));
    }

    public static NBTTagCompound readUncompressedNBT(InputStream in) throws IOException {
        try (DataInputStream data = new DataInputStream(in);){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_152456_a((DataInput)data, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            return nBTTagCompound;
        }
    }

    public static boolean isEmpty(File f) throws IOException {
        byte[] arr = Files.readAllBytes(f.toPath());
        return arr == null || arr.length == 0;
    }

    public static void emptyDirectory(File dir) {
        File[] f = dir.listFiles();
        if (f == null) {
            return;
        }
        for (int i = 0; i < f.length; ++i) {
            f[i].delete();
        }
    }

    public static void clearFile(File f) {
        try {
            f.delete();
            f.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void flipFileBytes(InputStream in, File out) {
        try {
            ArrayList<Byte> li = new ArrayList<Byte>();
            byte b = (byte)in.read();
            while (b != -1) {
                li.add(b);
                b = (byte)in.read();
            }
            Collections.reverse(li);
            ReikaFileReader.writeDataToFile(out, li, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ArrayList<String> encryptFileBytes(InputStream in) {
        try {
            ArrayList<Byte> li = new ArrayList<Byte>();
            byte b = (byte)in.read();
            while (b != -1) {
                li.add(b);
                b = (byte)in.read();
            }
            ReikaFileReader.encryptByteList(li);
            ArrayList<String> li2 = new ArrayList<String>();
            String line = "";
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < li.size(); ++i) {
                byte b2 = li.get(i);
                int val = Math.abs(b2);
                String s = String.valueOf(val);
                if (val < 10) {
                    s = "0" + s;
                }
                if (val < 100) {
                    s = "0" + s;
                }
                s = b2 < 0 ? "-" + s : "0" + s;
                sb.append(s);
                if (i % 56 != 55 && i != li.size() - 1) continue;
                li2.add(sb.toString());
                sb = new StringBuilder();
            }
            return li2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void encryptByteList(ArrayList<Byte> li) {
        Collections.reverse(li);
        for (int i = li.size() - 1; i >= 0; --i) {
            byte get = li.get(i);
            get = ReikaJavaLibrary.flipBits(get);
            get = ~get;
            li.set(i, get);
            li.add(i + 1, (byte)rand.nextInt(255));
        }
    }

    public static List<Byte> decryptFileBytes(InputStream in, Charset set) {
        return ReikaFileReader.decryptByteList(ReikaFileReader.getFileAsLines(in, true, set));
    }

    public static List<Byte> decryptByteList(List<String> li2) {
        ArrayList<Byte> li = new ArrayList<Byte>();
        for (String s : li2) {
            List<String> arr = ReikaStringParser.splitStringByLength(s, 4);
            for (String s2 : arr) {
                byte b = Byte.parseByte(s2);
                li.add(b);
            }
        }
        Iterator it = li.iterator();
        int idx = 0;
        while (it.hasNext()) {
            byte b2 = (Byte)it.next();
            if (idx % 2 == 1) {
                it.remove();
            }
            ++idx;
        }
        for (int i = 0; i < li.size(); ++i) {
            byte get = (Byte)li.get(i);
            get = ~get;
            get = ReikaJavaLibrary.flipBits(get);
            li.set(i, get);
        }
        Collections.reverse(li);
        return li;
    }

    public static InputStream decryptInputStream(InputStream in, Charset set) {
        List<Byte> data = ReikaFileReader.decryptFileBytes(in, set);
        ByteArrayOutputStream bin = new ByteArrayOutputStream();
        for (byte b : data) {
            bin.write(b);
        }
        return new ByteArrayInputStream(bin.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JsonElement readJSON(File f) {
        try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), Charsets.UTF_8));){
            JsonElement jsonElement = new JsonParser().parse((Reader)r);
            return jsonElement;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File getFileByNameAnyExt(File folder, String name) {
        for (File f : folder.listFiles()) {
            if (f.isDirectory() || !ReikaFileReader.getFileNameNoExtension(f, false, false).equals(name)) continue;
            return f;
        }
        return null;
    }

    public static String getFileNameNoExtension(File f, boolean full, boolean real) {
        String n = full ? (real ? ReikaFileReader.getRealPath(f) : f.getAbsolutePath()) : f.getName();
        int idx = n.lastIndexOf(46);
        return idx >= 0 && idx < n.length() ? n.substring(0, idx) : n;
    }

    public static String getRelativePath(File from, File to) {
        return Paths.get(from.toURI()).relativize(Paths.get(to.toURI())).toString();
    }

    public static String getRealPath(File f) {
        try {
            return f.exists() ? f.toPath().toRealPath(new LinkOption[0]).toString() : f.getCanonicalPath();
        }
        catch (Exception e) {
            e.printStackTrace();
            return f.getAbsolutePath();
        }
    }

    public static boolean isFileWithin(File f, File dir) throws IOException {
        return f.getCanonicalPath().startsWith(dir.getCanonicalPath());
    }

    public static interface WriteCallback {
        public void onWrite(byte[] var1);
    }

    public static class FileWriteException
    extends IOException {
        private FileWriteException(IOException e) {
            super(e);
        }
    }

    public static class FileReadException
    extends IOException {
        private FileReadException(IOException e) {
            super(e);
        }
    }

    public static abstract class LineEditor {
        private List<String> lines;

        public abstract boolean editLine(String var1, int var2);

        protected abstract String getReplacementLine(String var1, String var2, int var3);

        public final boolean performChanges(File f, Charset set) {
            this.lines = ReikaFileReader.getFileAsLines(f, true, set);
            if (this.lines == null || this.lines.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ArrayList<String> put = new ArrayList<String>();
            String sep = System.getProperty("line.separator");
            for (int i = 0; i < this.lines.size(); ++i) {
                String s;
                String s2 = s = this.lines.get(i);
                if (this.editLine(s, i)) {
                    s2 = this.getReplacementLine(s, sep, i);
                    changed |= !s.equals(s2);
                }
                if (Strings.isNullOrEmpty((String)s2)) continue;
                put.add(s2);
            }
            if (changed) {
                return ReikaFileReader.writeLinesToFile(f, put, true, set);
            }
            return true;
        }

        protected final String getOriginalLine(int i) {
            return this.lines.get(i);
        }
    }

    public static enum HashType {
        MD5("MD5"),
        SHA1("SHA-1"),
        SHA256("SHA-256");

        private final String tag;

        private HashType(String s) {
            this.tag = s;
        }

        public String hash(Object o) {
            return this.hashBytes(this.getBytes(o));
        }

        private String hashBytes(byte[] bytes) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(this.tag);
                messageDigest.update(bytes);
                return Hex.encodeHexString((byte[])messageDigest.digest());
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
        }

        private byte[] getBytes(Object o) {
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            if (o instanceof Integer) {
                return ReikaJavaLibrary.splitIntToHexChars((Integer)o);
            }
            if (o instanceof Long) {
                int[] split = ReikaJavaLibrary.splitLong((Long)o);
                byte[] res = new byte[8];
                byte[] low = ReikaJavaLibrary.splitIntToHexChars(split[0]);
                byte[] high = ReikaJavaLibrary.splitIntToHexChars(split[1]);
                System.arraycopy(low, 0, res, 0, low.length);
                System.arraycopy(high, 0, res, 4, high.length);
                return res;
            }
            if (o instanceof String) {
                return ((String)o).getBytes();
            }
            if (o instanceof Serializable) {
                try {
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    ObjectOutputStream oo = new ObjectOutputStream(buf);
                    oo.writeObject(o);
                    return buf.toByteArray();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            DragonAPICore.logError("Cannot serialize an object " + o + " of type " + o.getClass() + "!");
            return new byte[0];
        }
    }

    public static interface DataFetcher {
        public void fetchData(URLConnection var1) throws Exception;
    }

    public static interface ConnectionErrorHandler {
        public void onServerRedirected();

        public void onCertificateFailed();

        public void onTimedOut();

        public void onNoInternet();

        public void onServerNotFound();
    }
}

