/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO.Shaders;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.IO.Shaders.ShaderRegistry;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ShaderLibrary {
    private static final HashMap<String, ShaderLibrary> libraries = new HashMap();
    private static final HashMap<String, Constructor<ComputedLibrary>> computed = new HashMap();
    public final String name;
    private List<String> code = new ArrayList<String>();

    static void loadLibraries() {
        if (libraries.isEmpty()) {
            try (InputStream in = DragonAPICore.class.getResourceAsStream("Resources/Shader/liblist.txt");){
                if (in == null) {
                    ShaderRegistry.error(DragonAPIInit.instance, null, "Shader library manifest not found", null);
                }
                List<String> li = ReikaFileReader.getFileAsLines(in, true, Charsets.UTF_8);
                for (String s : li) {
                    ShaderLibrary lib = new ShaderLibrary(s);
                    libraries.put(s, lib);
                }
            }
            catch (IOException e) {
                ShaderRegistry.error(DragonAPIInit.instance, null, "Failed to load shader library manifest", null, e);
            }
            for (ShaderLibrary s : libraries.values()) {
                s.code = s.load();
            }
        }
    }

    private ShaderLibrary(String s) {
        this.name = s;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> load() {
        try (InputStream in = DragonAPICore.class.getResourceAsStream("Resources/Shader/lib_" + this.name + ".txt");){
            List<String> list = ReikaFileReader.getFileAsLines(in, true, Charset.defaultCharset());
            return list;
        }
        catch (IOException e) {
            ShaderRegistry.error(DragonAPIInit.instance, this.name, "Failed to load shader library", null, e);
            return new ArrayList<String>();
        }
    }

    public final void reload() {
        this.code = this.load();
    }

    final String getCode() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.code) {
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    static ShaderLibrary getLibrary(String id) {
        return libraries.get(id);
    }

    static ShaderLibrary getCompute(String id, String ... params) throws Exception {
        Constructor<ComputedLibrary> ctr = computed.get(id);
        if (ctr == null) {
            return null;
        }
        return ctr.newInstance(new Object[]{params});
    }

    public static void registerComputedLibrary(DragonAPIMod mod, String id, Class<? extends ComputedLibrary> c) {
        if ((c.getModifiers() & 0x400) != 0) {
            throw new RegistrationException(mod, "Invalid computed library patch " + id + "/" + c.getName() + ": class is abstract");
        }
        try {
            Constructor<? extends ComputedLibrary> ctr = c.getDeclaredConstructor(String[].class);
            ctr.setAccessible(true);
            computed.put(id, ctr);
        }
        catch (Exception e) {
            throw new RegistrationException(mod, "Invalid computed library patch " + id + "/" + c.getName(), e);
        }
    }

    static {
        ShaderLibrary.registerComputedLibrary(DragonAPIInit.instance, "blur", Blur.class);
    }

    private static class Blur
    extends ComputedLibrary {
        private Blur(String[] args) {
            super("blur", args);
        }

        @Override
        protected ArrayList<String> generate() {
            int radius = (Integer)this.params[0];
            ArrayList<String> li = new ArrayList<String>();
            li.add("vec4 blur" + radius + "(vec2 uv) {");
            li.add("vec4 color = vec4(0.0);");
            li.add("color.a = 1.0;");
            li.add("float sum = 0.0;");
            li.add("float f = 0.0;");
            li.add("vec2 duv = vec2(0.0);");
            li.add("vec4 get = vec4(0.0);");
            int r = radius + 1;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    float f;
                    float dd = (float)ReikaMathLibrary.py3d(i, 0.0, k);
                    float f2 = f = dd <= (float)radius ? 1.0f - (float)Math.sqrt(dd / (float)radius) : 0.0f;
                    if (!(f > 0.0f)) continue;
                    li.add("f = float(" + f + ");");
                    li.add("sum += f;");
                    li.add("duv = uv+vec2(float(" + i + ")/float(screenWidth), float(" + k + ")/float(screenHeight));");
                    li.add("get = texture2D(bgl_RenderedTexture, duv);");
                    li.add("color += get*f;");
                }
            }
            li.add("color /= sum;");
            li.add("color = min(vec4(1.0), color);");
            li.add("return color; ");
            li.add("}");
            return li;
        }
    }

    public static abstract class ComputedLibrary
    extends ShaderLibrary {
        protected final Object[] params;

        protected ComputedLibrary(String s, String[] args) {
            super(s);
            this.params = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                this.params[i] = this.convertArg(args[i]);
            }
            this.reload();
        }

        protected abstract ArrayList<String> generate();

        private Object convertArg(String s) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception exception) {
                try {
                    return Float.valueOf(Float.parseFloat(s));
                }
                catch (Exception exception2) {
                    return s;
                }
            }
        }

        protected final ArrayList<String> load() {
            return this.generate();
        }
    }
}

