/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.IO.Shaders;

import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.IO.Shaders.ShaderHook;
import Reika.DragonAPI.IO.Shaders.ShaderLibrary;
import Reika.DragonAPI.IO.Shaders.ShaderRegistry;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Math.Vec4;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.Util;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

@SideOnly(value=Side.CLIENT)
public final class ShaderProgram
implements Comparable<ShaderProgram> {
    public final DragonAPIMod owner;
    private final Class reference;
    private final String pathPrefix;
    public final String identifier;
    public final ShaderRegistry.ShaderDomain domain;
    private int vertexID;
    private int fragmentID;
    private int programID;
    private ShaderHook hook;
    private int ordering;
    private boolean errored = false;
    private boolean errorChecked = false;
    private boolean isEnabled = true;
    private final MultiMap<ShaderRegistry.ShaderTypes, ShaderLibrary> imports = new MultiMap();
    private final HashMap<String, Object> variables = new HashMap();
    private Matrix4f modelview;
    private Matrix4f projection;
    private Vector3f focusLocation;
    private ArrayList<RenderState> compoundLocation = null;

    ShaderProgram(DragonAPIMod mod, Class c, String p, String s, ShaderRegistry.ShaderDomain dom) {
        this.identifier = s;
        this.reference = c;
        this.pathPrefix = p;
        this.owner = mod;
        this.domain = dom;
    }

    public void load() throws IOException {
        this.errored = false;
        this.errorChecked = false;
        if (this.vertexID != 0) {
            GL20.glDeleteProgram((int)this.vertexID);
        }
        if (this.fragmentID != 0) {
            GL20.glDeleteProgram((int)this.fragmentID);
        }
        if (this.programID != 0) {
            GL20.glDeleteProgram((int)this.programID);
        }
        try (InputStream vin = this.getShaderData(ShaderRegistry.ShaderTypes.VERTEX);
             InputStream fin = this.getShaderData(ShaderRegistry.ShaderTypes.FRAGMENT);){
            ArrayList<ShaderLibrary> libs = new ArrayList<ShaderLibrary>();
            this.vertexID = ShaderRegistry.constructShader(this.owner, this.identifier, vin, ShaderRegistry.ShaderTypes.VERTEX, libs);
            this.imports.addValues(ShaderRegistry.ShaderTypes.VERTEX, libs);
            libs = new ArrayList();
            this.fragmentID = ShaderRegistry.constructShader(this.owner, this.identifier, fin, ShaderRegistry.ShaderTypes.FRAGMENT, libs);
            this.imports.addValues(ShaderRegistry.ShaderTypes.FRAGMENT, libs);
        }
        this.register();
    }

    private InputStream getShaderData(ShaderRegistry.ShaderTypes s) {
        return this.reference.getResourceAsStream(this.pathPrefix + this.identifier + "." + s.extension);
    }

    public ShaderProgram setHook(ShaderHook h) {
        this.hook = h;
        return this;
    }

    public ShaderProgram setOrdering(int o) {
        this.ordering = o;
        return this;
    }

    public ShaderProgram setEnabled(boolean on) {
        this.isEnabled = on;
        return this;
    }

    public Collection<ShaderLibrary> getLibraries() {
        return Collections.unmodifiableCollection(this.imports.allValues(false));
    }

    public ShaderProgram setMatricesToCurrent() {
        return this.setMatrices(ReikaRenderHelper.getModelviewMatrix(), ReikaRenderHelper.getProjectionMatrix());
    }

    public ShaderProgram setMatrices(Matrix4f model, Matrix4f proj) {
        this.modelview = model;
        this.projection = proj;
        return this;
    }

    public ShaderProgram setFocus(Coordinate e) {
        return this.setFocus((double)e.xCoord + 0.5, (double)e.yCoord + 0.5, (double)e.zCoord + 0.5);
    }

    public ShaderProgram setFocus(TileEntity e) {
        return this.setFocus((double)e.field_145851_c + 0.5, (double)e.field_145848_d + 0.5, (double)e.field_145849_e + 0.5);
    }

    public ShaderProgram setFocus(Entity e) {
        return this.setFocus(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public ShaderProgram setFocus(double x, double y, double z) {
        return this.setFocus(new Vector3f((float)x, (float)y, (float)z));
    }

    public ShaderProgram setFocus(Vector3f focus) {
        this.focusLocation = focus;
        return this;
    }

    public ShaderProgram clearFoci() {
        this.compoundLocation = null;
        return this;
    }

    public ShaderProgram addFocus(Coordinate e) {
        return this.addFocus((double)e.xCoord + 0.5, (double)e.yCoord + 0.5, (double)e.zCoord + 0.5);
    }

    public ShaderProgram addFocus(TileEntity e) {
        return this.addFocus((double)e.field_145851_c + 0.5, (double)e.field_145848_d + 0.5, (double)e.field_145849_e + 0.5);
    }

    public ShaderProgram addFocus(Entity e) {
        return this.addFocus(e.field_70165_t, e.field_70163_u, e.field_70161_v);
    }

    public ShaderProgram addFocus(double x, double y, double z) {
        return this.addFocus(x, y, z, null, null);
    }

    public ShaderProgram addFocus(double x, double y, double z, Matrix4f model, Matrix4f proj) {
        if (this.compoundLocation == null) {
            this.compoundLocation = new ArrayList();
        }
        if (model == null) {
            model = ReikaRenderHelper.getModelviewMatrix();
        }
        if (proj == null) {
            proj = ReikaRenderHelper.getProjectionMatrix();
        }
        this.compoundLocation.add(new RenderState(new Vector3f((float)x, (float)y, (float)z), model, proj));
        return this;
    }

    public ShaderProgram modifyLastCompoundFocus(float intensity, HashMap<String, Object> vars) {
        RenderState rs = this.compoundLocation.get(this.compoundLocation.size() - 1);
        rs.intensity = intensity;
        rs.variables = vars;
        return this;
    }

    public void clearData() {
        for (Map.Entry<String, Object> e : this.variables.entrySet()) {
            e.setValue(Float.valueOf(e.getValue() instanceof Integer ? 0.0f : 0.0f));
        }
    }

    public void setFields(Map<String, Object> data) {
        this.variables.putAll(data);
    }

    public void setField(String field, Object value) {
        this.variables.put(field, value);
    }

    public void setIntensity(float f) {
        this.setField("intensity", Float.valueOf(f));
    }

    public void setTextureUnit(String field, int constant) {
        this.setField(field, constant - OpenGlHelper.field_77478_a);
    }

    boolean run() {
        if (!this.isEnabled() || this.errored) {
            return false;
        }
        if (this.hook != null) {
            this.hook.onPreRender(this);
        }
        GL20.glUseProgram((int)this.programID);
        boolean flag = false;
        if (this.compoundLocation != null) {
            RenderState rs = this.compoundLocation.remove(0);
            this.focusLocation = rs.position;
            this.modelview = rs.modelview;
            this.projection = rs.projection;
            this.setIntensity(rs.intensity);
            if (rs.variables != null) {
                for (Map.Entry e : rs.variables.entrySet()) {
                    this.setField((String)e.getKey(), e.getValue());
                }
            }
            if (this.compoundLocation.isEmpty()) {
                this.compoundLocation = null;
            } else {
                flag = true;
            }
        }
        if (this.focusLocation != null) {
            this.applyFocus();
        }
        if (this.modelview != null && this.projection != null) {
            this.applyMatrices();
        }
        this.applyVariables();
        this.applyField("time", Minecraft.func_71410_x().field_71439_g.field_70173_aa);
        this.applyField("screenWidth", Minecraft.func_71410_x().field_71443_c);
        this.applyField("screenHeight", Minecraft.func_71410_x().field_71440_d);
        if (this.hook != null) {
            this.hook.onPostRender(this);
        }
        return flag;
    }

    void checkForError() {
        if (!this.errorChecked) {
            this.errorChecked = true;
            int res = GL11.glGetError();
            String data = "";
            while (res != 0) {
                data = data + "," + Util.translateGLErrorString((int)res);
                res = GL11.glGetError();
            }
            if (!data.isEmpty()) {
                ShaderRegistry.error(this.owner, this.identifier, "Shader " + this + " threw errors: " + data + "!", null);
            }
        }
    }

    public boolean needsErrorChecking() {
        return !this.errorChecked;
    }

    void markErrored() {
        this.errored = true;
    }

    private void applyVariables() {
        for (Map.Entry<String, Object> e : this.variables.entrySet()) {
            this.applyField(e.getKey(), e.getValue());
        }
    }

    private void applyFocus() {
        FloatBuffer b = BufferUtils.createFloatBuffer((int)3);
        this.focusLocation.store(b);
        b.rewind();
        int loc = GL20.glGetUniformLocation((int)this.programID, (CharSequence)"focus");
        GL20.glUniform3((int)loc, (FloatBuffer)b);
    }

    private void applyMatrices() {
        FloatBuffer b1 = BufferUtils.createFloatBuffer((int)16);
        this.modelview.store(b1);
        b1.rewind();
        FloatBuffer b2 = BufferUtils.createFloatBuffer((int)16);
        this.projection.store(b2);
        b2.rewind();
        int loc = GL20.glGetUniformLocation((int)this.programID, (CharSequence)"modelview");
        GL20.glUniformMatrix4((int)loc, (boolean)false, (FloatBuffer)b1);
        loc = GL20.glGetUniformLocation((int)this.programID, (CharSequence)"projection");
        GL20.glUniformMatrix4((int)loc, (boolean)false, (FloatBuffer)b2);
    }

    private void applyField(String f, Object val) {
        int loc = GL20.glGetUniformLocation((int)this.programID, (CharSequence)f);
        if (val instanceof Integer) {
            GL20.glUniform1i((int)loc, (int)((Integer)val));
        } else if (val instanceof Float) {
            GL20.glUniform1f((int)loc, (float)((Float)val).floatValue());
        } else if (val instanceof Double) {
            GL20.glUniform1f((int)loc, (float)((Double)val).floatValue());
        } else if (val instanceof Vec3) {
            Vec3 vec = (Vec3)val;
            GL20.glUniform3f((int)loc, (float)((float)vec.field_72450_a), (float)((float)vec.field_72448_b), (float)((float)vec.field_72449_c));
        } else if (val instanceof Vec4) {
            Vec4 vec = (Vec4)val;
            GL20.glUniform4f((int)loc, (float)vec.a, (float)vec.b, (float)vec.c, (float)vec.d);
        } else if (val instanceof int[]) {
            int[] data = (int[])val;
            IntBuffer buf = BufferUtils.createIntBuffer((int)data.length);
            buf.put(data);
            buf.rewind();
            GL20.glUniform1((int)loc, (IntBuffer)buf);
        } else if (val instanceof float[]) {
            float[] data = (float[])val;
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)data.length);
            buf.put(data);
            buf.rewind();
            GL20.glUniform1((int)loc, (FloatBuffer)buf);
        } else if (val instanceof Vec3[]) {
            Vec3[] data = (Vec3[])val;
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)(data.length * 3));
            for (Vec3 vec : data) {
                buf.put(vec == null ? 0.0f : (float)vec.field_72450_a);
                buf.put(vec == null ? 0.0f : (float)vec.field_72448_b);
                buf.put(vec == null ? 0.0f : (float)vec.field_72449_c);
            }
            buf.rewind();
            GL20.glUniform3((int)loc, (FloatBuffer)buf);
        } else if (val instanceof Vec4[]) {
            Vec4[] data = (Vec4[])val;
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)(data.length * 4));
            for (Vec4 vec : data) {
                buf.put(vec == null ? 0.0f : vec.a);
                buf.put(vec == null ? 0.0f : vec.b);
                buf.put(vec == null ? 0.0f : vec.c);
                buf.put(vec == null ? 0.0f : vec.d);
            }
            buf.rewind();
            GL20.glUniform4((int)loc, (FloatBuffer)buf);
        }
    }

    public boolean hasOngoingFoci() {
        return this.compoundLocation != null;
    }

    private void register() {
        this.programID = GL20.glCreateProgram();
        if (this.programID == 0) {
            ShaderRegistry.error(this.owner, this.identifier, "Shader program could not be assigned an ID!", null);
        }
        GL20.glAttachShader((int)this.programID, (int)this.vertexID);
        GL20.glAttachShader((int)this.programID, (int)this.fragmentID);
        GL20.glLinkProgram((int)this.programID);
        if (GL20.glGetProgrami((int)this.programID, (int)35714) == 0) {
            ShaderRegistry.error(this.owner, this.identifier, "Shader was not linked properly: " + ShaderRegistry.parseError(this.programID), null);
        }
        GL20.glValidateProgram((int)this.programID);
        if (GL20.glGetProgrami((int)this.programID, (int)35715) == 0) {
            ShaderRegistry.error(this.owner, this.identifier, "Shader failed to validate: " + ShaderRegistry.parseError(this.programID), null);
        }
    }

    public void updateEnabled() {
        if (this.hook != null) {
            this.hook.updateEnabled(this);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String toString() {
        return this.identifier + " #" + this.programID + " [" + this.vertexID + "/" + this.fragmentID + "]";
    }

    @Override
    public int compareTo(ShaderProgram o) {
        return Integer.compare(this.ordering, o.ordering);
    }

    public static class RenderState {
        private Vector3f position;
        private Matrix4f modelview;
        private Matrix4f projection;
        private float intensity;
        private HashMap<String, Object> variables;

        private RenderState(Vector3f vec, Matrix4f m, Matrix4f p) {
            this(vec, m, p, 1.0f, null);
        }

        private RenderState(Vector3f vec, Matrix4f m, Matrix4f p, float f, HashMap<String, Object> vars) {
            this.position = vec;
            this.modelview = m;
            this.projection = p;
            this.intensity = f;
            this.variables = vars;
        }
    }
}

