/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.IO.LuaBlock;
import java.math.BigDecimal;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class BoundedValue<N extends Number> {
    private final Class<N> typeClass;
    private final boolean isDecimalType;
    private double value;
    private double step;
    private final double minValue;
    private final double maxValue;

    public BoundedValue(N min, N max) {
        this(min, max, (((Number)min).doubleValue() + ((Number)max).doubleValue()) / 2.0);
    }

    public BoundedValue(N min, N max, N init) {
        this(min, max, ((Number)init).doubleValue());
    }

    private BoundedValue(N min, N max, double init) {
        this.typeClass = min.getClass();
        this.minValue = ((Number)min).doubleValue();
        this.maxValue = ((Number)max).doubleValue();
        this.value = MathHelper.func_151237_a((double)init, (double)this.minValue, (double)this.maxValue);
        this.isDecimalType = min instanceof Double || min instanceof Float || min instanceof BigDecimal;
    }

    private BoundedValue(double min, double max, double init, double step, boolean dec, Class type) {
        this.minValue = min;
        this.maxValue = max;
        this.value = init;
        this.step = step;
        this.isDecimalType = dec;
        this.typeClass = type;
    }

    public BoundedValue setStep(N step) {
        this.step = this.isDecimalType ? ((Number)step).doubleValue() : 1.0;
        return this;
    }

    public boolean increase() {
        if (this.value + this.step <= this.maxValue) {
            this.value += this.step;
            return true;
        }
        return false;
    }

    public boolean decrease() {
        if (this.value - this.step >= this.minValue) {
            this.value -= this.step;
            return true;
        }
        return false;
    }

    public void setValue(N val) {
        this.value = MathHelper.func_151237_a((double)((Number)val).doubleValue(), (double)this.minValue, (double)this.maxValue);
    }

    public void setFraction(double f) {
        this.value = this.minValue + f * (this.maxValue - this.minValue);
    }

    public float getFraction() {
        return (float)((this.value - this.minValue) / (this.maxValue - this.minValue));
    }

    public double getValue() {
        return this.value;
    }

    public double getStep() {
        return this.step;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("type", this.typeClass.getName());
        tag.func_74757_a("decimal", this.isDecimalType);
        tag.func_74780_a("val", this.value);
        tag.func_74780_a("min", this.minValue);
        tag.func_74780_a("max", this.maxValue);
        tag.func_74780_a("step", this.step);
    }

    public static BoundedValue readFromNBT(NBTTagCompound tag) {
        try {
            return new BoundedValue(tag.func_74769_h("min"), tag.func_74769_h("max"), tag.func_74769_h("val"), tag.func_74769_h("step"), tag.func_74767_n("decimal"), Class.forName(tag.func_74779_i("type")));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BoundedValue readFromLuaBlock(LuaBlock lb) {
        try {
            return new BoundedValue(lb.getDouble("min"), lb.getDouble("max"), lb.getDouble("val"), lb.getDouble("step"), lb.getBoolean("decimal"), Class.forName(lb.getString("type")));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return "[" + this.minValue + " > " + this.maxValue + "] @ " + this.value + "x" + this.step + ", " + this.isDecimalType;
    }
}

