/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Instantiable.GridDistortion;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class CubePoints {
    public final CubeVertex x1y1z1;
    public final CubeVertex x2y1z1;
    public final CubeVertex x1y1z2;
    public final CubeVertex x2y1z2;
    public final CubeVertex x1y2z1;
    public final CubeVertex x2y2z1;
    public final CubeVertex x1y2z2;
    public final CubeVertex x2y2z2;
    private final HashMap<String, CubeVertex> vertices = new HashMap();

    public CubePoints(Vec3 x1y1z1, Vec3 x2y1z1, Vec3 x1y1z2, Vec3 x2y1z2, Vec3 x1y2z1, Vec3 x2y2z1, Vec3 x1y2z2, Vec3 x2y2z2) {
        this.x1y1z1 = new CubeVertex("111", x1y1z1);
        this.x2y1z1 = new CubeVertex("211", x2y1z1);
        this.x1y1z2 = new CubeVertex("112", x1y1z2);
        this.x2y1z2 = new CubeVertex("212", x2y1z2);
        this.x1y2z1 = new CubeVertex("121", x1y2z1);
        this.x2y2z1 = new CubeVertex("221", x2y2z1);
        this.x1y2z2 = new CubeVertex("122", x1y2z2);
        this.x2y2z2 = new CubeVertex("222", x2y2z2);
    }

    private CubePoints(CubeVertex x1y1z1, CubeVertex x2y1z1, CubeVertex x1y1z2, CubeVertex x2y1z2, CubeVertex x1y2z1, CubeVertex x2y2z1, CubeVertex x1y2z2, CubeVertex x2y2z2) {
        this.x1y1z1 = new CubeVertex(x1y1z1);
        this.x2y1z1 = new CubeVertex(x2y1z1);
        this.x1y1z2 = new CubeVertex(x1y1z2);
        this.x2y1z2 = new CubeVertex(x2y1z2);
        this.x1y2z1 = new CubeVertex(x1y2z1);
        this.x2y2z1 = new CubeVertex(x2y2z1);
        this.x1y2z2 = new CubeVertex(x1y2z2);
        this.x2y2z2 = new CubeVertex(x2y2z2);
    }

    public Vec3 getCenter() {
        Vec3 vec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (CubeVertex cv : this.vertices.values()) {
            vec.field_72450_a += ((CubeVertex)cv).position.field_72450_a;
            vec.field_72448_b += ((CubeVertex)cv).position.field_72448_b;
            vec.field_72449_c += ((CubeVertex)cv).position.field_72449_c;
        }
        vec.field_72450_a /= (double)this.vertices.size();
        vec.field_72448_b /= (double)this.vertices.size();
        vec.field_72449_c /= (double)this.vertices.size();
        return vec;
    }

    public void applyOffset(ForgeDirection side, GridDistortion.OffsetGroup off) {
        switch (side) {
            case DOWN: {
                ((CubeVertex)this.x1y1z1).position.field_72450_a += off.offsetAMM;
                ((CubeVertex)this.x2y1z1).position.field_72450_a += off.offsetAPM;
                ((CubeVertex)this.x1y1z2).position.field_72450_a += off.offsetAMP;
                ((CubeVertex)this.x2y1z2).position.field_72450_a += off.offsetAPP;
                ((CubeVertex)this.x1y1z1).position.field_72449_c += off.offsetBMM;
                ((CubeVertex)this.x2y1z1).position.field_72449_c += off.offsetBPM;
                ((CubeVertex)this.x1y1z2).position.field_72449_c += off.offsetBMP;
                ((CubeVertex)this.x2y1z2).position.field_72449_c += off.offsetBPP;
                break;
            }
            case UP: {
                ((CubeVertex)this.x1y2z1).position.field_72450_a += off.offsetAMM;
                ((CubeVertex)this.x2y2z1).position.field_72450_a += off.offsetAPM;
                ((CubeVertex)this.x1y2z2).position.field_72450_a += off.offsetAMP;
                ((CubeVertex)this.x2y2z2).position.field_72450_a += off.offsetAPP;
                ((CubeVertex)this.x1y2z1).position.field_72449_c += off.offsetBMM;
                ((CubeVertex)this.x2y2z1).position.field_72449_c += off.offsetBPM;
                ((CubeVertex)this.x1y2z2).position.field_72449_c += off.offsetBMP;
                ((CubeVertex)this.x2y2z2).position.field_72449_c += off.offsetBPP;
                break;
            }
            case WEST: {
                ((CubeVertex)this.x1y1z1).position.field_72448_b += off.offsetAMM;
                ((CubeVertex)this.x1y2z1).position.field_72448_b += off.offsetAMP;
                ((CubeVertex)this.x1y1z2).position.field_72448_b += off.offsetAPM;
                ((CubeVertex)this.x1y2z2).position.field_72448_b += off.offsetAPP;
                ((CubeVertex)this.x1y1z1).position.field_72449_c += off.offsetBMM;
                ((CubeVertex)this.x1y2z1).position.field_72449_c += off.offsetBMP;
                ((CubeVertex)this.x1y1z2).position.field_72449_c += off.offsetBPM;
                ((CubeVertex)this.x1y2z2).position.field_72449_c += off.offsetBPP;
                break;
            }
            case EAST: {
                ((CubeVertex)this.x2y1z1).position.field_72448_b += off.offsetAMM;
                ((CubeVertex)this.x2y2z1).position.field_72448_b += off.offsetAMP;
                ((CubeVertex)this.x2y1z2).position.field_72448_b += off.offsetAPM;
                ((CubeVertex)this.x2y2z2).position.field_72448_b += off.offsetAPP;
                ((CubeVertex)this.x2y1z1).position.field_72449_c += off.offsetBMM;
                ((CubeVertex)this.x2y2z1).position.field_72449_c += off.offsetBMP;
                ((CubeVertex)this.x2y1z2).position.field_72449_c += off.offsetBPM;
                ((CubeVertex)this.x2y2z2).position.field_72449_c += off.offsetBPP;
                break;
            }
            case NORTH: {
                ((CubeVertex)this.x1y1z1).position.field_72450_a += off.offsetAMM;
                ((CubeVertex)this.x2y1z1).position.field_72450_a += off.offsetAPM;
                ((CubeVertex)this.x1y2z1).position.field_72450_a += off.offsetAMP;
                ((CubeVertex)this.x2y2z1).position.field_72450_a += off.offsetAPP;
                ((CubeVertex)this.x1y1z1).position.field_72448_b += off.offsetBMM;
                ((CubeVertex)this.x2y1z1).position.field_72448_b += off.offsetBPM;
                ((CubeVertex)this.x1y2z1).position.field_72448_b += off.offsetBMP;
                ((CubeVertex)this.x2y2z1).position.field_72448_b += off.offsetBPP;
                break;
            }
            case SOUTH: {
                ((CubeVertex)this.x1y1z2).position.field_72450_a += off.offsetAMM;
                ((CubeVertex)this.x2y1z2).position.field_72450_a += off.offsetAPM;
                ((CubeVertex)this.x1y2z2).position.field_72450_a += off.offsetAMP;
                ((CubeVertex)this.x2y2z2).position.field_72450_a += off.offsetAPP;
                ((CubeVertex)this.x1y1z2).position.field_72448_b += off.offsetBMM;
                ((CubeVertex)this.x2y1z2).position.field_72448_b += off.offsetBPM;
                ((CubeVertex)this.x1y2z2).position.field_72448_b += off.offsetBMP;
                ((CubeVertex)this.x2y2z2).position.field_72448_b += off.offsetBPP;
                break;
            }
        }
    }

    public void clamp() {
        ((CubeVertex)this.x1y1z1).position.field_72450_a = MathHelper.func_151237_a((double)((CubeVertex)this.x1y1z1).position.field_72450_a, (double)0.0, (double)1.0);
        ((CubeVertex)this.x1y1z1).position.field_72448_b = MathHelper.func_151237_a((double)((CubeVertex)this.x1y1z1).position.field_72448_b, (double)0.0, (double)1.0);
        ((CubeVertex)this.x1y1z1).position.field_72449_c = MathHelper.func_151237_a((double)((CubeVertex)this.x1y1z1).position.field_72449_c, (double)0.0, (double)1.0);
        ((CubeVertex)this.x2y1z1).position.field_72450_a = MathHelper.func_151237_a((double)((CubeVertex)this.x2y1z1).position.field_72450_a, (double)0.0, (double)1.0);
        ((CubeVertex)this.x2y1z1).position.field_72448_b = MathHelper.func_151237_a((double)((CubeVertex)this.x2y1z1).position.field_72448_b, (double)0.0, (double)1.0);
        ((CubeVertex)this.x2y1z1).position.field_72449_c = MathHelper.func_151237_a((double)((CubeVertex)this.x2y1z1).position.field_72449_c, (double)0.0, (double)1.0);
        ((CubeVertex)this.x1y1z2).position.field_72450_a = MathHelper.func_151237_a((double)((CubeVertex)this.x1y1z2).position.field_72450_a, (double)0.0, (double)1.0);
        ((CubeVertex)this.x1y1z2).position.field_72448_b = MathHelper.func_151237_a((double)((CubeVertex)this.x1y1z2).position.field_72448_b, (double)0.0, (double)1.0);
        ((CubeVertex)this.x1y1z2).position.field_72449_c = MathHelper.func_151237_a((double)((CubeVertex)this.x1y1z2).position.field_72449_c, (double)0.0, (double)1.0);
        ((CubeVertex)this.x2y1z2).position.field_72450_a = MathHelper.func_151237_a((double)((CubeVertex)this.x2y1z2).position.field_72450_a, (double)0.0, (double)1.0);
        ((CubeVertex)this.x2y1z2).position.field_72448_b = MathHelper.func_151237_a((double)((CubeVertex)this.x2y1z2).position.field_72448_b, (double)0.0, (double)1.0);
        ((CubeVertex)this.x2y1z2).position.field_72449_c = MathHelper.func_151237_a((double)((CubeVertex)this.x2y1z2).position.field_72449_c, (double)0.0, (double)1.0);
        ((CubeVertex)this.x1y2z1).position.field_72450_a = MathHelper.func_151237_a((double)((CubeVertex)this.x1y2z1).position.field_72450_a, (double)0.0, (double)1.0);
        ((CubeVertex)this.x1y2z1).position.field_72448_b = MathHelper.func_151237_a((double)((CubeVertex)this.x1y2z1).position.field_72448_b, (double)0.0, (double)1.0);
        ((CubeVertex)this.x1y2z1).position.field_72449_c = MathHelper.func_151237_a((double)((CubeVertex)this.x1y2z1).position.field_72449_c, (double)0.0, (double)1.0);
        ((CubeVertex)this.x2y2z1).position.field_72450_a = MathHelper.func_151237_a((double)((CubeVertex)this.x2y2z1).position.field_72450_a, (double)0.0, (double)1.0);
        ((CubeVertex)this.x2y2z1).position.field_72448_b = MathHelper.func_151237_a((double)((CubeVertex)this.x2y2z1).position.field_72448_b, (double)0.0, (double)1.0);
        ((CubeVertex)this.x2y2z1).position.field_72449_c = MathHelper.func_151237_a((double)((CubeVertex)this.x2y2z1).position.field_72449_c, (double)0.0, (double)1.0);
        ((CubeVertex)this.x1y2z2).position.field_72450_a = MathHelper.func_151237_a((double)((CubeVertex)this.x1y2z2).position.field_72450_a, (double)0.0, (double)1.0);
        ((CubeVertex)this.x1y2z2).position.field_72448_b = MathHelper.func_151237_a((double)((CubeVertex)this.x1y2z2).position.field_72448_b, (double)0.0, (double)1.0);
        ((CubeVertex)this.x1y2z2).position.field_72449_c = MathHelper.func_151237_a((double)((CubeVertex)this.x1y2z2).position.field_72449_c, (double)0.0, (double)1.0);
        ((CubeVertex)this.x2y2z2).position.field_72450_a = MathHelper.func_151237_a((double)((CubeVertex)this.x2y2z2).position.field_72450_a, (double)0.0, (double)1.0);
        ((CubeVertex)this.x2y2z2).position.field_72448_b = MathHelper.func_151237_a((double)((CubeVertex)this.x2y2z2).position.field_72448_b, (double)0.0, (double)1.0);
        ((CubeVertex)this.x2y2z2).position.field_72449_c = MathHelper.func_151237_a((double)((CubeVertex)this.x2y2z2).position.field_72449_c, (double)0.0, (double)1.0);
    }

    public void expand(double amt) {
        this.expand(amt, amt, amt);
    }

    public void expand(double x, double y, double z) {
        ((CubeVertex)this.x1y1z1).position.field_72450_a -= x;
        ((CubeVertex)this.x1y1z1).position.field_72448_b -= y;
        ((CubeVertex)this.x1y1z1).position.field_72449_c -= z;
        ((CubeVertex)this.x2y1z1).position.field_72450_a += x;
        ((CubeVertex)this.x2y1z1).position.field_72448_b -= y;
        ((CubeVertex)this.x2y1z1).position.field_72449_c -= z;
        ((CubeVertex)this.x1y2z1).position.field_72450_a -= x;
        ((CubeVertex)this.x1y2z1).position.field_72448_b += y;
        ((CubeVertex)this.x1y2z1).position.field_72449_c -= z;
        ((CubeVertex)this.x2y2z1).position.field_72450_a += x;
        ((CubeVertex)this.x2y2z1).position.field_72448_b += y;
        ((CubeVertex)this.x2y2z1).position.field_72449_c -= z;
        ((CubeVertex)this.x1y1z2).position.field_72450_a -= x;
        ((CubeVertex)this.x1y1z2).position.field_72448_b -= y;
        ((CubeVertex)this.x1y1z2).position.field_72449_c += z;
        ((CubeVertex)this.x2y1z2).position.field_72450_a += x;
        ((CubeVertex)this.x2y1z2).position.field_72448_b -= y;
        ((CubeVertex)this.x2y1z2).position.field_72449_c += z;
        ((CubeVertex)this.x1y2z2).position.field_72450_a -= x;
        ((CubeVertex)this.x1y2z2).position.field_72448_b += y;
        ((CubeVertex)this.x1y2z2).position.field_72449_c += z;
        ((CubeVertex)this.x2y2z2).position.field_72450_a += x;
        ((CubeVertex)this.x2y2z2).position.field_72448_b += y;
        ((CubeVertex)this.x2y2z2).position.field_72449_c += z;
    }

    public void setSidePosition(ForgeDirection side, double val) {
        switch (side) {
            case DOWN: {
                ((CubeVertex)this.x1y1z1).position.field_72448_b = val;
                ((CubeVertex)this.x2y1z1).position.field_72448_b = val;
                ((CubeVertex)this.x2y1z2).position.field_72448_b = val;
                ((CubeVertex)this.x1y1z2).position.field_72448_b = val;
                break;
            }
            case UP: {
                ((CubeVertex)this.x1y2z1).position.field_72448_b = val;
                ((CubeVertex)this.x2y2z1).position.field_72448_b = val;
                ((CubeVertex)this.x2y2z2).position.field_72448_b = val;
                ((CubeVertex)this.x1y2z2).position.field_72448_b = val;
                break;
            }
            case WEST: {
                ((CubeVertex)this.x1y1z1).position.field_72450_a = val;
                ((CubeVertex)this.x1y2z1).position.field_72450_a = val;
                ((CubeVertex)this.x1y2z2).position.field_72450_a = val;
                ((CubeVertex)this.x1y1z2).position.field_72450_a = val;
                break;
            }
            case EAST: {
                ((CubeVertex)this.x2y1z1).position.field_72450_a = val;
                ((CubeVertex)this.x2y2z1).position.field_72450_a = val;
                ((CubeVertex)this.x2y2z2).position.field_72450_a = val;
                ((CubeVertex)this.x2y1z2).position.field_72450_a = val;
                break;
            }
            case NORTH: {
                ((CubeVertex)this.x1y1z1).position.field_72449_c = val;
                ((CubeVertex)this.x1y2z1).position.field_72449_c = val;
                ((CubeVertex)this.x2y2z1).position.field_72449_c = val;
                ((CubeVertex)this.x2y1z1).position.field_72449_c = val;
                break;
            }
            case SOUTH: {
                ((CubeVertex)this.x1y1z2).position.field_72449_c = val;
                ((CubeVertex)this.x1y2z2).position.field_72449_c = val;
                ((CubeVertex)this.x2y2z2).position.field_72449_c = val;
                ((CubeVertex)this.x2y1z2).position.field_72449_c = val;
                break;
            }
        }
    }

    public CubePoints copy() {
        return new CubePoints(this.x1y1z1, this.x2y1z1, this.x1y1z2, this.x2y1z2, this.x1y2z1, this.x2y2z1, this.x1y2z2, this.x2y2z2);
    }

    public Collection<CubeVertex> getVertices() {
        return Collections.unmodifiableCollection(this.vertices.values());
    }

    public CubeVertex getVertex(String id) {
        return this.vertices.get(id);
    }

    public void applyVelocities() {
        this.applyVelocities(null);
    }

    public void applyVelocities(AxisAlignedBB bounds) {
        for (CubeVertex v : this.vertices.values()) {
            v.applyVelocity(bounds);
        }
    }

    public void multiplyVelocities(double d) {
        for (CubeVertex v : this.vertices.values()) {
            v.velocity.field_72450_a *= d;
            v.velocity.field_72448_b *= d;
            v.velocity.field_72449_c *= d;
        }
    }

    public void setRandomVelocities(double bounds) {
        for (CubeVertex v : this.vertices.values()) {
            v.velocity.field_72450_a = ReikaRandomHelper.getRandomPlusMinus(0.0, bounds);
            v.velocity.field_72448_b = ReikaRandomHelper.getRandomPlusMinus(0.0, bounds);
            v.velocity.field_72449_c = ReikaRandomHelper.getRandomPlusMinus(0.0, bounds);
        }
    }

    public void setVelocities(Vec3 vec) {
        for (CubeVertex v : this.vertices.values()) {
            v.velocity.field_72450_a = vec.field_72450_a;
            v.velocity.field_72448_b = vec.field_72448_b;
            v.velocity.field_72449_c = vec.field_72449_c;
        }
    }

    public static CubePoints fullBlock() {
        return new CubePoints(Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0), Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0), Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)1.0, (double)0.0, (double)1.0), Vec3.func_72443_a((double)0.0, (double)1.0, (double)0.0), Vec3.func_72443_a((double)1.0, (double)1.0, (double)0.0), Vec3.func_72443_a((double)0.0, (double)1.0, (double)1.0), Vec3.func_72443_a((double)1.0, (double)1.0, (double)1.0));
    }

    public void renderIconOnSides(IBlockAccess world, int x, int y, int z, IIcon ico, Tessellator v5) {
        v5.func_78372_c((float)x, (float)y, (float)z);
        double u = ico.func_94209_e();
        double du = ico.func_94212_f();
        double v = ico.func_94206_g();
        double dv = ico.func_94210_h();
        ForgeDirection dir = ForgeDirection.DOWN;
        this.x1y1z1.drawWithUV(v5, dir, u, v);
        this.x2y1z1.drawWithUV(v5, dir, du, v);
        this.x2y1z2.drawWithUV(v5, dir, du, dv);
        this.x1y1z2.drawWithUV(v5, dir, u, dv);
        dir = ForgeDirection.UP;
        this.x1y2z2.drawWithUV(v5, dir, u, dv);
        this.x2y2z2.drawWithUV(v5, dir, du, dv);
        this.x2y2z1.drawWithUV(v5, dir, du, v);
        this.x1y2z1.drawWithUV(v5, dir, u, v);
        dir = ForgeDirection.WEST;
        this.x1y1z2.drawWithUV(v5, dir, u, dv);
        this.x1y2z2.drawWithUV(v5, dir, du, dv);
        this.x1y2z1.drawWithUV(v5, dir, du, v);
        this.x1y1z1.drawWithUV(v5, dir, u, v);
        dir = ForgeDirection.EAST;
        this.x2y1z1.drawWithUV(v5, dir, u, v);
        this.x2y2z1.drawWithUV(v5, dir, du, v);
        this.x2y2z2.drawWithUV(v5, dir, du, dv);
        this.x2y1z2.drawWithUV(v5, dir, u, dv);
        dir = ForgeDirection.NORTH;
        this.x1y1z1.drawWithUV(v5, dir, u, v);
        this.x1y2z1.drawWithUV(v5, dir, u, dv);
        this.x2y2z1.drawWithUV(v5, dir, du, dv);
        this.x2y1z1.drawWithUV(v5, dir, du, v);
        dir = ForgeDirection.SOUTH;
        this.x2y1z2.drawWithUV(v5, dir, du, v);
        this.x2y2z2.drawWithUV(v5, dir, du, dv);
        this.x1y2z2.drawWithUV(v5, dir, u, dv);
        this.x1y1z2.drawWithUV(v5, dir, u, v);
        v5.func_78372_c((float)(-x), (float)(-y), (float)(-z));
    }

    public final class CubeVertex {
        private final Vec3 position;
        public final Vec3 velocity = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        public final String ID;

        private CubeVertex(String id, Vec3 pos) {
            this.position = pos;
            this.ID = id;
            this.parent().vertices.put(id, this);
        }

        private CubeVertex(CubeVertex pos) {
            this(pos.ID, Vec3.func_72443_a((double)pos.position.field_72450_a, (double)pos.position.field_72448_b, (double)pos.position.field_72449_c));
        }

        public void applyVelocity() {
            this.applyVelocity(null);
        }

        public void applyVelocity(AxisAlignedBB bounds) {
            this.position.field_72450_a += this.velocity.field_72450_a;
            this.position.field_72448_b += this.velocity.field_72448_b;
            this.position.field_72449_c += this.velocity.field_72449_c;
            if (bounds != null) {
                if (this.position.field_72450_a >= bounds.field_72336_d) {
                    this.velocity.field_72450_a = -this.velocity.field_72450_a;
                    this.position.field_72450_a = bounds.field_72336_d;
                } else if (this.position.field_72450_a <= bounds.field_72340_a) {
                    this.velocity.field_72450_a = -this.velocity.field_72450_a;
                    this.position.field_72450_a = bounds.field_72340_a;
                }
                if (this.position.field_72448_b >= bounds.field_72337_e) {
                    this.velocity.field_72448_b = -this.velocity.field_72448_b;
                    this.position.field_72448_b = bounds.field_72337_e;
                } else if (this.position.field_72448_b <= bounds.field_72338_b) {
                    this.velocity.field_72448_b = -this.velocity.field_72448_b;
                    this.position.field_72448_b = bounds.field_72338_b;
                }
                if (this.position.field_72449_c >= bounds.field_72334_f) {
                    this.velocity.field_72449_c = -this.velocity.field_72449_c;
                    this.position.field_72449_c = bounds.field_72334_f;
                } else if (this.position.field_72449_c <= bounds.field_72339_c) {
                    this.velocity.field_72449_c = -this.velocity.field_72449_c;
                    this.position.field_72449_c = bounds.field_72339_c;
                }
            }
        }

        public double textureU(IIcon icon, ForgeDirection side) {
            switch (side) {
                case DOWN: {
                    return icon.func_94214_a(16.0 * this.position.field_72450_a);
                }
                case UP: {
                    return icon.func_94214_a(16.0 * this.position.field_72450_a);
                }
                case WEST: {
                    return icon.func_94214_a(16.0 * this.position.field_72449_c);
                }
                case EAST: {
                    return icon.func_94214_a(16.0 * this.position.field_72449_c);
                }
                case NORTH: {
                    return icon.func_94214_a(16.0 * this.position.field_72450_a);
                }
                case SOUTH: {
                    return icon.func_94214_a(16.0 * this.position.field_72450_a);
                }
            }
            return 0.0;
        }

        public double textureV(IIcon icon, ForgeDirection side) {
            switch (side) {
                case DOWN: {
                    return icon.func_94207_b(16.0 * this.position.field_72449_c);
                }
                case UP: {
                    return icon.func_94207_b(16.0 * this.position.field_72449_c);
                }
                case WEST: {
                    return icon.func_94207_b(16.0 * this.position.field_72448_b);
                }
                case EAST: {
                    return icon.func_94207_b(16.0 * this.position.field_72448_b);
                }
                case NORTH: {
                    return icon.func_94207_b(16.0 * this.position.field_72448_b);
                }
                case SOUTH: {
                    return icon.func_94207_b(16.0 * this.position.field_72448_b);
                }
            }
            return 0.0;
        }

        public void draw(Tessellator v5, IIcon ico, ForgeDirection side) {
            v5.func_78374_a(this.position.field_72450_a, this.position.field_72448_b, this.position.field_72449_c, this.textureU(ico, side), this.textureV(ico, side));
        }

        public void drawWithUV(Tessellator v5, ForgeDirection side, double u, double v) {
            v5.func_78374_a(this.position.field_72450_a, this.position.field_72448_b, this.position.field_72449_c, u, v);
        }

        public Vec3 getOffsetFromCenter() {
            Vec3 v = this.parent().getCenter();
            Vec3 v2 = this.position.func_72444_a(v);
            return v2;
        }

        public void offset(double x, double y, double z) {
            this.position.field_72450_a += x;
            this.position.field_72448_b += y;
            this.position.field_72449_c += z;
        }

        public void setPosition(CubeVertex cv) {
            this.setPosition(cv.position.field_72450_a, cv.position.field_72448_b, cv.position.field_72449_c);
        }

        public void setPosition(double x, double y, double z) {
            this.position.field_72450_a = x;
            this.position.field_72448_b = y;
            this.position.field_72449_c = z;
        }

        private CubePoints parent() {
            return CubePoints.this;
        }
    }
}

